/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Field;
import sun.reflect.UnsafeFieldAccessorImpl;

class UnsafeLongFieldAccessorImpl
extends UnsafeFieldAccessorImpl {
    UnsafeLongFieldAccessorImpl(Field field) {
        super(field);
    }

    @Override
    public Object get(Object object) throws IllegalArgumentException {
        return new Long(this.getLong(object));
    }

    @Override
    public boolean getBoolean(Object object) throws IllegalArgumentException {
        throw this.newGetBooleanIllegalArgumentException();
    }

    @Override
    public byte getByte(Object object) throws IllegalArgumentException {
        throw this.newGetByteIllegalArgumentException();
    }

    @Override
    public char getChar(Object object) throws IllegalArgumentException {
        throw this.newGetCharIllegalArgumentException();
    }

    @Override
    public short getShort(Object object) throws IllegalArgumentException {
        throw this.newGetShortIllegalArgumentException();
    }

    @Override
    public int getInt(Object object) throws IllegalArgumentException {
        throw this.newGetIntIllegalArgumentException();
    }

    @Override
    public long getLong(Object object) throws IllegalArgumentException {
        this.ensureObj(object);
        return unsafe.getLong(object, this.fieldOffset);
    }

    @Override
    public float getFloat(Object object) throws IllegalArgumentException {
        return this.getLong(object);
    }

    @Override
    public double getDouble(Object object) throws IllegalArgumentException {
        return this.getLong(object);
    }

    @Override
    public void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(object);
        if (this.isFinal) {
            this.throwFinalFieldIllegalAccessException(object2);
        }
        if (object2 == null) {
            this.throwSetIllegalArgumentException(object2);
        }
        if (object2 instanceof Byte) {
            unsafe.putLong(object, this.fieldOffset, (long)((Byte)object2).byteValue());
            return;
        }
        if (object2 instanceof Short) {
            unsafe.putLong(object, this.fieldOffset, (long)((Short)object2).shortValue());
            return;
        }
        if (object2 instanceof Character) {
            unsafe.putLong(object, this.fieldOffset, (long)((Character)object2).charValue());
            return;
        }
        if (object2 instanceof Integer) {
            unsafe.putLong(object, this.fieldOffset, (long)((Integer)object2).intValue());
            return;
        }
        if (object2 instanceof Long) {
            unsafe.putLong(object, this.fieldOffset, (long)((Long)object2));
            return;
        }
        this.throwSetIllegalArgumentException(object2);
    }

    @Override
    public void setBoolean(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(bl);
    }

    @Override
    public void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(object, by);
    }

    @Override
    public void setChar(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(object, c);
    }

    @Override
    public void setShort(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(object, s);
    }

    @Override
    public void setInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(object, n);
    }

    @Override
    public void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(object);
        if (this.isFinal) {
            this.throwFinalFieldIllegalAccessException(l);
        }
        unsafe.putLong(object, this.fieldOffset, l);
    }

    @Override
    public void setFloat(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(f);
    }

    @Override
    public void setDouble(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(d);
    }
}

