/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.mailto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Permission;
import sun.net.smtp.SmtpClient;
import sun.net.www.MessageHeader;
import sun.net.www.ParseUtil;
import sun.net.www.URLConnection;

public class MailToURLConnection
extends URLConnection {
    InputStream is = null;
    OutputStream os = null;
    SmtpClient client;
    Permission permission;
    private int connectTimeout = -1;
    private int readTimeout = -1;

    MailToURLConnection(URL uRL) {
        super(uRL);
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.add("content-type", "text/html");
        this.setProperties(messageHeader);
    }

    String getFromAddress() {
        String string = System.getProperty("user.fromaddr");
        if (string == null) {
            string = System.getProperty("user.name");
            if (string != null) {
                String string2 = System.getProperty("mail.host");
                if (string2 == null) {
                    try {
                        string2 = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                string = string + "@" + string2;
            } else {
                string = "";
            }
        }
        return string;
    }

    @Override
    public void connect() throws IOException {
        this.client = new SmtpClient(this.connectTimeout);
        this.client.setReadTimeout(this.readTimeout);
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.os != null) {
            return this.os;
        }
        if (this.is != null) {
            throw new IOException("Cannot write output after reading input.");
        }
        this.connect();
        String string = ParseUtil.decode(this.url.getPath());
        this.client.from(this.getFromAddress());
        this.client.to(string);
        this.os = this.client.startMessage();
        return this.os;
    }

    @Override
    public Permission getPermission() throws IOException {
        if (this.permission == null) {
            this.connect();
            String string = this.client.getMailHost() + ":" + 25;
            this.permission = new SocketPermission(string, "connect");
        }
        return this.permission;
    }

    @Override
    public void setConnectTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.connectTimeout = n;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout < 0 ? 0 : this.connectTimeout;
    }

    @Override
    public void setReadTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.readTimeout = n;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout < 0 ? 0 : this.readTimeout;
    }
}

