/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XHostAddress
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 12 : 16;
    }

    @Override
    public int getDataSize() {
        return XHostAddress.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XHostAddress(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XHostAddress() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XHostAddress.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_family() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_family(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public int get_length() {
        log.finest("");
        return Native.getInt(this.pData + 4L);
    }

    public void set_length(int n) {
        log.finest("");
        Native.putInt(this.pData + 4L, n);
    }

    public long get_address(int n) {
        log.finest("");
        return Native.getLong(this.pData + 8L) + (long)(n * Native.getLongSize());
    }

    public long get_address() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_address(long l) {
        log.finest("");
        Native.putLong(this.pData + 8L, l);
    }

    @Override
    String getName() {
        return "XHostAddress";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(120);
        stringBuilder.append("family = ").append(this.get_family()).append(", ");
        stringBuilder.append("length = ").append(this.get_length()).append(", ");
        stringBuilder.append("address = ").append(this.get_address()).append(", ");
        return stringBuilder.toString();
    }
}

