/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.imageio.spi.DigraphNode;

class PartialOrderIterator
implements Iterator {
    LinkedList zeroList = new LinkedList();
    Map inDegrees = new HashMap();

    public PartialOrderIterator(Iterator iterator) {
        while (iterator.hasNext()) {
            DigraphNode digraphNode = (DigraphNode)iterator.next();
            int n = digraphNode.getInDegree();
            this.inDegrees.put(digraphNode, new Integer(n));
            if (n != 0) continue;
            this.zeroList.add(digraphNode);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.zeroList.isEmpty();
    }

    public Object next() {
        DigraphNode digraphNode = (DigraphNode)this.zeroList.removeFirst();
        Iterator iterator = digraphNode.getOutNodes();
        while (iterator.hasNext()) {
            DigraphNode digraphNode2 = (DigraphNode)iterator.next();
            int n = (Integer)this.inDegrees.get(digraphNode2) - 1;
            this.inDegrees.put(digraphNode2, new Integer(n));
            if (n != 0) continue;
            this.zeroList.add(digraphNode2);
        }
        return digraphNode.getData();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

