/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.MessageInfo;
import java.net.SocketAddress;

public class SctpMessageInfoImpl
extends MessageInfo {
    private final SocketAddress address;
    private final int bytes;
    private Association association;
    private int assocId;
    private int streamNumber;
    private boolean complete = true;
    private boolean unordered;
    private long timeToLive;
    private int ppid;

    public SctpMessageInfoImpl(Association association, SocketAddress socketAddress, int n) {
        this.association = association;
        this.address = socketAddress;
        this.streamNumber = n;
        this.bytes = 0;
    }

    private SctpMessageInfoImpl(int n, SocketAddress socketAddress, int n2, int n3, boolean bl, boolean bl2, int n4) {
        this.assocId = n;
        this.address = socketAddress;
        this.bytes = n2;
        this.streamNumber = n3;
        this.complete = bl;
        this.unordered = bl2;
        this.ppid = n4;
    }

    @Override
    public Association association() {
        return this.association;
    }

    void setAssociation(Association association) {
        this.association = association;
    }

    int associationID() {
        return this.assocId;
    }

    @Override
    public SocketAddress address() {
        return this.address;
    }

    @Override
    public int bytes() {
        return this.bytes;
    }

    @Override
    public int streamNumber() {
        return this.streamNumber;
    }

    @Override
    public MessageInfo streamNumber(int n) {
        if (n < 0 || n > 65536) {
            throw new IllegalArgumentException("Invalid stream number");
        }
        this.streamNumber = n;
        return this;
    }

    @Override
    public int payloadProtocolID() {
        return this.ppid;
    }

    @Override
    public MessageInfo payloadProtocolID(int n) {
        this.ppid = n;
        return this;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public MessageInfo complete(boolean bl) {
        this.complete = bl;
        return this;
    }

    @Override
    public boolean isUnordered() {
        return this.unordered;
    }

    @Override
    public MessageInfo unordered(boolean bl) {
        this.unordered = bl;
        return this;
    }

    @Override
    public long timeToLive() {
        return this.timeToLive;
    }

    @Override
    public MessageInfo timeToLive(long l) {
        this.timeToLive = l;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("[Address: ").append(this.address).append(", Association: ").append(this.association).append(", Assoc ID: ").append(this.assocId).append(", Bytes: ").append(this.bytes).append(", Stream Number: ").append(this.streamNumber).append(", Complete: ").append(this.complete).append(", isUnordered: ").append(this.unordered).append("]");
        return stringBuilder.toString();
    }
}

