/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.net.sdp.SdpSupport;
import sun.nio.ch.Secrets;

public final class Sdp {
    private static final Constructor<ServerSocket> serverSocketCtor;
    private static final Constructor<SocketImpl> socketImplCtor;

    private Sdp() {
    }

    private static void setAccessible(final AccessibleObject accessibleObject) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                accessibleObject.setAccessible(true);
                return null;
            }
        });
    }

    private static SocketImpl createSocketImpl() {
        try {
            return socketImplCtor.newInstance(new Object[0]);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public static Socket openSocket() throws IOException {
        SocketImpl socketImpl = Sdp.createSocketImpl();
        return new SdpSocket(socketImpl);
    }

    public static ServerSocket openServerSocket() throws IOException {
        SocketImpl socketImpl = Sdp.createSocketImpl();
        try {
            return serverSocketCtor.newInstance(socketImpl);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
    }

    public static SocketChannel openSocketChannel() throws IOException {
        FileDescriptor fileDescriptor = SdpSupport.createSocket();
        return Secrets.newSocketChannel(fileDescriptor);
    }

    public static ServerSocketChannel openServerSocketChannel() throws IOException {
        FileDescriptor fileDescriptor = SdpSupport.createSocket();
        return Secrets.newServerSocketChannel(fileDescriptor);
    }

    static {
        try {
            serverSocketCtor = ServerSocket.class.getDeclaredConstructor(SocketImpl.class);
            Sdp.setAccessible(serverSocketCtor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        try {
            Class<?> clazz = Class.forName("java.net.SdpSocketImpl", true, null);
            socketImplCtor = clazz.getDeclaredConstructor(new Class[0]);
            Sdp.setAccessible(socketImplCtor);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    private static class SdpSocket
    extends Socket {
        SdpSocket(SocketImpl socketImpl) throws SocketException {
            super(socketImpl);
        }
    }
}

