/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;

public class AuthList {
    private final LinkedList<AuthTimeWithHash> entries;
    private final int lifespan;

    public AuthList(int n) {
        this.lifespan = n;
        this.entries = new LinkedList();
    }

    public void put(AuthTimeWithHash authTimeWithHash, KerberosTime kerberosTime) throws KrbApErrException {
        ListIterator<AuthTimeWithHash> listIterator;
        if (this.entries.isEmpty()) {
            this.entries.addFirst(authTimeWithHash);
        } else {
            AuthTimeWithHash authTimeWithHash2 = this.entries.getFirst();
            int n = authTimeWithHash2.compareTo(authTimeWithHash);
            if (n < 0) {
                this.entries.addFirst(authTimeWithHash);
            } else {
                if (n == 0) {
                    throw new KrbApErrException(34);
                }
                listIterator = this.entries.listIterator(1);
                boolean bl = false;
                while (listIterator.hasNext()) {
                    authTimeWithHash2 = listIterator.next();
                    n = authTimeWithHash2.compareTo(authTimeWithHash);
                    if (n < 0) {
                        this.entries.add(this.entries.indexOf(authTimeWithHash2), authTimeWithHash);
                        bl = true;
                        break;
                    }
                    if (n != 0) continue;
                    throw new KrbApErrException(34);
                }
                if (!bl) {
                    this.entries.addLast(authTimeWithHash);
                }
            }
        }
        long l = kerberosTime.getSeconds() - this.lifespan;
        listIterator = this.entries.listIterator(0);
        AuthTimeWithHash authTimeWithHash3 = null;
        int n = -1;
        while (listIterator.hasNext()) {
            authTimeWithHash3 = listIterator.next();
            if ((long)authTimeWithHash3.ctime >= l) continue;
            n = this.entries.indexOf(authTimeWithHash3);
            break;
        }
        if (n > -1) {
            do {
                this.entries.removeLast();
            } while (this.entries.size() > n);
        }
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<AuthTimeWithHash> iterator = this.entries.descendingIterator();
        int n = this.entries.size();
        while (iterator.hasNext()) {
            AuthTimeWithHash authTimeWithHash = iterator.next();
            stringBuilder.append('#').append(n--).append(": ").append(authTimeWithHash.toString()).append('\n');
        }
        return stringBuilder.toString();
    }
}

