/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.JComponent;

abstract class ActionPropertyChangeListener<T extends JComponent>
implements PropertyChangeListener,
Serializable {
    private static ReferenceQueue<JComponent> queue;
    private transient OwnedWeakReference<T> target;
    private Action action;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReferenceQueue<JComponent> getQueue() {
        Class<ActionPropertyChangeListener> clazz = ActionPropertyChangeListener.class;
        synchronized (ActionPropertyChangeListener.class) {
            if (queue == null) {
                queue = new ReferenceQueue();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return queue;
        }
    }

    public ActionPropertyChangeListener(T t, Action action) {
        this.setTarget(t);
        this.action = action;
    }

    @Override
    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        T t = this.getTarget();
        if (t == null) {
            this.getAction().removePropertyChangeListener(this);
        } else {
            this.actionPropertyChanged(t, this.getAction(), propertyChangeEvent);
        }
    }

    protected abstract void actionPropertyChanged(T var1, Action var2, PropertyChangeEvent var3);

    private void setTarget(T t) {
        OwnedWeakReference ownedWeakReference;
        ReferenceQueue<JComponent> referenceQueue = ActionPropertyChangeListener.getQueue();
        while ((ownedWeakReference = (OwnedWeakReference)referenceQueue.poll()) != null) {
            ActionPropertyChangeListener actionPropertyChangeListener = ownedWeakReference.getOwner();
            Action action = actionPropertyChangeListener.getAction();
            if (action == null) continue;
            action.removePropertyChangeListener(actionPropertyChangeListener);
        }
        this.target = new OwnedWeakReference<JComponent>((JComponent)t, referenceQueue, this);
    }

    public T getTarget() {
        if (this.target == null) {
            return null;
        }
        return (T)((JComponent)this.target.get());
    }

    public Action getAction() {
        return this.action;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getTarget());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        JComponent jComponent = (JComponent)objectInputStream.readObject();
        if (jComponent != null) {
            this.setTarget(jComponent);
        }
    }

    private static class OwnedWeakReference<U extends JComponent>
    extends WeakReference<U> {
        private ActionPropertyChangeListener owner;

        OwnedWeakReference(U u, ReferenceQueue<? super U> referenceQueue, ActionPropertyChangeListener actionPropertyChangeListener) {
            super(u, referenceQueue);
            this.owner = actionPropertyChangeListener;
        }

        public ActionPropertyChangeListener getOwner() {
            return this.owner;
        }
    }
}

