/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.EnumMap;
import sun.invoke.util.Wrapper;

public class ValueConversions {
    private static final Class<?> THIS_CLASS = ValueConversions.class;
    private static final MethodHandles.Lookup IMPL_LOOKUP = MethodHandles.lookup();
    private static final WrapperCache[] UNBOX_CONVERSIONS = ValueConversions.newWrapperCaches(4);
    private static final Integer ZERO_INT = 0;
    private static final Integer ONE_INT = 1;
    private static final WrapperCache[] BOX_CONVERSIONS = ValueConversions.newWrapperCaches(1);
    private static final WrapperCache[] CONSTANT_FUNCTIONS = ValueConversions.newWrapperCaches(2);
    private static final MethodHandle CAST_REFERENCE;
    private static final MethodHandle IGNORE;
    private static final MethodHandle EMPTY;
    private static final WrapperCache[] CONVERT_PRIMITIVE_FUNCTIONS;

    private static WrapperCache[] newWrapperCaches(int n) {
        WrapperCache[] wrapperCacheArray = new WrapperCache[n];
        for (int i = 0; i < n; ++i) {
            wrapperCacheArray[i] = new WrapperCache();
        }
        return wrapperCacheArray;
    }

    static int unboxInteger(Integer n) {
        return n;
    }

    static int unboxInteger(Object object, boolean bl) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.INT, object, bl).intValue();
    }

    static byte unboxByte(Byte by) {
        return by;
    }

    static byte unboxByte(Object object, boolean bl) {
        if (object instanceof Byte) {
            return (Byte)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.BYTE, object, bl).byteValue();
    }

    static short unboxShort(Short s) {
        return s;
    }

    static short unboxShort(Object object, boolean bl) {
        if (object instanceof Short) {
            return (Short)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.SHORT, object, bl).shortValue();
    }

    static boolean unboxBoolean(Boolean bl) {
        return bl;
    }

    static boolean unboxBoolean(Object object, boolean bl) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return (ValueConversions.primitiveConversion(Wrapper.BOOLEAN, object, bl).intValue() & 1) != 0;
    }

    static char unboxCharacter(Character c) {
        return c.charValue();
    }

    static char unboxCharacter(Object object, boolean bl) {
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return (char)ValueConversions.primitiveConversion(Wrapper.CHAR, object, bl).intValue();
    }

    static long unboxLong(Long l) {
        return l;
    }

    static long unboxLong(Object object, boolean bl) {
        if (object instanceof Long) {
            return (Long)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.LONG, object, bl).longValue();
    }

    static float unboxFloat(Float f) {
        return f.floatValue();
    }

    static float unboxFloat(Object object, boolean bl) {
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        return ValueConversions.primitiveConversion(Wrapper.FLOAT, object, bl).floatValue();
    }

    static double unboxDouble(Double d) {
        return d;
    }

    static double unboxDouble(Object object, boolean bl) {
        if (object instanceof Double) {
            return (Double)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.DOUBLE, object, bl).doubleValue();
    }

    private static MethodType unboxType(Wrapper wrapper, int n) {
        if (n == 0) {
            return MethodType.methodType(wrapper.primitiveType(), wrapper.wrapperType());
        }
        return MethodType.methodType(wrapper.primitiveType(), Object.class, Boolean.TYPE);
    }

    private static MethodHandle unbox(Wrapper wrapper, int n) {
        WrapperCache wrapperCache = UNBOX_CONVERSIONS[n];
        MethodHandle methodHandle = wrapperCache.get(wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        switch (wrapper) {
            case OBJECT: 
            case VOID: {
                throw new IllegalArgumentException("unbox " + (Object)((Object)wrapper));
            }
        }
        String string = "unbox" + wrapper.wrapperSimpleName();
        MethodType methodType = ValueConversions.unboxType(wrapper, n);
        try {
            methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, string, methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            methodHandle = null;
        }
        if (methodHandle != null) {
            if (n > 0) {
                boolean bl = n != 2;
                methodHandle = MethodHandles.insertArguments(methodHandle, 1, bl);
            }
            if (n == 1) {
                methodHandle = methodHandle.asType(ValueConversions.unboxType(wrapper, 0));
            }
            return wrapperCache.put(wrapper, methodHandle);
        }
        throw new IllegalArgumentException("cannot find unbox adapter for " + (Object)((Object)wrapper) + (n <= 1 ? " (exact)" : (n == 3 ? " (cast)" : "")));
    }

    public static MethodHandle unboxExact(Wrapper wrapper) {
        return ValueConversions.unbox(wrapper, 0);
    }

    public static MethodHandle unboxExact(Wrapper wrapper, boolean bl) {
        return ValueConversions.unbox(wrapper, bl ? 0 : 1);
    }

    public static MethodHandle unboxWiden(Wrapper wrapper) {
        return ValueConversions.unbox(wrapper, 2);
    }

    public static MethodHandle unboxCast(Wrapper wrapper) {
        return ValueConversions.unbox(wrapper, 3);
    }

    public static Number primitiveConversion(Wrapper wrapper, Object object, boolean bl) {
        if (object == null) {
            if (!bl) {
                return null;
            }
            return ZERO_INT;
        }
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)(object instanceof Boolean ? (Number)((Boolean)object != false ? ONE_INT : ZERO_INT) : (Number)(object instanceof Character ? (Number)Integer.valueOf(((Character)object).charValue()) : (Number)((Number)object)));
        Wrapper wrapper2 = Wrapper.findWrapperType(object.getClass());
        if (wrapper2 == null || !bl && !wrapper.isConvertibleFrom(wrapper2)) {
            return (Number)wrapper.wrapperType().cast(object);
        }
        return number;
    }

    public static int widenSubword(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Boolean) {
            return ValueConversions.fromBoolean((Boolean)object);
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        return (Integer)object;
    }

    static Integer boxInteger(int n) {
        return n;
    }

    static Byte boxByte(byte by) {
        return by;
    }

    static Short boxShort(short s) {
        return s;
    }

    static Boolean boxBoolean(boolean bl) {
        return bl;
    }

    static Character boxCharacter(char c) {
        return Character.valueOf(c);
    }

    static Long boxLong(long l) {
        return l;
    }

    static Float boxFloat(float f) {
        return Float.valueOf(f);
    }

    static Double boxDouble(double d) {
        return d;
    }

    private static MethodType boxType(Wrapper wrapper) {
        Class<?> clazz = wrapper.wrapperType();
        return MethodType.methodType(clazz, wrapper.primitiveType());
    }

    public static MethodHandle boxExact(Wrapper wrapper) {
        WrapperCache wrapperCache = BOX_CONVERSIONS[0];
        MethodHandle methodHandle = wrapperCache.get(wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        String string = "box" + wrapper.wrapperSimpleName();
        MethodType methodType = ValueConversions.boxType(wrapper);
        try {
            methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, string, methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            methodHandle = null;
        }
        if (methodHandle != null) {
            return wrapperCache.put(wrapper, methodHandle);
        }
        throw new IllegalArgumentException("cannot find box adapter for " + (Object)((Object)wrapper));
    }

    static void ignore(Object object) {
    }

    static void empty() {
    }

    static Object zeroObject() {
        return null;
    }

    static int zeroInteger() {
        return 0;
    }

    static long zeroLong() {
        return 0L;
    }

    static float zeroFloat() {
        return 0.0f;
    }

    static double zeroDouble() {
        return 0.0;
    }

    public static MethodHandle zeroConstantFunction(Wrapper wrapper) {
        WrapperCache wrapperCache = CONSTANT_FUNCTIONS[0];
        MethodHandle methodHandle = wrapperCache.get(wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        MethodType methodType = MethodType.methodType(wrapper.primitiveType());
        switch (wrapper) {
            case VOID: {
                methodHandle = EMPTY;
                break;
            }
            case OBJECT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                try {
                    methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, "zero" + wrapper.wrapperSimpleName(), methodType);
                    break;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    methodHandle = null;
                }
            }
        }
        if (methodHandle != null) {
            return wrapperCache.put(wrapper, methodHandle);
        }
        if (wrapper.isSubwordOrInt() && wrapper != Wrapper.INT) {
            methodHandle = MethodHandles.explicitCastArguments(ValueConversions.zeroConstantFunction(Wrapper.INT), methodType);
            return wrapperCache.put(wrapper, methodHandle);
        }
        throw new IllegalArgumentException("cannot find zero constant for " + (Object)((Object)wrapper));
    }

    public static MethodHandle ignore() {
        return IGNORE;
    }

    public static MethodHandle cast() {
        return CAST_REFERENCE;
    }

    static float doubleToFloat(double d) {
        return (float)d;
    }

    static long doubleToLong(double d) {
        return (long)d;
    }

    static int doubleToInt(double d) {
        return (int)d;
    }

    static short doubleToShort(double d) {
        return (short)d;
    }

    static char doubleToChar(double d) {
        return (char)d;
    }

    static byte doubleToByte(double d) {
        return (byte)d;
    }

    static boolean doubleToBoolean(double d) {
        return ValueConversions.toBoolean((byte)d);
    }

    static double floatToDouble(float f) {
        return f;
    }

    static long floatToLong(float f) {
        return (long)f;
    }

    static int floatToInt(float f) {
        return (int)f;
    }

    static short floatToShort(float f) {
        return (short)f;
    }

    static char floatToChar(float f) {
        return (char)f;
    }

    static byte floatToByte(float f) {
        return (byte)f;
    }

    static boolean floatToBoolean(float f) {
        return ValueConversions.toBoolean((byte)f);
    }

    static double longToDouble(long l) {
        return l;
    }

    static float longToFloat(long l) {
        return l;
    }

    static int longToInt(long l) {
        return (int)l;
    }

    static short longToShort(long l) {
        return (short)l;
    }

    static char longToChar(long l) {
        return (char)l;
    }

    static byte longToByte(long l) {
        return (byte)l;
    }

    static boolean longToBoolean(long l) {
        return ValueConversions.toBoolean((byte)l);
    }

    static double intToDouble(int n) {
        return n;
    }

    static float intToFloat(int n) {
        return n;
    }

    static long intToLong(int n) {
        return n;
    }

    static short intToShort(int n) {
        return (short)n;
    }

    static char intToChar(int n) {
        return (char)n;
    }

    static byte intToByte(int n) {
        return (byte)n;
    }

    static boolean intToBoolean(int n) {
        return ValueConversions.toBoolean((byte)n);
    }

    static double shortToDouble(short s) {
        return s;
    }

    static float shortToFloat(short s) {
        return s;
    }

    static long shortToLong(short s) {
        return s;
    }

    static int shortToInt(short s) {
        return s;
    }

    static char shortToChar(short s) {
        return (char)s;
    }

    static byte shortToByte(short s) {
        return (byte)s;
    }

    static boolean shortToBoolean(short s) {
        return ValueConversions.toBoolean((byte)s);
    }

    static double charToDouble(char c) {
        return c;
    }

    static float charToFloat(char c) {
        return c;
    }

    static long charToLong(char c) {
        return c;
    }

    static int charToInt(char c) {
        return c;
    }

    static short charToShort(char c) {
        return (short)c;
    }

    static byte charToByte(char c) {
        return (byte)c;
    }

    static boolean charToBoolean(char c) {
        return ValueConversions.toBoolean((byte)c);
    }

    static double byteToDouble(byte by) {
        return by;
    }

    static float byteToFloat(byte by) {
        return by;
    }

    static long byteToLong(byte by) {
        return by;
    }

    static int byteToInt(byte by) {
        return by;
    }

    static short byteToShort(byte by) {
        return by;
    }

    static char byteToChar(byte by) {
        return (char)by;
    }

    static boolean byteToBoolean(byte by) {
        return ValueConversions.toBoolean(by);
    }

    static double booleanToDouble(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static float booleanToFloat(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static long booleanToLong(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static int booleanToInt(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static short booleanToShort(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static char booleanToChar(boolean bl) {
        return (char)ValueConversions.fromBoolean(bl);
    }

    static byte booleanToByte(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static boolean toBoolean(byte by) {
        return (by & 1) != 0;
    }

    static byte fromBoolean(boolean bl) {
        return bl ? (byte)1 : 0;
    }

    public static MethodHandle convertPrimitive(Wrapper wrapper, Wrapper wrapper2) {
        WrapperCache wrapperCache = CONVERT_PRIMITIVE_FUNCTIONS[wrapper.ordinal()];
        MethodHandle methodHandle = wrapperCache.get(wrapper2);
        if (methodHandle != null) {
            return methodHandle;
        }
        Class<?> clazz = wrapper.primitiveType();
        Class<?> clazz2 = wrapper2.primitiveType();
        MethodType methodType = MethodType.methodType(clazz2, clazz);
        if (wrapper == wrapper2) {
            methodHandle = MethodHandles.identity(clazz);
        } else {
            assert (clazz.isPrimitive() && clazz2.isPrimitive());
            try {
                methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, clazz.getSimpleName() + "To" + ValueConversions.capitalize(clazz2.getSimpleName()), methodType);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                methodHandle = null;
            }
        }
        if (methodHandle != null) {
            assert (methodHandle.type() == methodType) : methodHandle;
            return wrapperCache.put(wrapper2, methodHandle);
        }
        throw new IllegalArgumentException("cannot find primitive conversion function for " + clazz.getSimpleName() + " -> " + clazz2.getSimpleName());
    }

    public static MethodHandle convertPrimitive(Class<?> clazz, Class<?> clazz2) {
        return ValueConversions.convertPrimitive(Wrapper.forPrimitiveType(clazz), Wrapper.forPrimitiveType(clazz2));
    }

    private static String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private static InternalError newInternalError(String string, Throwable throwable) {
        return new InternalError(string, throwable);
    }

    private static InternalError newInternalError(Throwable throwable) {
        return new InternalError(throwable);
    }

    static {
        try {
            MethodType methodType = MethodType.genericMethodType(1);
            MethodType methodType2 = methodType.changeReturnType(Void.TYPE);
            CAST_REFERENCE = IMPL_LOOKUP.findVirtual(Class.class, "cast", methodType);
            IGNORE = IMPL_LOOKUP.findStatic(THIS_CLASS, "ignore", methodType2);
            EMPTY = IMPL_LOOKUP.findStatic(THIS_CLASS, "empty", methodType2.dropParameterTypes(0, 1));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw ValueConversions.newInternalError("uncaught exception", reflectiveOperationException);
        }
        CONVERT_PRIMITIVE_FUNCTIONS = ValueConversions.newWrapperCaches(Wrapper.values().length);
    }

    private static class WrapperCache {
        private final EnumMap<Wrapper, MethodHandle> map = new EnumMap(Wrapper.class);

        private WrapperCache() {
        }

        public MethodHandle get(Wrapper wrapper) {
            return this.map.get((Object)wrapper);
        }

        public synchronized MethodHandle put(Wrapper wrapper, MethodHandle methodHandle) {
            MethodHandle methodHandle2 = this.map.putIfAbsent(wrapper, methodHandle);
            if (methodHandle2 != null) {
                return methodHandle2;
            }
            return methodHandle;
        }
    }
}

