/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.action.GetPropertyAction;

public class DefaultFileSystemProvider {
    private DefaultFileSystemProvider() {
    }

    private static FileSystemProvider createProvider(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<FileSystemProvider>(){

            @Override
            public FileSystemProvider run() {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string, true, null);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AssertionError((Object)classNotFoundException);
                }
                try {
                    return (FileSystemProvider)clazz.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Object)illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    throw new AssertionError((Object)instantiationException);
                }
            }
        });
    }

    public static FileSystemProvider create() {
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (string.equals("SunOS")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.SolarisFileSystemProvider");
        }
        if (string.equals("Linux")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.LinuxFileSystemProvider");
        }
        if (string.equals("Darwin") || string.contains("OS X")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.MacOSXFileSystemProvider");
        }
        throw new AssertionError((Object)"Platform not recognized");
    }
}

