/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class SortArrowIcon
implements Icon,
UIResource,
Serializable {
    private static final int ARROW_HEIGHT = 5;
    private static final int X_PADDING = 7;
    private boolean ascending;
    private Color color;
    private String colorKey;

    public SortArrowIcon(boolean bl, Color color) {
        this.ascending = bl;
        this.color = color;
        if (color == null) {
            throw new IllegalArgumentException();
        }
    }

    public SortArrowIcon(boolean bl, String string) {
        this.ascending = bl;
        this.colorKey = string;
        if (string == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.setColor(this.getColor());
        int n3 = 7 + n + 2;
        if (this.ascending) {
            int n4 = n2;
            graphics.fillRect(n3, n4, 1, 1);
            for (int i = 1; i < 5; ++i) {
                graphics.fillRect(n3 - i, n4 + i, i + i + 1, 1);
            }
        } else {
            int n5 = n2 + 5 - 1;
            graphics.fillRect(n3, n5, 1, 1);
            for (int i = 1; i < 5; ++i) {
                graphics.fillRect(n3 - i, n5 - i, i + i + 1, 1);
            }
        }
    }

    @Override
    public int getIconWidth() {
        return 17;
    }

    @Override
    public int getIconHeight() {
        return 7;
    }

    private Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        return UIManager.getColor(this.colorKey);
    }
}

