/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import com.sun.jmx.defaults.JmxProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.loading.MLetContent;

class MLetParser {
    private int c;
    private static String tag = "mlet";

    public void skipSpace(Reader reader) throws IOException {
        while (this.c >= 0 && (this.c == 32 || this.c == 9 || this.c == 10 || this.c == 13)) {
            this.c = reader.read();
        }
    }

    public String scanIdentifier(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.c >= 97 && this.c <= 122 || this.c >= 65 && this.c <= 90 || this.c >= 48 && this.c <= 57 || this.c == 95) {
            stringBuilder.append((char)this.c);
            this.c = reader.read();
        }
        return stringBuilder.toString();
    }

    public Map<String, String> scanTag(Reader reader) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.skipSpace(reader);
        while (this.c >= 0 && this.c != 62) {
            if (this.c == 60) {
                throw new IOException("Missing '>' in tag");
            }
            String string = this.scanIdentifier(reader);
            String string2 = "";
            this.skipSpace(reader);
            if (this.c == 61) {
                int n = -1;
                this.c = reader.read();
                this.skipSpace(reader);
                if (this.c == 39 || this.c == 34) {
                    n = this.c;
                    this.c = reader.read();
                }
                StringBuilder stringBuilder = new StringBuilder();
                while (this.c > 0 && (n < 0 && this.c != 32 && this.c != 9 && this.c != 10 && this.c != 13 && this.c != 62 || n >= 0 && this.c != n)) {
                    stringBuilder.append((char)this.c);
                    this.c = reader.read();
                }
                if (this.c == n) {
                    this.c = reader.read();
                }
                this.skipSpace(reader);
                string2 = stringBuilder.toString();
            }
            hashMap.put(string.toLowerCase(), string2);
            this.skipSpace(reader);
        }
        return hashMap;
    }

    public List<MLetContent> parse(URL uRL) throws IOException {
        ArrayList<MLetContent> arrayList;
        BufferedReader bufferedReader;
        block10: {
            String string = "parse";
            String string2 = "<arg type=... value=...> tag requires type parameter.";
            String string3 = "<arg type=... value=...> tag requires value parameter.";
            String string4 = "<arg> tag outside <mlet> ... </mlet>.";
            String string5 = "<mlet> tag requires either code or object parameter.";
            String string6 = "<mlet> tag requires archive parameter.";
            URLConnection uRLConnection = uRL.openConnection();
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), "UTF-8"));
            uRL = uRLConnection.getURL();
            arrayList = new ArrayList<MLetContent>();
            Map<String, String> map = null;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            while (true) {
                String string7;
                this.c = ((Reader)bufferedReader).read();
                if (this.c == -1) break block10;
                if (this.c != 60) continue;
                this.c = ((Reader)bufferedReader).read();
                if (this.c == 47) {
                    this.c = ((Reader)bufferedReader).read();
                    string7 = this.scanIdentifier(bufferedReader);
                    if (this.c != 62) {
                        throw new IOException("Missing '>' in tag");
                    }
                    if (!string7.equalsIgnoreCase(tag)) continue;
                    if (map != null) {
                        arrayList.add(new MLetContent(uRL, map, arrayList2, arrayList3));
                    }
                    map = null;
                    arrayList2 = new ArrayList();
                    arrayList3 = new ArrayList();
                    continue;
                }
                string7 = this.scanIdentifier(bufferedReader);
                if (string7.equalsIgnoreCase("arg")) {
                    Map<String, String> map2 = this.scanTag(bufferedReader);
                    String string8 = map2.get("type");
                    if (string8 == null) {
                        ((Logger)((Object)JmxProperties.MLET_LOGGER)).logp(Level.FINER, MLetParser.class.getName(), string, string2);
                        throw new IOException(string2);
                    }
                    if (map == null) {
                        ((Logger)((Object)JmxProperties.MLET_LOGGER)).logp(Level.FINER, MLetParser.class.getName(), string, string4);
                        throw new IOException(string4);
                    }
                    arrayList2.add(string8);
                    String string9 = map2.get("value");
                    if (string9 == null) {
                        ((Logger)((Object)JmxProperties.MLET_LOGGER)).logp(Level.FINER, MLetParser.class.getName(), string, string3);
                        throw new IOException(string3);
                    }
                    if (map != null) {
                        arrayList3.add(string9);
                        continue;
                    }
                    ((Logger)((Object)JmxProperties.MLET_LOGGER)).logp(Level.FINER, MLetParser.class.getName(), string, string4);
                    throw new IOException(string4);
                }
                if (!string7.equalsIgnoreCase(tag)) continue;
                map = this.scanTag(bufferedReader);
                if (map.get("code") == null && map.get("object") == null) {
                    ((Logger)((Object)JmxProperties.MLET_LOGGER)).logp(Level.FINER, MLetParser.class.getName(), string, string5);
                    throw new IOException(string5);
                }
                if (map.get("archive") == null) break;
            }
            ((Logger)((Object)JmxProperties.MLET_LOGGER)).logp(Level.FINER, MLetParser.class.getName(), string, string6);
            throw new IOException(string6);
        }
        ((Reader)bufferedReader).close();
        return arrayList;
    }

    public List<MLetContent> parseURL(String string) throws IOException {
        URL uRL;
        if (string.indexOf(58) <= 1) {
            String string2 = System.getProperty("user.dir");
            String string3 = string2.charAt(0) == '/' || string2.charAt(0) == File.separatorChar ? "file:" : "file:/";
            uRL = new URL(string3 + string2.replace(File.separatorChar, '/') + "/");
            uRL = new URL(uRL, string);
        } else {
            uRL = new URL(string);
        }
        return this.parse(uRL);
    }
}

