/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.Period;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.AbstractChronology;
import java.time.chrono.Era;
import java.time.chrono.IsoEra;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class IsoChronology
extends AbstractChronology
implements Serializable {
    public static final IsoChronology INSTANCE = new IsoChronology();
    private static final long serialVersionUID = -1440403870442975015L;

    private IsoChronology() {
    }

    @Override
    public String getId() {
        return "ISO";
    }

    @Override
    public String getCalendarType() {
        return "iso8601";
    }

    @Override
    public LocalDate date(Era era, int n, int n2, int n3) {
        return this.date(this.prolepticYear(era, n), n2, n3);
    }

    @Override
    public LocalDate date(int n, int n2, int n3) {
        return LocalDate.of(n, n2, n3);
    }

    @Override
    public LocalDate dateYearDay(Era era, int n, int n2) {
        return this.dateYearDay(this.prolepticYear(era, n), n2);
    }

    @Override
    public LocalDate dateYearDay(int n, int n2) {
        return LocalDate.ofYearDay(n, n2);
    }

    @Override
    public LocalDate dateEpochDay(long l) {
        return LocalDate.ofEpochDay(l);
    }

    @Override
    public LocalDate date(TemporalAccessor temporalAccessor) {
        return LocalDate.from(temporalAccessor);
    }

    public LocalDateTime localDateTime(TemporalAccessor temporalAccessor) {
        return LocalDateTime.from(temporalAccessor);
    }

    public ZonedDateTime zonedDateTime(TemporalAccessor temporalAccessor) {
        return ZonedDateTime.from(temporalAccessor);
    }

    public ZonedDateTime zonedDateTime(Instant instant, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    @Override
    public LocalDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    @Override
    public LocalDate dateNow(ZoneId zoneId) {
        return this.dateNow(Clock.system(zoneId));
    }

    @Override
    public LocalDate dateNow(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return this.date(LocalDate.now(clock));
    }

    @Override
    public boolean isLeapYear(long l) {
        return (l & 3L) == 0L && (l % 100L != 0L || l % 400L == 0L);
    }

    @Override
    public int prolepticYear(Era era, int n) {
        if (!(era instanceof IsoEra)) {
            throw new ClassCastException("Era must be IsoEra");
        }
        return era == IsoEra.CE ? n : 1 - n;
    }

    @Override
    public IsoEra eraOf(int n) {
        return IsoEra.of(n);
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(IsoEra.values());
    }

    @Override
    public LocalDate resolveDate(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        return (LocalDate)super.resolveDate(map, resolverStyle);
    }

    @Override
    void resolveProlepticMonth(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        Long l = map.remove(ChronoField.PROLEPTIC_MONTH);
        if (l != null) {
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.PROLEPTIC_MONTH.checkValidValue(l);
            }
            this.addFieldValue(map, ChronoField.MONTH_OF_YEAR, Math.floorMod(l, 12L) + 1L);
            this.addFieldValue(map, ChronoField.YEAR, Math.floorDiv(l, 12L));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    LocalDate resolveYearOfEra(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        Long l = map.remove(ChronoField.YEAR_OF_ERA);
        if (l != null) {
            Long l2;
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.YEAR_OF_ERA.checkValidValue(l);
            }
            if ((l2 = map.remove(ChronoField.ERA)) == null) {
                Long l3 = map.get(ChronoField.YEAR);
                if (resolverStyle == ResolverStyle.STRICT) {
                    if (l3 != null) {
                        this.addFieldValue(map, ChronoField.YEAR, l3 > 0L ? l : Math.subtractExact(1L, l));
                        return null;
                    } else {
                        map.put(ChronoField.YEAR_OF_ERA, l);
                    }
                    return null;
                } else {
                    this.addFieldValue(map, ChronoField.YEAR, l3 == null || l3 > 0L ? l : Math.subtractExact(1L, l));
                }
                return null;
            } else if (l2 == 1L) {
                this.addFieldValue(map, ChronoField.YEAR, l);
                return null;
            } else {
                if (l2 != 0L) throw new DateTimeException("Invalid value for era: " + l2);
                this.addFieldValue(map, ChronoField.YEAR, Math.subtractExact(1L, l));
            }
            return null;
        } else {
            if (!map.containsKey(ChronoField.ERA)) return null;
            ChronoField.ERA.checkValidValue(map.get(ChronoField.ERA));
        }
        return null;
    }

    @Override
    LocalDate resolveYMD(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        int n = ChronoField.YEAR.checkValidIntValue(map.remove(ChronoField.YEAR));
        if (resolverStyle == ResolverStyle.LENIENT) {
            long l = Math.subtractExact(map.remove(ChronoField.MONTH_OF_YEAR), 1L);
            long l2 = Math.subtractExact(map.remove(ChronoField.DAY_OF_MONTH), 1L);
            return LocalDate.of(n, 1, 1).plusMonths(l).plusDays(l2);
        }
        int n2 = ChronoField.MONTH_OF_YEAR.checkValidIntValue(map.remove(ChronoField.MONTH_OF_YEAR));
        int n3 = ChronoField.DAY_OF_MONTH.checkValidIntValue(map.remove(ChronoField.DAY_OF_MONTH));
        if (resolverStyle == ResolverStyle.SMART) {
            if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
                n3 = Math.min(n3, 30);
            } else if (n2 == 2) {
                n3 = Math.min(n3, Month.FEBRUARY.length(Year.isLeap(n)));
            }
        }
        return LocalDate.of(n, n2, n3);
    }

    @Override
    public ValueRange range(ChronoField chronoField) {
        return chronoField.range();
    }

    @Override
    public Period period(int n, int n2, int n3) {
        return Period.of(n, n2, n3);
    }

    @Override
    Object writeReplace() {
        return super.writeReplace();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }
}

