/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.SequencedEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.CausedFocusEvent;
import sun.awt.KeyboardFocusManagerPeerProvider;
import sun.awt.SunToolkit;
import sun.util.logging.PlatformLogger;

public abstract class KeyboardFocusManager
implements KeyEventDispatcher,
KeyEventPostProcessor {
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("java.awt.focus.KeyboardFocusManager");
    transient KeyboardFocusManagerPeer peer;
    private static final PlatformLogger log;
    public static final int FORWARD_TRAVERSAL_KEYS = 0;
    public static final int BACKWARD_TRAVERSAL_KEYS = 1;
    public static final int UP_CYCLE_TRAVERSAL_KEYS = 2;
    public static final int DOWN_CYCLE_TRAVERSAL_KEYS = 3;
    static final int TRAVERSAL_KEY_LENGTH = 4;
    private static Component focusOwner;
    private static Component permanentFocusOwner;
    private static Window focusedWindow;
    private static Window activeWindow;
    private FocusTraversalPolicy defaultPolicy = new DefaultFocusTraversalPolicy();
    private static final String[] defaultFocusTraversalKeyPropertyNames;
    private static final AWTKeyStroke[][] defaultFocusTraversalKeyStrokes;
    private Set[] defaultFocusTraversalKeys = new Set[4];
    private static Container currentFocusCycleRoot;
    private VetoableChangeSupport vetoableSupport;
    private PropertyChangeSupport changeSupport;
    private LinkedList keyEventDispatchers;
    private LinkedList keyEventPostProcessors;
    private static Map mostRecentFocusOwners;
    private static final String notPrivileged = "this KeyboardFocusManager is not installed in the current thread's context";
    private static AWTPermission replaceKeyboardFocusManagerPermission;
    transient SequencedEvent currentSequencedEvent = null;
    private static LinkedList<HeavyweightFocusRequest> heavyweightRequests;
    private static LinkedList<LightweightFocusRequest> currentLightweightRequests;
    private static boolean clearingCurrentLightweightRequests;
    private static boolean allowSyncFocusRequests;
    private static Component newFocusOwner;
    private static volatile boolean disableRestoreFocus;
    static final int SNFH_FAILURE = 0;
    static final int SNFH_SUCCESS_HANDLED = 1;
    static final int SNFH_SUCCESS_PROCEED = 2;
    static Field proxyActive;

    private static native void initIDs();

    public static KeyboardFocusManager getCurrentKeyboardFocusManager() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager(AppContext.getAppContext());
    }

    static synchronized KeyboardFocusManager getCurrentKeyboardFocusManager(AppContext appContext) {
        KeyboardFocusManager keyboardFocusManager = (KeyboardFocusManager)appContext.get(KeyboardFocusManager.class);
        if (keyboardFocusManager == null) {
            keyboardFocusManager = new DefaultKeyboardFocusManager();
            appContext.put(KeyboardFocusManager.class, keyboardFocusManager);
        }
        return keyboardFocusManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentKeyboardFocusManager(KeyboardFocusManager keyboardFocusManager) throws SecurityException {
        KeyboardFocusManager.checkReplaceKFMPermission();
        KeyboardFocusManager keyboardFocusManager2 = null;
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            AppContext appContext = AppContext.getAppContext();
            if (keyboardFocusManager != null) {
                keyboardFocusManager2 = KeyboardFocusManager.getCurrentKeyboardFocusManager(appContext);
                appContext.put(KeyboardFocusManager.class, keyboardFocusManager);
            } else {
                keyboardFocusManager2 = KeyboardFocusManager.getCurrentKeyboardFocusManager(appContext);
                appContext.remove(KeyboardFocusManager.class);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (keyboardFocusManager2 != null) {
                keyboardFocusManager2.firePropertyChange("managingFocus", Boolean.TRUE, Boolean.FALSE);
            }
            if (keyboardFocusManager != null) {
                keyboardFocusManager.firePropertyChange("managingFocus", Boolean.FALSE, Boolean.TRUE);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCurrentSequencedEvent(SequencedEvent sequencedEvent) {
        Class<SequencedEvent> clazz = SequencedEvent.class;
        synchronized (SequencedEvent.class) {
            assert (sequencedEvent == null || this.currentSequencedEvent == null);
            this.currentSequencedEvent = sequencedEvent;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SequencedEvent getCurrentSequencedEvent() {
        Class<SequencedEvent> clazz = SequencedEvent.class;
        synchronized (SequencedEvent.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentSequencedEvent;
        }
    }

    static Set initFocusTraversalKeysSet(String string, Set set) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            set.add(AWTKeyStroke.getAWTKeyStroke(stringTokenizer.nextToken()));
        }
        return set.isEmpty() ? Collections.EMPTY_SET : Collections.unmodifiableSet(set);
    }

    public KeyboardFocusManager() {
        for (int i = 0; i < 4; ++i) {
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>();
            for (int j = 0; j < defaultFocusTraversalKeyStrokes[i].length; ++j) {
                hashSet.add(defaultFocusTraversalKeyStrokes[i][j]);
            }
            this.defaultFocusTraversalKeys[i] = hashSet.isEmpty() ? Collections.EMPTY_SET : Collections.unmodifiableSet(hashSet);
        }
        this.initPeer();
    }

    private void initPeer() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        KeyboardFocusManagerPeerProvider keyboardFocusManagerPeerProvider = (KeyboardFocusManagerPeerProvider)((Object)toolkit);
        this.peer = keyboardFocusManagerPeerProvider.getKeyboardFocusManagerPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getFocusOwner() {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            if (focusOwner == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return KeyboardFocusManager.focusOwner.appContext == AppContext.getAppContext() ? focusOwner : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Component getGlobalFocusOwner() throws SecurityException {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            this.checkKFMSecurity();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return focusOwner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void setGlobalFocusOwner(Component component) {
        Component component2 = null;
        boolean bl = false;
        if (component == null || component.isFocusable()) {
            Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
            // MONITORENTER : java.awt.KeyboardFocusManager.class
            this.checkKFMSecurity();
            component2 = this.getFocusOwner();
            try {
                this.fireVetoableChange("focusOwner", component2, component);
            }
            catch (PropertyVetoException propertyVetoException) {
                // MONITOREXIT : clazz
                return;
            }
            focusOwner = component;
            if (!(component == null || this.getCurrentFocusCycleRoot() != null && component.isFocusCycleRoot(this.getCurrentFocusCycleRoot()))) {
                Container container = component.getFocusCycleRootAncestor();
                if (container == null && component instanceof Window) {
                    container = (Container)component;
                }
                if (container != null) {
                    this.setGlobalCurrentFocusCycleRoot(container);
                }
            }
            bl = true;
            // MONITOREXIT : clazz
        }
        if (!bl) return;
        this.firePropertyChange("focusOwner", component2, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGlobalFocusOwner() {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            this.checkKFMSecurity();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (!GraphicsEnvironment.isHeadless()) {
                Toolkit.getDefaultToolkit();
                this._clearGlobalFocusOwner();
            }
            return;
        }
    }

    private void _clearGlobalFocusOwner() {
        Window window = KeyboardFocusManager.markClearGlobalFocusOwner();
        this.peer.clearGlobalFocusOwner(window);
    }

    Component getNativeFocusOwner() {
        return this.peer.getCurrentFocusOwner();
    }

    void setNativeFocusOwner(Component component) {
        if (focusLog.isLoggable(300)) {
            focusLog.finest("Calling peer {0} setCurrentFocusOwner for {1}", String.valueOf(this.peer), String.valueOf(component));
        }
        this.peer.setCurrentFocusOwner(component);
    }

    Window getNativeFocusedWindow() {
        return this.peer.getCurrentFocusedWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getPermanentFocusOwner() {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            if (permanentFocusOwner == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return KeyboardFocusManager.permanentFocusOwner.appContext == AppContext.getAppContext() ? permanentFocusOwner : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Component getGlobalPermanentFocusOwner() throws SecurityException {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            this.checkKFMSecurity();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return permanentFocusOwner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void setGlobalPermanentFocusOwner(Component component) {
        Component component2 = null;
        boolean bl = false;
        if (component == null || component.isFocusable()) {
            Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
            // MONITORENTER : java.awt.KeyboardFocusManager.class
            this.checkKFMSecurity();
            component2 = this.getPermanentFocusOwner();
            try {
                this.fireVetoableChange("permanentFocusOwner", component2, component);
            }
            catch (PropertyVetoException propertyVetoException) {
                // MONITOREXIT : clazz
                return;
            }
            permanentFocusOwner = component;
            KeyboardFocusManager.setMostRecentFocusOwner(component);
            bl = true;
            // MONITOREXIT : clazz
        }
        if (!bl) return;
        this.firePropertyChange("permanentFocusOwner", component2, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getFocusedWindow() {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            if (focusedWindow == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return KeyboardFocusManager.focusedWindow.appContext == AppContext.getAppContext() ? focusedWindow : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Window getGlobalFocusedWindow() throws SecurityException {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            this.checkKFMSecurity();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return focusedWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void setGlobalFocusedWindow(Window window) {
        Window window2 = null;
        boolean bl = false;
        if (window == null || window.isFocusableWindow()) {
            Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
            // MONITORENTER : java.awt.KeyboardFocusManager.class
            this.checkKFMSecurity();
            window2 = this.getFocusedWindow();
            try {
                this.fireVetoableChange("focusedWindow", window2, window);
            }
            catch (PropertyVetoException propertyVetoException) {
                // MONITOREXIT : clazz
                return;
            }
            focusedWindow = window;
            bl = true;
            // MONITOREXIT : clazz
        }
        if (!bl) return;
        this.firePropertyChange("focusedWindow", window2, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getActiveWindow() {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            if (activeWindow == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return KeyboardFocusManager.activeWindow.appContext == AppContext.getAppContext() ? activeWindow : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Window getGlobalActiveWindow() throws SecurityException {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            this.checkKFMSecurity();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return activeWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGlobalActiveWindow(Window window) {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            this.checkKFMSecurity();
            Window window2 = this.getActiveWindow();
            if (focusLog.isLoggable(400)) {
                focusLog.finer("Setting global active window to " + window + ", old active " + window2);
            }
            try {
                this.fireVetoableChange("activeWindow", window2, window);
            }
            catch (PropertyVetoException propertyVetoException) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            activeWindow = window;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            this.firePropertyChange("activeWindow", window2, window);
            return;
        }
    }

    public synchronized FocusTraversalPolicy getDefaultFocusTraversalPolicy() {
        return this.defaultPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        FocusTraversalPolicy focusTraversalPolicy2;
        if (focusTraversalPolicy == null) {
            throw new IllegalArgumentException("default focus traversal policy cannot be null");
        }
        KeyboardFocusManager keyboardFocusManager = this;
        synchronized (keyboardFocusManager) {
            focusTraversalPolicy2 = this.defaultPolicy;
            this.defaultPolicy = focusTraversalPolicy;
        }
        this.firePropertyChange("defaultFocusTraversalPolicy", focusTraversalPolicy2, focusTraversalPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultFocusTraversalKeys(int n, Set<? extends AWTKeyStroke> set) {
        Set set2;
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        if (set == null) {
            throw new IllegalArgumentException("cannot set null Set of default focus traversal keys");
        }
        KeyboardFocusManager keyboardFocusManager = this;
        synchronized (keyboardFocusManager) {
            for (AWTKeyStroke aWTKeyStroke : set) {
                if (aWTKeyStroke == null) {
                    throw new IllegalArgumentException("cannot set null focus traversal key");
                }
                if (!(aWTKeyStroke instanceof AWTKeyStroke)) {
                    throw new IllegalArgumentException("object is expected to be AWTKeyStroke");
                }
                AWTKeyStroke aWTKeyStroke2 = aWTKeyStroke;
                if (aWTKeyStroke2.getKeyChar() != '\uffff') {
                    throw new IllegalArgumentException("focus traversal keys cannot map to KEY_TYPED events");
                }
                for (int i = 0; i < 4; ++i) {
                    if (i == n || !this.defaultFocusTraversalKeys[i].contains(aWTKeyStroke2)) continue;
                    throw new IllegalArgumentException("focus traversal keys must be unique for a Component");
                }
            }
            set2 = this.defaultFocusTraversalKeys[n];
            this.defaultFocusTraversalKeys[n] = Collections.unmodifiableSet(new HashSet<AWTKeyStroke>(set));
        }
        this.firePropertyChange(defaultFocusTraversalKeyPropertyNames[n], set2, set);
    }

    public Set<AWTKeyStroke> getDefaultFocusTraversalKeys(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.defaultFocusTraversalKeys[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container getCurrentFocusCycleRoot() {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            if (currentFocusCycleRoot == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return KeyboardFocusManager.currentFocusCycleRoot.appContext == AppContext.getAppContext() ? currentFocusCycleRoot : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Container getGlobalCurrentFocusCycleRoot() throws SecurityException {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            this.checkKFMSecurity();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return currentFocusCycleRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalCurrentFocusCycleRoot(Container container) {
        Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            this.checkKFMSecurity();
            Container container2 = this.getCurrentFocusCycleRoot();
            currentFocusCycleRoot = container;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            this.firePropertyChange("currentFocusCycleRoot", container2, container);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.changeSupport == null) {
                    this.changeSupport = new PropertyChangeSupport(this);
                }
                this.changeSupport.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.changeSupport != null) {
                    this.changeSupport.removePropertyChangeListener(propertyChangeListener);
                }
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.changeSupport == null) {
                    this.changeSupport = new PropertyChangeSupport(this);
                }
                this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.changeSupport != null) {
                    this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
                }
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (object == object2) {
            return;
        }
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.vetoableSupport == null) {
                    this.vetoableSupport = new VetoableChangeSupport(this);
                }
                this.vetoableSupport.addVetoableChangeListener(vetoableChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.vetoableSupport != null) {
                    this.vetoableSupport.removeVetoableChangeListener(vetoableChangeListener);
                }
            }
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners() {
        if (this.vetoableSupport == null) {
            this.vetoableSupport = new VetoableChangeSupport(this);
        }
        return this.vetoableSupport.getVetoableChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.vetoableSupport == null) {
                    this.vetoableSupport = new VetoableChangeSupport(this);
                }
                this.vetoableSupport.addVetoableChangeListener(string, vetoableChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.vetoableSupport != null) {
                    this.vetoableSupport.removeVetoableChangeListener(string, vetoableChangeListener);
                }
            }
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners(String string) {
        if (this.vetoableSupport == null) {
            this.vetoableSupport = new VetoableChangeSupport(this);
        }
        return this.vetoableSupport.getVetoableChangeListeners(string);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (object == object2) {
            return;
        }
        VetoableChangeSupport vetoableChangeSupport = this.vetoableSupport;
        if (vetoableChangeSupport != null) {
            vetoableChangeSupport.fireVetoableChange(string, object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyEventDispatcher(KeyEventDispatcher keyEventDispatcher) {
        if (keyEventDispatcher != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.keyEventDispatchers == null) {
                    this.keyEventDispatchers = new LinkedList();
                }
                this.keyEventDispatchers.add(keyEventDispatcher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyEventDispatcher(KeyEventDispatcher keyEventDispatcher) {
        if (keyEventDispatcher != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.keyEventDispatchers != null) {
                    this.keyEventDispatchers.remove(keyEventDispatcher);
                }
            }
        }
    }

    protected synchronized List<KeyEventDispatcher> getKeyEventDispatchers() {
        return this.keyEventDispatchers != null ? (List)this.keyEventDispatchers.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyEventPostProcessor(KeyEventPostProcessor keyEventPostProcessor) {
        if (keyEventPostProcessor != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.keyEventPostProcessors == null) {
                    this.keyEventPostProcessors = new LinkedList();
                }
                this.keyEventPostProcessors.add(keyEventPostProcessor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyEventPostProcessor(KeyEventPostProcessor keyEventPostProcessor) {
        if (keyEventPostProcessor != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.keyEventPostProcessors != null) {
                    this.keyEventPostProcessors.remove(keyEventPostProcessor);
                }
            }
        }
    }

    protected List<KeyEventPostProcessor> getKeyEventPostProcessors() {
        return this.keyEventPostProcessors != null ? (List)this.keyEventPostProcessors.clone() : null;
    }

    static void setMostRecentFocusOwner(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof Window)) {
            component2 = component2.parent;
        }
        if (component2 != null) {
            KeyboardFocusManager.setMostRecentFocusOwner((Window)component2, component);
        }
    }

    static synchronized void setMostRecentFocusOwner(Window window, Component component) {
        WeakReference<Component> weakReference = null;
        if (component != null) {
            weakReference = new WeakReference<Component>(component);
        }
        mostRecentFocusOwners.put(window, weakReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearMostRecentFocusOwner(Component component) {
        Container container;
        if (component == null) {
            return;
        }
        Class<KeyboardFocusManager> clazz = component.getTreeLock();
        synchronized (clazz) {
            for (container = component.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            }
        }
        clazz = KeyboardFocusManager.class;
        synchronized (KeyboardFocusManager.class) {
            Window window;
            if (container != null && KeyboardFocusManager.getMostRecentFocusOwner((Window)container) == component) {
                KeyboardFocusManager.setMostRecentFocusOwner((Window)container, null);
            }
            if (container != null && (window = (Window)container).getTemporaryLostComponent() == component) {
                window.setTemporaryLostComponent(null);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    static synchronized Component getMostRecentFocusOwner(Window window) {
        WeakReference weakReference = (WeakReference)mostRecentFocusOwners.get(window);
        return weakReference == null ? null : (Component)weakReference.get();
    }

    public abstract boolean dispatchEvent(AWTEvent var1);

    public final void redispatchEvent(Component component, AWTEvent aWTEvent) {
        aWTEvent.focusManagerIsDispatching = true;
        component.dispatchEvent(aWTEvent);
        aWTEvent.focusManagerIsDispatching = false;
    }

    @Override
    public abstract boolean dispatchKeyEvent(KeyEvent var1);

    @Override
    public abstract boolean postProcessKeyEvent(KeyEvent var1);

    public abstract void processKeyEvent(Component var1, KeyEvent var2);

    protected abstract void enqueueKeyEvents(long var1, Component var3);

    protected abstract void dequeueKeyEvents(long var1, Component var3);

    protected abstract void discardKeyEvents(Component var1);

    public abstract void focusNextComponent(Component var1);

    public abstract void focusPreviousComponent(Component var1);

    public abstract void upFocusCycle(Component var1);

    public abstract void downFocusCycle(Container var1);

    public final void focusNextComponent() {
        Component component = this.getFocusOwner();
        if (component != null) {
            this.focusNextComponent(component);
        }
    }

    public final void focusPreviousComponent() {
        Component component = this.getFocusOwner();
        if (component != null) {
            this.focusPreviousComponent(component);
        }
    }

    public final void upFocusCycle() {
        Component component = this.getFocusOwner();
        if (component != null) {
            this.upFocusCycle(component);
        }
    }

    public final void downFocusCycle() {
        Component component = this.getFocusOwner();
        if (component instanceof Container) {
            this.downFocusCycle((Container)component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpRequests() {
        System.err.println(">>> Requests dump, time: " + System.currentTimeMillis());
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            for (HeavyweightFocusRequest heavyweightFocusRequest : heavyweightRequests) {
                System.err.println(">>> Req: " + heavyweightFocusRequest);
            }
        }
        System.err.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean processSynchronousLightweightTransfer(Component component, Component component2, boolean bl, boolean bl2, long l) {
        Window window = SunToolkit.getContainingWindow(component);
        if (window == null || !window.syncLWRequests) {
            return false;
        }
        if (component2 == null) {
            component2 = component;
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager(SunToolkit.targetToAppContext(component2));
        FocusEvent focusEvent = null;
        FocusEvent focusEvent2 = null;
        Component component3 = keyboardFocusManager.getGlobalFocusOwner();
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            HeavyweightFocusRequest heavyweightFocusRequest = KeyboardFocusManager.getLastHWRequest();
            if (heavyweightFocusRequest == null && component == keyboardFocusManager.getNativeFocusOwner() && allowSyncFocusRequests) {
                if (component2 == component3) {
                    return true;
                }
                keyboardFocusManager.enqueueKeyEvents(l, component2);
                heavyweightFocusRequest = new HeavyweightFocusRequest(component, component2, bl, CausedFocusEvent.Cause.UNKNOWN);
                heavyweightRequests.add(heavyweightFocusRequest);
                if (component3 != null) {
                    focusEvent = new FocusEvent(component3, 1005, bl, component2);
                }
                focusEvent2 = new FocusEvent(component2, 1004, bl, component3);
            }
        }
        boolean bl3 = false;
        boolean bl4 = clearingCurrentLightweightRequests;
        Throwable throwable = null;
        try {
            clearingCurrentLightweightRequests = false;
            Object object = Component.LOCK;
            synchronized (object) {
                if (focusEvent != null && component3 != null) {
                    focusEvent.isPosted = true;
                    throwable = KeyboardFocusManager.dispatchAndCatchException(throwable, component3, focusEvent);
                    bl3 = true;
                }
                if (focusEvent2 != null && component2 != null) {
                    focusEvent2.isPosted = true;
                    throwable = KeyboardFocusManager.dispatchAndCatchException(throwable, component2, focusEvent2);
                    bl3 = true;
                }
            }
        }
        finally {
            clearingCurrentLightweightRequests = bl4;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int shouldNativelyFocusHeavyweight(Component component, Component component2, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
        if (log.isLoggable(500)) {
            if (component == null) {
                log.fine("Assertion (heavyweight != null) failed");
            }
            if (l == 0L) {
                log.fine("Assertion (time != 0) failed");
            }
        }
        if (component2 == null) {
            component2 = component;
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager(SunToolkit.targetToAppContext(component2));
        KeyboardFocusManager keyboardFocusManager2 = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component3 = keyboardFocusManager2.getGlobalFocusOwner();
        Component component4 = keyboardFocusManager2.getNativeFocusOwner();
        Window window = keyboardFocusManager2.getNativeFocusedWindow();
        if (focusLog.isLoggable(400)) {
            focusLog.finer("SNFH for {0} in {1}", String.valueOf(component2), String.valueOf(component));
        }
        if (focusLog.isLoggable(300)) {
            focusLog.finest("0. Current focus owner {0}", String.valueOf(component3));
            focusLog.finest("0. Native focus owner {0}", String.valueOf(component4));
            focusLog.finest("0. Native focused window {0}", String.valueOf(window));
        }
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            HeavyweightFocusRequest heavyweightFocusRequest = KeyboardFocusManager.getLastHWRequest();
            if (focusLog.isLoggable(300)) {
                focusLog.finest("Request {0}", String.valueOf(heavyweightFocusRequest));
            }
            if (heavyweightFocusRequest == null && component == component4 && component.getContainingWindow() == window) {
                CausedFocusEvent causedFocusEvent;
                if (component2 == component3) {
                    if (focusLog.isLoggable(300)) {
                        focusLog.finest("1. SNFH_FAILURE for {0}", String.valueOf(component2));
                    }
                    return 0;
                }
                keyboardFocusManager.enqueueKeyEvents(l, component2);
                heavyweightFocusRequest = new HeavyweightFocusRequest(component, component2, bl, cause);
                heavyweightRequests.add(heavyweightFocusRequest);
                if (component3 != null) {
                    causedFocusEvent = new CausedFocusEvent(component3, 1005, bl, component2, cause);
                    SunToolkit.postEvent(component3.appContext, causedFocusEvent);
                }
                causedFocusEvent = new CausedFocusEvent(component2, 1004, bl, component3, cause);
                SunToolkit.postEvent(component2.appContext, causedFocusEvent);
                if (focusLog.isLoggable(300)) {
                    focusLog.finest("2. SNFH_HANDLED for {0}", String.valueOf(component2));
                }
                return 1;
            }
            if (heavyweightFocusRequest != null && heavyweightFocusRequest.heavyweight == component) {
                if (heavyweightFocusRequest.addLightweightRequest(component2, bl, cause)) {
                    keyboardFocusManager.enqueueKeyEvents(l, component2);
                }
                if (focusLog.isLoggable(300)) {
                    focusLog.finest("3. SNFH_HANDLED for lightweight" + component2 + " in " + component);
                }
                return 1;
            }
            if (!bl2) {
                if (heavyweightFocusRequest == HeavyweightFocusRequest.CLEAR_GLOBAL_FOCUS_OWNER) {
                    int n = heavyweightRequests.size();
                    heavyweightFocusRequest = n >= 2 ? heavyweightRequests.get(n - 2) : null;
                }
                if (KeyboardFocusManager.focusedWindowChanged(component, heavyweightFocusRequest != null ? heavyweightFocusRequest.heavyweight : window)) {
                    if (focusLog.isLoggable(300)) {
                        focusLog.finest("4. SNFH_FAILURE for " + component2);
                    }
                    return 0;
                }
            }
            keyboardFocusManager.enqueueKeyEvents(l, component2);
            heavyweightRequests.add(new HeavyweightFocusRequest(component, component2, bl, cause));
            if (focusLog.isLoggable(300)) {
                focusLog.finest("5. SNFH_PROCEED for " + component2);
            }
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Window markClearGlobalFocusOwner() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getNativeFocusedWindow();
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            Container container;
            HeavyweightFocusRequest heavyweightFocusRequest = KeyboardFocusManager.getLastHWRequest();
            if (heavyweightFocusRequest == HeavyweightFocusRequest.CLEAR_GLOBAL_FOCUS_OWNER) {
                return null;
            }
            heavyweightRequests.add(HeavyweightFocusRequest.CLEAR_GLOBAL_FOCUS_OWNER);
            Window window2 = container = heavyweightFocusRequest != null ? SunToolkit.getContainingWindow(heavyweightFocusRequest.heavyweight) : window;
            while (container != null && !(container instanceof Frame) && !(container instanceof Dialog)) {
                container = container.getParent_NoClientCode();
            }
            return container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Component getCurrentWaitingRequest(Component component) {
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            LightweightFocusRequest lightweightFocusRequest;
            HeavyweightFocusRequest heavyweightFocusRequest = KeyboardFocusManager.getFirstHWRequest();
            if (heavyweightFocusRequest != null && heavyweightFocusRequest.heavyweight == component && (lightweightFocusRequest = heavyweightFocusRequest.lightweightRequests.getFirst()) != null) {
                return lightweightFocusRequest.component;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isAutoFocusTransferEnabled() {
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            return heavyweightRequests.size() == 0 && !disableRestoreFocus && null == currentLightweightRequests;
        }
    }

    static boolean isAutoFocusTransferEnabledFor(Component component) {
        return KeyboardFocusManager.isAutoFocusTransferEnabled() && component.isAutoFocusTransferOnDisposal();
    }

    private static Throwable dispatchAndCatchException(Throwable throwable, Component component, FocusEvent focusEvent) {
        Throwable throwable2 = null;
        try {
            component.dispatchEvent(focusEvent);
        }
        catch (RuntimeException runtimeException) {
            throwable2 = runtimeException;
        }
        catch (Error error) {
            throwable2 = error;
        }
        if (throwable2 != null) {
            if (throwable != null) {
                KeyboardFocusManager.handleException(throwable);
            }
            return throwable2;
        }
        return throwable;
    }

    private static void handleException(Throwable throwable) {
        throwable.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processCurrentLightweightRequests() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        LinkedList<LightweightFocusRequest> linkedList = null;
        Component component = keyboardFocusManager.getGlobalFocusOwner();
        if (component != null && component.appContext != AppContext.getAppContext()) {
            return;
        }
        Serializable serializable = heavyweightRequests;
        synchronized (serializable) {
            if (currentLightweightRequests == null) {
                return;
            }
            clearingCurrentLightweightRequests = true;
            disableRestoreFocus = true;
            linkedList = currentLightweightRequests;
            allowSyncFocusRequests = linkedList.size() < 2;
            currentLightweightRequests = null;
        }
        serializable = null;
        try {
            if (linkedList != null) {
                Component component2 = null;
                Component component3 = null;
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    component3 = keyboardFocusManager.getGlobalFocusOwner();
                    LightweightFocusRequest lightweightFocusRequest = (LightweightFocusRequest)iterator.next();
                    if (!iterator.hasNext()) {
                        disableRestoreFocus = false;
                    }
                    CausedFocusEvent causedFocusEvent = null;
                    if (component3 != null) {
                        causedFocusEvent = new CausedFocusEvent(component3, 1005, lightweightFocusRequest.temporary, lightweightFocusRequest.component, lightweightFocusRequest.cause);
                    }
                    CausedFocusEvent causedFocusEvent2 = new CausedFocusEvent(lightweightFocusRequest.component, 1004, lightweightFocusRequest.temporary, component3 == null ? component2 : component3, lightweightFocusRequest.cause);
                    if (component3 != null) {
                        causedFocusEvent.isPosted = true;
                        serializable = KeyboardFocusManager.dispatchAndCatchException(serializable, component3, causedFocusEvent);
                    }
                    causedFocusEvent2.isPosted = true;
                    serializable = KeyboardFocusManager.dispatchAndCatchException(serializable, lightweightFocusRequest.component, causedFocusEvent2);
                    if (keyboardFocusManager.getGlobalFocusOwner() != lightweightFocusRequest.component) continue;
                    component2 = lightweightFocusRequest.component;
                }
            }
        }
        finally {
            clearingCurrentLightweightRequests = false;
            disableRestoreFocus = false;
            linkedList = null;
            allowSyncFocusRequests = true;
        }
        if (serializable instanceof RuntimeException) {
            throw (RuntimeException)serializable;
        }
        if (serializable instanceof Error) {
            throw (Error)serializable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FocusEvent retargetUnexpectedFocusEvent(FocusEvent focusEvent) {
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            if (KeyboardFocusManager.removeFirstRequest()) {
                return (FocusEvent)KeyboardFocusManager.retargetFocusEvent(focusEvent);
            }
            Component component = focusEvent.getComponent();
            Component component2 = focusEvent.getOppositeComponent();
            boolean bl = false;
            if (focusEvent.getID() == 1005 && (component2 == null || KeyboardFocusManager.isTemporary(component2, component))) {
                bl = true;
            }
            return new CausedFocusEvent(component, focusEvent.getID(), bl, component2, CausedFocusEvent.Cause.NATIVE_SYSTEM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FocusEvent retargetFocusGained(FocusEvent focusEvent) {
        assert (focusEvent.getID() == 1004);
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getGlobalFocusOwner();
        Component component2 = focusEvent.getComponent();
        Component component3 = focusEvent.getOppositeComponent();
        Component component4 = KeyboardFocusManager.getHeavyweight(component2);
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            HeavyweightFocusRequest heavyweightFocusRequest = KeyboardFocusManager.getFirstHWRequest();
            if (heavyweightFocusRequest == HeavyweightFocusRequest.CLEAR_GLOBAL_FOCUS_OWNER) {
                return KeyboardFocusManager.retargetUnexpectedFocusEvent(focusEvent);
            }
            if (component2 != null && component4 == null && heavyweightFocusRequest != null && component2 == heavyweightFocusRequest.getFirstLightweightRequest().component) {
                component4 = component2 = heavyweightFocusRequest.heavyweight;
            }
            if (heavyweightFocusRequest != null && component4 == heavyweightFocusRequest.heavyweight) {
                boolean bl;
                heavyweightRequests.removeFirst();
                LightweightFocusRequest lightweightFocusRequest = heavyweightFocusRequest.lightweightRequests.removeFirst();
                Component component5 = lightweightFocusRequest.component;
                if (component != null) {
                    newFocusOwner = component5;
                }
                boolean bl2 = bl = component3 == null || KeyboardFocusManager.isTemporary(component5, component3) ? false : lightweightFocusRequest.temporary;
                if (heavyweightFocusRequest.lightweightRequests.size() > 0) {
                    currentLightweightRequests = heavyweightFocusRequest.lightweightRequests;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KeyboardFocusManager.processCurrentLightweightRequests();
                        }
                    });
                }
                return new CausedFocusEvent(component5, 1004, bl, component3, lightweightFocusRequest.cause);
            }
            if (component != null && component.getContainingWindow() == component2 && (heavyweightFocusRequest == null || component2 != heavyweightFocusRequest.heavyweight)) {
                return new CausedFocusEvent(component, 1004, false, null, CausedFocusEvent.Cause.ACTIVATION);
            }
            return KeyboardFocusManager.retargetUnexpectedFocusEvent(focusEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FocusEvent retargetFocusLost(FocusEvent focusEvent) {
        assert (focusEvent.getID() == 1005);
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getGlobalFocusOwner();
        Component component2 = focusEvent.getOppositeComponent();
        Component component3 = KeyboardFocusManager.getHeavyweight(component2);
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            HeavyweightFocusRequest heavyweightFocusRequest = KeyboardFocusManager.getFirstHWRequest();
            if (heavyweightFocusRequest == HeavyweightFocusRequest.CLEAR_GLOBAL_FOCUS_OWNER) {
                if (component != null) {
                    heavyweightRequests.removeFirst();
                    return new CausedFocusEvent(component, 1005, false, null, CausedFocusEvent.Cause.CLEAR_GLOBAL_FOCUS_OWNER);
                }
            } else {
                if (component2 == null) {
                    if (component != null) {
                        return new CausedFocusEvent(component, 1005, true, null, CausedFocusEvent.Cause.ACTIVATION);
                    }
                    return focusEvent;
                }
                if (heavyweightFocusRequest != null && (component3 == heavyweightFocusRequest.heavyweight || component3 == null && component2 == heavyweightFocusRequest.getFirstLightweightRequest().component)) {
                    if (component == null) {
                        return focusEvent;
                    }
                    LightweightFocusRequest lightweightFocusRequest = heavyweightFocusRequest.lightweightRequests.getFirst();
                    boolean bl = KeyboardFocusManager.isTemporary(component2, component) ? true : lightweightFocusRequest.temporary;
                    return new CausedFocusEvent(component, 1005, bl, lightweightFocusRequest.component, lightweightFocusRequest.cause);
                }
                if (KeyboardFocusManager.focusedWindowChanged(component2, component)) {
                    if (!focusEvent.isTemporary() && component != null) {
                        focusEvent = new CausedFocusEvent(component, 1005, true, component2, CausedFocusEvent.Cause.ACTIVATION);
                    }
                    return focusEvent;
                }
            }
            return KeyboardFocusManager.retargetUnexpectedFocusEvent(focusEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AWTEvent retargetFocusEvent(AWTEvent aWTEvent) {
        if (clearingCurrentLightweightRequests) {
            return aWTEvent;
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (focusLog.isLoggable(400)) {
            if (aWTEvent instanceof FocusEvent || aWTEvent instanceof WindowEvent) {
                focusLog.finer(">>> {0}", String.valueOf(aWTEvent));
            }
            if (focusLog.isLoggable(400) && aWTEvent instanceof KeyEvent) {
                focusLog.finer("    focus owner is {0}", String.valueOf(keyboardFocusManager.getGlobalFocusOwner()));
                focusLog.finer(">>> {0}", String.valueOf(aWTEvent));
            }
        }
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            if (newFocusOwner != null && aWTEvent.getID() == 1005) {
                FocusEvent focusEvent = (FocusEvent)aWTEvent;
                if (keyboardFocusManager.getGlobalFocusOwner() == focusEvent.getComponent() && focusEvent.getOppositeComponent() == newFocusOwner) {
                    newFocusOwner = null;
                    return aWTEvent;
                }
            }
        }
        KeyboardFocusManager.processCurrentLightweightRequests();
        switch (aWTEvent.getID()) {
            case 1004: {
                aWTEvent = KeyboardFocusManager.retargetFocusGained((FocusEvent)aWTEvent);
                break;
            }
            case 1005: {
                aWTEvent = KeyboardFocusManager.retargetFocusLost((FocusEvent)aWTEvent);
                break;
            }
        }
        return aWTEvent;
    }

    void clearMarkers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeFirstRequest() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            HeavyweightFocusRequest heavyweightFocusRequest = KeyboardFocusManager.getFirstHWRequest();
            if (heavyweightFocusRequest != null) {
                heavyweightRequests.removeFirst();
                if (heavyweightFocusRequest.lightweightRequests != null) {
                    Iterator iterator = heavyweightFocusRequest.lightweightRequests.iterator();
                    while (iterator.hasNext()) {
                        keyboardFocusManager.dequeueKeyEvents(-1L, ((LightweightFocusRequest)iterator.next()).component);
                    }
                }
            }
            if (heavyweightRequests.size() == 0) {
                keyboardFocusManager.clearMarkers();
            }
            return heavyweightRequests.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeLastFocusRequest(Component component) {
        if (log.isLoggable(500) && component == null) {
            log.fine("Assertion (heavyweight != null) failed");
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            HeavyweightFocusRequest heavyweightFocusRequest = KeyboardFocusManager.getLastHWRequest();
            if (heavyweightFocusRequest != null && heavyweightFocusRequest.heavyweight == component) {
                heavyweightRequests.removeLast();
            }
            if (heavyweightRequests.size() == 0) {
                keyboardFocusManager.clearMarkers();
            }
        }
    }

    private static boolean focusedWindowChanged(Component component, Component component2) {
        Window window = SunToolkit.getContainingWindow(component);
        Window window2 = SunToolkit.getContainingWindow(component2);
        if (window == null && window2 == null) {
            return true;
        }
        if (window == null) {
            return true;
        }
        if (window2 == null) {
            return true;
        }
        return window != window2;
    }

    private static boolean isTemporary(Component component, Component component2) {
        Window window = SunToolkit.getContainingWindow(component);
        Window window2 = SunToolkit.getContainingWindow(component2);
        if (window == null && window2 == null) {
            return false;
        }
        if (window == null) {
            return true;
        }
        if (window2 == null) {
            return false;
        }
        return window != window2;
    }

    static Component getHeavyweight(Component component) {
        if (component == null || component.getPeer() == null) {
            return null;
        }
        if (component.getPeer() instanceof LightweightPeer) {
            return component.getNativeContainer();
        }
        return component;
    }

    private static boolean isProxyActiveImpl(KeyEvent keyEvent) {
        if (proxyActive == null) {
            proxyActive = (Field)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Field field;
                    block3: {
                        field = null;
                        try {
                            field = KeyEvent.class.getDeclaredField("isProxyActive");
                            if (field != null) {
                                field.setAccessible(true);
                            }
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            if ($assertionsDisabled) break block3;
                            throw new AssertionError();
                        }
                    }
                    return field;
                }
            });
        }
        try {
            return proxyActive.getBoolean(keyEvent);
        }
        catch (IllegalAccessException illegalAccessException) {
            assert (false);
            return false;
        }
    }

    static boolean isProxyActive(KeyEvent keyEvent) {
        if (!GraphicsEnvironment.isHeadless()) {
            return KeyboardFocusManager.isProxyActiveImpl(keyEvent);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HeavyweightFocusRequest getLastHWRequest() {
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            return heavyweightRequests.size() > 0 ? heavyweightRequests.getLast() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HeavyweightFocusRequest getFirstHWRequest() {
        LinkedList<HeavyweightFocusRequest> linkedList = heavyweightRequests;
        synchronized (linkedList) {
            return heavyweightRequests.size() > 0 ? heavyweightRequests.getFirst() : null;
        }
    }

    private static void checkReplaceKFMPermission() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (replaceKeyboardFocusManagerPermission == null) {
                replaceKeyboardFocusManagerPermission = new AWTPermission("replaceKeyboardFocusManager");
            }
            securityManager.checkPermission(replaceKeyboardFocusManagerPermission);
        }
    }

    private void checkKFMSecurity() {
        if (this != KeyboardFocusManager.getCurrentKeyboardFocusManager()) {
            KeyboardFocusManager.checkReplaceKFMPermission();
        }
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            KeyboardFocusManager.initIDs();
        }
        AWTAccessor.setKeyboardFocusManagerAccessor(new AWTAccessor.KeyboardFocusManagerAccessor(){

            @Override
            public int shouldNativelyFocusHeavyweight(Component component, Component component2, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
                return KeyboardFocusManager.shouldNativelyFocusHeavyweight(component, component2, bl, bl2, l, cause);
            }

            @Override
            public boolean processSynchronousLightweightTransfer(Component component, Component component2, boolean bl, boolean bl2, long l) {
                return KeyboardFocusManager.processSynchronousLightweightTransfer(component, component2, bl, bl2, l);
            }

            @Override
            public void removeLastFocusRequest(Component component) {
                KeyboardFocusManager.removeLastFocusRequest(component);
            }

            @Override
            public void setMostRecentFocusOwner(Window window, Component component) {
                KeyboardFocusManager.setMostRecentFocusOwner(window, component);
            }

            @Override
            public KeyboardFocusManager getCurrentKeyboardFocusManager(AppContext appContext) {
                return KeyboardFocusManager.getCurrentKeyboardFocusManager(appContext);
            }

            @Override
            public Container getCurrentFocusCycleRoot() {
                return currentFocusCycleRoot;
            }
        });
        log = PlatformLogger.getLogger("java.awt.KeyboardFocusManager");
        defaultFocusTraversalKeyPropertyNames = new String[]{"forwardDefaultFocusTraversalKeys", "backwardDefaultFocusTraversalKeys", "upCycleDefaultFocusTraversalKeys", "downCycleDefaultFocusTraversalKeys"};
        defaultFocusTraversalKeyStrokes = new AWTKeyStroke[][]{{AWTKeyStroke.getAWTKeyStroke(9, 0, false), AWTKeyStroke.getAWTKeyStroke(9, 130, false)}, {AWTKeyStroke.getAWTKeyStroke(9, 65, false), AWTKeyStroke.getAWTKeyStroke(9, 195, false)}, new AWTKeyStroke[0], new AWTKeyStroke[0]};
        mostRecentFocusOwners = new WeakHashMap();
        heavyweightRequests = new LinkedList();
        allowSyncFocusRequests = true;
        newFocusOwner = null;
    }

    private static final class HeavyweightFocusRequest {
        final Component heavyweight;
        final LinkedList<LightweightFocusRequest> lightweightRequests;
        static final HeavyweightFocusRequest CLEAR_GLOBAL_FOCUS_OWNER = new HeavyweightFocusRequest();

        private HeavyweightFocusRequest() {
            this.heavyweight = null;
            this.lightweightRequests = null;
        }

        HeavyweightFocusRequest(Component component, Component component2, boolean bl, CausedFocusEvent.Cause cause) {
            if (log.isLoggable(500) && component == null) {
                log.fine("Assertion (heavyweight != null) failed");
            }
            this.heavyweight = component;
            this.lightweightRequests = new LinkedList();
            this.addLightweightRequest(component2, bl, cause);
        }

        boolean addLightweightRequest(Component component, boolean bl, CausedFocusEvent.Cause cause) {
            Component component2;
            if (log.isLoggable(500)) {
                if (this == CLEAR_GLOBAL_FOCUS_OWNER) {
                    log.fine("Assertion (this != HeavyweightFocusRequest.CLEAR_GLOBAL_FOCUS_OWNER) failed");
                }
                if (component == null) {
                    log.fine("Assertion (descendant != null) failed");
                }
            }
            Component component3 = component2 = this.lightweightRequests.size() > 0 ? this.lightweightRequests.getLast().component : null;
            if (component != component2) {
                this.lightweightRequests.add(new LightweightFocusRequest(component, bl, cause));
                return true;
            }
            return false;
        }

        LightweightFocusRequest getFirstLightweightRequest() {
            if (this == CLEAR_GLOBAL_FOCUS_OWNER) {
                return null;
            }
            return this.lightweightRequests.getFirst();
        }

        public String toString() {
            boolean bl = true;
            String string = "HeavyweightFocusRequest[heavweight=" + this.heavyweight + ",lightweightRequests=";
            if (this.lightweightRequests == null) {
                string = string + null;
            } else {
                string = string + "[";
                for (LightweightFocusRequest lightweightFocusRequest : this.lightweightRequests) {
                    if (bl) {
                        bl = false;
                    } else {
                        string = string + ",";
                    }
                    string = string + lightweightFocusRequest;
                }
                string = string + "]";
            }
            string = string + "]";
            return string;
        }
    }

    private static final class LightweightFocusRequest {
        final Component component;
        final boolean temporary;
        final CausedFocusEvent.Cause cause;

        LightweightFocusRequest(Component component, boolean bl, CausedFocusEvent.Cause cause) {
            this.component = component;
            this.temporary = bl;
            this.cause = cause;
        }

        public String toString() {
            return "LightweightFocusRequest[component=" + this.component + ",temporary=" + this.temporary + ", cause=" + (Object)((Object)this.cause) + "]";
        }
    }
}

