/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class GlyphVector
implements Cloneable {
    public static final int FLAG_HAS_TRANSFORMS = 1;
    public static final int FLAG_HAS_POSITION_ADJUSTMENTS = 2;
    public static final int FLAG_RUN_RTL = 4;
    public static final int FLAG_COMPLEX_GLYPHS = 8;
    public static final int FLAG_MASK = 15;

    public abstract Font getFont();

    public abstract FontRenderContext getFontRenderContext();

    public abstract void performDefaultLayout();

    public abstract int getNumGlyphs();

    public abstract int getGlyphCode(int var1);

    public abstract int[] getGlyphCodes(int var1, int var2, int[] var3);

    public int getGlyphCharIndex(int n) {
        return n;
    }

    public int[] getGlyphCharIndices(int n, int n2, int[] nArray) {
        if (nArray == null) {
            nArray = new int[n2];
        }
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            nArray[n3] = this.getGlyphCharIndex(n4);
            ++n3;
            ++n4;
        }
        return nArray;
    }

    public abstract Rectangle2D getLogicalBounds();

    public abstract Rectangle2D getVisualBounds();

    public Rectangle getPixelBounds(FontRenderContext fontRenderContext, float f, float f2) {
        Rectangle2D rectangle2D = this.getVisualBounds();
        int n = (int)Math.floor(rectangle2D.getX() + (double)f);
        int n2 = (int)Math.floor(rectangle2D.getY() + (double)f2);
        int n3 = (int)Math.ceil(rectangle2D.getMaxX() + (double)f);
        int n4 = (int)Math.ceil(rectangle2D.getMaxY() + (double)f2);
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public abstract Shape getOutline();

    public abstract Shape getOutline(float var1, float var2);

    public abstract Shape getGlyphOutline(int var1);

    public Shape getGlyphOutline(int n, float f, float f2) {
        Shape shape = this.getGlyphOutline(n);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        return affineTransform.createTransformedShape(shape);
    }

    public abstract Point2D getGlyphPosition(int var1);

    public abstract void setGlyphPosition(int var1, Point2D var2);

    public abstract AffineTransform getGlyphTransform(int var1);

    public abstract void setGlyphTransform(int var1, AffineTransform var2);

    public int getLayoutFlags() {
        return 0;
    }

    public abstract float[] getGlyphPositions(int var1, int var2, float[] var3);

    public abstract Shape getGlyphLogicalBounds(int var1);

    public abstract Shape getGlyphVisualBounds(int var1);

    public Rectangle getGlyphPixelBounds(int n, FontRenderContext fontRenderContext, float f, float f2) {
        Rectangle2D rectangle2D = this.getGlyphVisualBounds(n).getBounds2D();
        int n2 = (int)Math.floor(rectangle2D.getX() + (double)f);
        int n3 = (int)Math.floor(rectangle2D.getY() + (double)f2);
        int n4 = (int)Math.ceil(rectangle2D.getMaxX() + (double)f);
        int n5 = (int)Math.ceil(rectangle2D.getMaxY() + (double)f2);
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    public abstract GlyphMetrics getGlyphMetrics(int var1);

    public abstract GlyphJustificationInfo getGlyphJustificationInfo(int var1);

    public abstract boolean equals(GlyphVector var1);
}

