/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import sun.util.locale.Extension;
import sun.util.locale.LocaleUtils;

public class UnicodeLocaleExtension
extends Extension {
    public static final char SINGLETON = 'u';
    private final Set<String> attributes;
    private final Map<String, String> keywords;
    public static final UnicodeLocaleExtension CA_JAPANESE = new UnicodeLocaleExtension("ca", "japanese");
    public static final UnicodeLocaleExtension NU_THAI = new UnicodeLocaleExtension("nu", "thai");

    private UnicodeLocaleExtension(String string, String string2) {
        super('u', string + "-" + string2);
        this.attributes = Collections.emptySet();
        this.keywords = Collections.singletonMap(string, string2);
    }

    UnicodeLocaleExtension(SortedSet<String> sortedSet, SortedMap<String, String> sortedMap) {
        super('u');
        this.attributes = sortedSet != null ? sortedSet : Collections.emptySet();
        this.keywords = sortedMap != null ? sortedMap : Collections.emptyMap();
        if (!this.attributes.isEmpty() || !this.keywords.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String object : this.attributes) {
                stringBuilder.append("-").append(object);
            }
            for (Map.Entry entry : this.keywords.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                stringBuilder.append("-").append(string);
                if (string2.length() <= 0) continue;
                stringBuilder.append("-").append(string2);
            }
            this.setValue(stringBuilder.substring(1));
        }
    }

    public Set<String> getUnicodeLocaleAttributes() {
        if (this.attributes == Collections.EMPTY_SET) {
            return this.attributes;
        }
        return Collections.unmodifiableSet(this.attributes);
    }

    public Set<String> getUnicodeLocaleKeys() {
        if (this.keywords == Collections.EMPTY_MAP) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.keywords.keySet());
    }

    public String getUnicodeLocaleType(String string) {
        return this.keywords.get(string);
    }

    public static boolean isSingletonChar(char c) {
        return 'u' == LocaleUtils.toLower(c);
    }

    public static boolean isAttribute(String string) {
        int n = string.length();
        return n >= 3 && n <= 8 && LocaleUtils.isAlphaNumericString(string);
    }

    public static boolean isKey(String string) {
        return string.length() == 2 && LocaleUtils.isAlphaNumericString(string);
    }

    public static boolean isTypeSubtag(String string) {
        int n = string.length();
        return n >= 3 && n <= 8 && LocaleUtils.isAlphaNumericString(string);
    }
}

