// Copyright 2011 The Closure Library Authors. All Rights Reserved
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Number formatting symbols.
 *
 * This file is autogenerated by script:
 * http://go/generate_number_constants.py
 * using the --for_closure flag.
 *
 * To reduce the file size (which may cause issues in some JS
 * developing environments), this file will only contain locales
 * that are frequently used by web applications. This is defined as
 * closure_tier1_locales and will change (most likely addition)
 * over time.  Rest of the data can be found in another file named
 * "numberformatsymbolsext.js", which will be generated at the
 * same time together with this file.
 *
 * Before checkin, this file could have been manually edited. This is
 * to incorporate changes before we could fix CLDR. All manual
 * modification must be documented in this section, and should be
 * removed after those changes land to CLDR.
 */

goog.provide('goog.i18n.NumberFormatSymbols');
goog.provide('goog.i18n.NumberFormatSymbols_af');
goog.provide('goog.i18n.NumberFormatSymbols_af_ZA');
goog.provide('goog.i18n.NumberFormatSymbols_am');
goog.provide('goog.i18n.NumberFormatSymbols_am_ET');
goog.provide('goog.i18n.NumberFormatSymbols_ar');
goog.provide('goog.i18n.NumberFormatSymbols_ar_001');
goog.provide('goog.i18n.NumberFormatSymbols_ar_EG');
goog.provide('goog.i18n.NumberFormatSymbols_bg');
goog.provide('goog.i18n.NumberFormatSymbols_bg_BG');
goog.provide('goog.i18n.NumberFormatSymbols_bn');
goog.provide('goog.i18n.NumberFormatSymbols_bn_BD');
goog.provide('goog.i18n.NumberFormatSymbols_ca');
goog.provide('goog.i18n.NumberFormatSymbols_ca_AD');
goog.provide('goog.i18n.NumberFormatSymbols_ca_ES');
goog.provide('goog.i18n.NumberFormatSymbols_cs');
goog.provide('goog.i18n.NumberFormatSymbols_cs_CZ');
goog.provide('goog.i18n.NumberFormatSymbols_da');
goog.provide('goog.i18n.NumberFormatSymbols_da_DK');
goog.provide('goog.i18n.NumberFormatSymbols_de');
goog.provide('goog.i18n.NumberFormatSymbols_de_AT');
goog.provide('goog.i18n.NumberFormatSymbols_de_BE');
goog.provide('goog.i18n.NumberFormatSymbols_de_CH');
goog.provide('goog.i18n.NumberFormatSymbols_de_DE');
goog.provide('goog.i18n.NumberFormatSymbols_de_LU');
goog.provide('goog.i18n.NumberFormatSymbols_el');
goog.provide('goog.i18n.NumberFormatSymbols_el_GR');
goog.provide('goog.i18n.NumberFormatSymbols_en');
goog.provide('goog.i18n.NumberFormatSymbols_en_AS');
goog.provide('goog.i18n.NumberFormatSymbols_en_AU');
goog.provide('goog.i18n.NumberFormatSymbols_en_Dsrt_US');
goog.provide('goog.i18n.NumberFormatSymbols_en_FM');
goog.provide('goog.i18n.NumberFormatSymbols_en_GB');
goog.provide('goog.i18n.NumberFormatSymbols_en_GU');
goog.provide('goog.i18n.NumberFormatSymbols_en_IE');
goog.provide('goog.i18n.NumberFormatSymbols_en_IN');
goog.provide('goog.i18n.NumberFormatSymbols_en_MH');
goog.provide('goog.i18n.NumberFormatSymbols_en_MP');
goog.provide('goog.i18n.NumberFormatSymbols_en_PR');
goog.provide('goog.i18n.NumberFormatSymbols_en_PW');
goog.provide('goog.i18n.NumberFormatSymbols_en_SG');
goog.provide('goog.i18n.NumberFormatSymbols_en_TC');
goog.provide('goog.i18n.NumberFormatSymbols_en_UM');
goog.provide('goog.i18n.NumberFormatSymbols_en_US');
goog.provide('goog.i18n.NumberFormatSymbols_en_VG');
goog.provide('goog.i18n.NumberFormatSymbols_en_VI');
goog.provide('goog.i18n.NumberFormatSymbols_en_ZA');
goog.provide('goog.i18n.NumberFormatSymbols_es');
goog.provide('goog.i18n.NumberFormatSymbols_es_419');
goog.provide('goog.i18n.NumberFormatSymbols_es_EA');
goog.provide('goog.i18n.NumberFormatSymbols_es_ES');
goog.provide('goog.i18n.NumberFormatSymbols_es_IC');
goog.provide('goog.i18n.NumberFormatSymbols_et');
goog.provide('goog.i18n.NumberFormatSymbols_et_EE');
goog.provide('goog.i18n.NumberFormatSymbols_eu');
goog.provide('goog.i18n.NumberFormatSymbols_eu_ES');
goog.provide('goog.i18n.NumberFormatSymbols_fa');
goog.provide('goog.i18n.NumberFormatSymbols_fa_IR');
goog.provide('goog.i18n.NumberFormatSymbols_fi');
goog.provide('goog.i18n.NumberFormatSymbols_fi_FI');
goog.provide('goog.i18n.NumberFormatSymbols_fil');
goog.provide('goog.i18n.NumberFormatSymbols_fil_PH');
goog.provide('goog.i18n.NumberFormatSymbols_fr');
goog.provide('goog.i18n.NumberFormatSymbols_fr_BL');
goog.provide('goog.i18n.NumberFormatSymbols_fr_CA');
goog.provide('goog.i18n.NumberFormatSymbols_fr_FR');
goog.provide('goog.i18n.NumberFormatSymbols_fr_GF');
goog.provide('goog.i18n.NumberFormatSymbols_fr_GP');
goog.provide('goog.i18n.NumberFormatSymbols_fr_MC');
goog.provide('goog.i18n.NumberFormatSymbols_fr_MF');
goog.provide('goog.i18n.NumberFormatSymbols_fr_MQ');
goog.provide('goog.i18n.NumberFormatSymbols_fr_RE');
goog.provide('goog.i18n.NumberFormatSymbols_fr_YT');
goog.provide('goog.i18n.NumberFormatSymbols_gl');
goog.provide('goog.i18n.NumberFormatSymbols_gl_ES');
goog.provide('goog.i18n.NumberFormatSymbols_gsw');
goog.provide('goog.i18n.NumberFormatSymbols_gsw_CH');
goog.provide('goog.i18n.NumberFormatSymbols_gu');
goog.provide('goog.i18n.NumberFormatSymbols_gu_IN');
goog.provide('goog.i18n.NumberFormatSymbols_he');
goog.provide('goog.i18n.NumberFormatSymbols_he_IL');
goog.provide('goog.i18n.NumberFormatSymbols_hi');
goog.provide('goog.i18n.NumberFormatSymbols_hi_IN');
goog.provide('goog.i18n.NumberFormatSymbols_hr');
goog.provide('goog.i18n.NumberFormatSymbols_hr_HR');
goog.provide('goog.i18n.NumberFormatSymbols_hu');
goog.provide('goog.i18n.NumberFormatSymbols_hu_HU');
goog.provide('goog.i18n.NumberFormatSymbols_id');
goog.provide('goog.i18n.NumberFormatSymbols_id_ID');
goog.provide('goog.i18n.NumberFormatSymbols_in');
goog.provide('goog.i18n.NumberFormatSymbols_is');
goog.provide('goog.i18n.NumberFormatSymbols_is_IS');
goog.provide('goog.i18n.NumberFormatSymbols_it');
goog.provide('goog.i18n.NumberFormatSymbols_it_IT');
goog.provide('goog.i18n.NumberFormatSymbols_it_SM');
goog.provide('goog.i18n.NumberFormatSymbols_iw');
goog.provide('goog.i18n.NumberFormatSymbols_ja');
goog.provide('goog.i18n.NumberFormatSymbols_ja_JP');
goog.provide('goog.i18n.NumberFormatSymbols_kn');
goog.provide('goog.i18n.NumberFormatSymbols_kn_IN');
goog.provide('goog.i18n.NumberFormatSymbols_ko');
goog.provide('goog.i18n.NumberFormatSymbols_ko_KR');
goog.provide('goog.i18n.NumberFormatSymbols_ln');
goog.provide('goog.i18n.NumberFormatSymbols_ln_CD');
goog.provide('goog.i18n.NumberFormatSymbols_lt');
goog.provide('goog.i18n.NumberFormatSymbols_lt_LT');
goog.provide('goog.i18n.NumberFormatSymbols_lv');
goog.provide('goog.i18n.NumberFormatSymbols_lv_LV');
goog.provide('goog.i18n.NumberFormatSymbols_ml');
goog.provide('goog.i18n.NumberFormatSymbols_ml_IN');
goog.provide('goog.i18n.NumberFormatSymbols_mr');
goog.provide('goog.i18n.NumberFormatSymbols_mr_IN');
goog.provide('goog.i18n.NumberFormatSymbols_ms');
goog.provide('goog.i18n.NumberFormatSymbols_ms_MY');
goog.provide('goog.i18n.NumberFormatSymbols_mt');
goog.provide('goog.i18n.NumberFormatSymbols_mt_MT');
goog.provide('goog.i18n.NumberFormatSymbols_nl');
goog.provide('goog.i18n.NumberFormatSymbols_nl_CW');
goog.provide('goog.i18n.NumberFormatSymbols_nl_NL');
goog.provide('goog.i18n.NumberFormatSymbols_nl_SX');
goog.provide('goog.i18n.NumberFormatSymbols_no');
goog.provide('goog.i18n.NumberFormatSymbols_or');
goog.provide('goog.i18n.NumberFormatSymbols_or_IN');
goog.provide('goog.i18n.NumberFormatSymbols_pl');
goog.provide('goog.i18n.NumberFormatSymbols_pl_PL');
goog.provide('goog.i18n.NumberFormatSymbols_pt');
goog.provide('goog.i18n.NumberFormatSymbols_pt_BR');
goog.provide('goog.i18n.NumberFormatSymbols_pt_PT');
goog.provide('goog.i18n.NumberFormatSymbols_ro');
goog.provide('goog.i18n.NumberFormatSymbols_ro_RO');
goog.provide('goog.i18n.NumberFormatSymbols_ru');
goog.provide('goog.i18n.NumberFormatSymbols_ru_RU');
goog.provide('goog.i18n.NumberFormatSymbols_sk');
goog.provide('goog.i18n.NumberFormatSymbols_sk_SK');
goog.provide('goog.i18n.NumberFormatSymbols_sl');
goog.provide('goog.i18n.NumberFormatSymbols_sl_SI');
goog.provide('goog.i18n.NumberFormatSymbols_sq');
goog.provide('goog.i18n.NumberFormatSymbols_sq_AL');
goog.provide('goog.i18n.NumberFormatSymbols_sr');
goog.provide('goog.i18n.NumberFormatSymbols_sr_Cyrl_RS');
goog.provide('goog.i18n.NumberFormatSymbols_sr_Latn_RS');
goog.provide('goog.i18n.NumberFormatSymbols_sv');
goog.provide('goog.i18n.NumberFormatSymbols_sv_SE');
goog.provide('goog.i18n.NumberFormatSymbols_sw');
goog.provide('goog.i18n.NumberFormatSymbols_sw_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_ta');
goog.provide('goog.i18n.NumberFormatSymbols_ta_IN');
goog.provide('goog.i18n.NumberFormatSymbols_te');
goog.provide('goog.i18n.NumberFormatSymbols_te_IN');
goog.provide('goog.i18n.NumberFormatSymbols_th');
goog.provide('goog.i18n.NumberFormatSymbols_th_TH');
goog.provide('goog.i18n.NumberFormatSymbols_tl');
goog.provide('goog.i18n.NumberFormatSymbols_tr');
goog.provide('goog.i18n.NumberFormatSymbols_tr_TR');
goog.provide('goog.i18n.NumberFormatSymbols_uk');
goog.provide('goog.i18n.NumberFormatSymbols_uk_UA');
goog.provide('goog.i18n.NumberFormatSymbols_ur');
goog.provide('goog.i18n.NumberFormatSymbols_ur_PK');
goog.provide('goog.i18n.NumberFormatSymbols_vi');
goog.provide('goog.i18n.NumberFormatSymbols_vi_VN');
goog.provide('goog.i18n.NumberFormatSymbols_zh');
goog.provide('goog.i18n.NumberFormatSymbols_zh_CN');
goog.provide('goog.i18n.NumberFormatSymbols_zh_HK');
goog.provide('goog.i18n.NumberFormatSymbols_zh_Hans_CN');
goog.provide('goog.i18n.NumberFormatSymbols_zh_TW');
goog.provide('goog.i18n.NumberFormatSymbols_zu');
goog.provide('goog.i18n.NumberFormatSymbols_zu_ZA');


/**
 * Number formatting symbols for locale af.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_af = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'ZAR'
};


/**
 * Number formatting symbols for locale af_ZA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_af_ZA = goog.i18n.NumberFormatSymbols_af;


/**
 * Number formatting symbols for locale am.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_am = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'ETB'
};


/**
 * Number formatting symbols for locale am_ET.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_am_ET = goog.i18n.NumberFormatSymbols_am;


/**
 * Number formatting symbols for locale ar.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar = {
  DECIMAL_SEP: '\u066B',
  GROUP_SEP: '\u066C',
  PERCENT: '\u066A',
  ZERO_DIGIT: '\u0660',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: '\u0627\u0633',
  PERMILL: '\u0609',
  INFINITY: '\u221E',
  NAN: '\u0644\u064A\u0633\u00A0\u0631\u0642\u0645',
  DECIMAL_PATTERN: '#0.###;#0.###-',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4\u00A0#0.00;\u00A4\u00A0#0.00-',
  DEF_CURRENCY_CODE: 'EGP'
};


/**
 * Number formatting symbols for locale ar_001.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_001 = goog.i18n.NumberFormatSymbols_ar;


/**
 * Number formatting symbols for locale ar_EG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_EG = goog.i18n.NumberFormatSymbols_ar;


/**
 * Number formatting symbols for locale bg.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bg = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'BGN'
};


/**
 * Number formatting symbols for locale bg_BG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bg_BG = goog.i18n.NumberFormatSymbols_bg;


/**
 * Number formatting symbols for locale bn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bn = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '\u09e6',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: '\u09B8\u0982\u0996\u09CD\u09AF\u09BE\u00A0\u09A8\u09BE',
  DECIMAL_PATTERN: '#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##,##0%',
  CURRENCY_PATTERN: '#,##,##0.00\u00A4;(#,##,##0.00\u00A4)',
  DEF_CURRENCY_CODE: 'BDT'
};


/**
 * Number formatting symbols for locale bn_BD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bn_BD = goog.i18n.NumberFormatSymbols_bn;


/**
 * Number formatting symbols for locale ca.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ca = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale ca_AD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ca_AD = goog.i18n.NumberFormatSymbols_ca;


/**
 * Number formatting symbols for locale ca_ES.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ca_ES = goog.i18n.NumberFormatSymbols_ca;


/**
 * Number formatting symbols for locale cs.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_cs = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'CZK'
};


/**
 * Number formatting symbols for locale cs_CZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_cs_CZ = goog.i18n.NumberFormatSymbols_cs;


/**
 * Number formatting symbols for locale da.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_da = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'DKK'
};


/**
 * Number formatting symbols for locale da_DK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_da_DK = goog.i18n.NumberFormatSymbols_da;


/**
 * Number formatting symbols for locale de.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_de = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale de_AT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_de_AT = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale de_BE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_de_BE = goog.i18n.NumberFormatSymbols_de;


/**
 * Number formatting symbols for locale de_CH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_de_CH = {
  DECIMAL_SEP: '.',
  GROUP_SEP: '\'',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00;\u00A4-#,##0.00',
  DEF_CURRENCY_CODE: 'CHF'
};


/**
 * Number formatting symbols for locale de_DE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_de_DE = goog.i18n.NumberFormatSymbols_de;


/**
 * Number formatting symbols for locale de_LU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_de_LU = goog.i18n.NumberFormatSymbols_de;


/**
 * Number formatting symbols for locale el.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_el = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'e',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '[#E0]',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale el_GR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_el_GR = goog.i18n.NumberFormatSymbols_el;


/**
 * Number formatting symbols for locale en.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale en_AS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_AS = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_AU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_AU = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'AUD'
};


/**
 * Number formatting symbols for locale en_Dsrt_US.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_Dsrt_US = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_FM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_FM = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_GB.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_GB = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00',
  DEF_CURRENCY_CODE: 'GBP'
};


/**
 * Number formatting symbols for locale en_GU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_GU = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_IE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_IE = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale en_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_IN = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##,##0%',
  CURRENCY_PATTERN: '\u00A4\u00A0#,##,##0.00',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale en_MH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_MH = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_MP.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_MP = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_PR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_PR = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_PW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_PW = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_SG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_SG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'SGD'
};


/**
 * Number formatting symbols for locale en_TC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_TC = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_UM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_UM = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_US.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_US = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_VG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_VG = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_VI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_VI = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_ZA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_ZA = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'ZAR'
};


/**
 * Number formatting symbols for locale es.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale es_419.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_419 = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00',
  DEF_CURRENCY_CODE: 'MXN'
};


/**
 * Number formatting symbols for locale es_EA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_EA = goog.i18n.NumberFormatSymbols_es;


/**
 * Number formatting symbols for locale es_ES.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_ES = goog.i18n.NumberFormatSymbols_es;


/**
 * Number formatting symbols for locale es_IC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_IC = goog.i18n.NumberFormatSymbols_es;


/**
 * Number formatting symbols for locale et.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_et = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#0.00\u00A4;(#0.00\u00A4)',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale et_EE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_et_EE = goog.i18n.NumberFormatSymbols_et;


/**
 * Number formatting symbols for locale eu.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_eu = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '%\u00A0#,##0',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4;(#,##0.00\u00A0\u00A4)',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale eu_ES.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_eu_ES = goog.i18n.NumberFormatSymbols_eu;


/**
 * Number formatting symbols for locale fa.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fa = {
  DECIMAL_SEP: '\u066B',
  GROUP_SEP: '\u066C',
  PERCENT: '\u066A',
  ZERO_DIGIT: '\u06F0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '\u2212',
  EXP_SYMBOL: '\u00D7\u06F1\u06F0^',
  PERMILL: '\u0609',
  INFINITY: '\u221E',
  NAN: '\u0646\u0627\u0639\u062F\u062F',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u200E\u00A4#,##0.00;\u200E(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'IRR'
};


/**
 * Number formatting symbols for locale fa_IR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fa_IR = goog.i18n.NumberFormatSymbols_fa;


/**
 * Number formatting symbols for locale fi.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fi = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'ep\u00E4luku',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale fi_FI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fi_FI = goog.i18n.NumberFormatSymbols_fi;


/**
 * Number formatting symbols for locale fil.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fil = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'PHP'
};


/**
 * Number formatting symbols for locale fil_PH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fil_PH = goog.i18n.NumberFormatSymbols_fil;


/**
 * Number formatting symbols for locale fr.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4;(#,##0.00\u00A0\u00A4)',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale fr_BL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_BL = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_CA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_CA = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4;(#,##0.00\u00A0\u00A4)',
  DEF_CURRENCY_CODE: 'CAD'
};


/**
 * Number formatting symbols for locale fr_FR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_FR = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_GF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_GF = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_GP.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_GP = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_MC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_MC = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_MF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_MF = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_MQ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_MQ = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_RE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_RE = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_YT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_YT = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale gl.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gl = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale gl_ES.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gl_ES = goog.i18n.NumberFormatSymbols_gl;


/**
 * Number formatting symbols for locale gsw.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gsw = {
  DECIMAL_SEP: '.',
  GROUP_SEP: '\u2019',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '\u2212',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'CHF'
};


/**
 * Number formatting symbols for locale gsw_CH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gsw_CH = goog.i18n.NumberFormatSymbols_gsw;


/**
 * Number formatting symbols for locale gu.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gu = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale gu_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gu_IN = goog.i18n.NumberFormatSymbols_gu;


/**
 * Number formatting symbols for locale he.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_he = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'ILS'
};


/**
 * Number formatting symbols for locale he_IL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_he_IL = goog.i18n.NumberFormatSymbols_he;


/**
 * Number formatting symbols for locale hi.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hi = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##,##0%',
  CURRENCY_PATTERN: '\u00A4\u00A0#,##,##0.00',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale hi_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hi_IN = goog.i18n.NumberFormatSymbols_hi;


/**
 * Number formatting symbols for locale hr.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hr = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'HRK'
};


/**
 * Number formatting symbols for locale hr_HR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hr_HR = goog.i18n.NumberFormatSymbols_hr;


/**
 * Number formatting symbols for locale hu.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hu = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'HUF'
};


/**
 * Number formatting symbols for locale hu_HU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hu_HU = goog.i18n.NumberFormatSymbols_hu;


/**
 * Number formatting symbols for locale id.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_id = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00',
  DEF_CURRENCY_CODE: 'IDR'
};


/**
 * Number formatting symbols for locale id_ID.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_id_ID = goog.i18n.NumberFormatSymbols_id;


/**
 * Number formatting symbols for locale in.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_in = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00',
  DEF_CURRENCY_CODE: 'IDR'
};


/**
 * Number formatting symbols for locale is.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_is = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'ISK'
};


/**
 * Number formatting symbols for locale is_IS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_is_IS = goog.i18n.NumberFormatSymbols_is;


/**
 * Number formatting symbols for locale it.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_it = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale it_IT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_it_IT = goog.i18n.NumberFormatSymbols_it;


/**
 * Number formatting symbols for locale it_SM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_it_SM = goog.i18n.NumberFormatSymbols_it;


/**
 * Number formatting symbols for locale iw.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_iw = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'ILS'
};


/**
 * Number formatting symbols for locale ja.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ja = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00',
  DEF_CURRENCY_CODE: 'JPY'
};


/**
 * Number formatting symbols for locale ja_JP.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ja_JP = goog.i18n.NumberFormatSymbols_ja;


/**
 * Number formatting symbols for locale kn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kn = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: '\u0C88',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale kn_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kn_IN = goog.i18n.NumberFormatSymbols_kn;


/**
 * Number formatting symbols for locale ko.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ko = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'KRW'
};


/**
 * Number formatting symbols for locale ko_KR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ko_KR = goog.i18n.NumberFormatSymbols_ko;


/**
 * Number formatting symbols for locale ln.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ln = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'CDF'
};


/**
 * Number formatting symbols for locale ln_CD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ln_CD = goog.i18n.NumberFormatSymbols_ln;


/**
 * Number formatting symbols for locale lt.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lt = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '\u2013',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  // Re b/8016169, there need to be a space before percent sign in lt.
  // Fix this temporarily before this change get into CLDR.
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'LTL'
};


/**
 * Number formatting symbols for locale lt_LT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lt_LT = goog.i18n.NumberFormatSymbols_lt;


/**
 * Number formatting symbols for locale lv.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lv = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'nav\u00A0skaitlis',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'LVL'
};


/**
 * Number formatting symbols for locale lv_LV.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lv_LV = goog.i18n.NumberFormatSymbols_lv;


/**
 * Number formatting symbols for locale ml.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ml = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##,##0%',
  CURRENCY_PATTERN: '#,##,##0.00\u00A4',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale ml_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ml_IN = goog.i18n.NumberFormatSymbols_ml;


/**
 * Number formatting symbols for locale mr.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mr = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale mr_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mr_IN = goog.i18n.NumberFormatSymbols_mr;


/**
 * Number formatting symbols for locale ms.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ms = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'MYR'
};


/**
 * Number formatting symbols for locale ms_MY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ms_MY = goog.i18n.NumberFormatSymbols_ms;


/**
 * Number formatting symbols for locale mt.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mt = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale mt_MT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mt_MT = goog.i18n.NumberFormatSymbols_mt;


/**
 * Number formatting symbols for locale nl.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nl = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00;\u00A4\u00A0#,##0.00-',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale nl_CW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nl_CW = goog.i18n.NumberFormatSymbols_nl;


/**
 * Number formatting symbols for locale nl_NL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nl_NL = goog.i18n.NumberFormatSymbols_nl;


/**
 * Number formatting symbols for locale nl_SX.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nl_SX = goog.i18n.NumberFormatSymbols_nl;


/**
 * Number formatting symbols for locale no.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_no = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00',
  DEF_CURRENCY_CODE: 'NOK'
};


/**
 * Number formatting symbols for locale or.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_or = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##,##0%',
  CURRENCY_PATTERN: '\u00A4\u00A0#,##,##0.00',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale or_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_or_IN = goog.i18n.NumberFormatSymbols_or;


/**
 * Number formatting symbols for locale pl.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pl = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4;(#,##0.00\u00A0\u00A4)',
  DEF_CURRENCY_CODE: 'PLN'
};


/**
 * Number formatting symbols for locale pl_PL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pl_PL = goog.i18n.NumberFormatSymbols_pl;


/**
 * Number formatting symbols for locale pt.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pt = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'BRL'
};


/**
 * Number formatting symbols for locale pt_BR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pt_BR = goog.i18n.NumberFormatSymbols_pt;


/**
 * Number formatting symbols for locale pt_PT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pt_PT = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale ro.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ro = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'RON'
};


/**
 * Number formatting symbols for locale ro_RO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ro_RO = goog.i18n.NumberFormatSymbols_ro;


/**
 * Number formatting symbols for locale ru.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ru = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: '\u043D\u0435\u00A0\u0447\u0438\u0441\u043B\u043E',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'RUB'
};


/**
 * Number formatting symbols for locale ru_RU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ru_RU = goog.i18n.NumberFormatSymbols_ru;


/**
 * Number formatting symbols for locale sk.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sk = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale sk_SK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sk_SK = goog.i18n.NumberFormatSymbols_sk;


/**
 * Number formatting symbols for locale sl.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sl = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'e',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale sl_SI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sl_SI = goog.i18n.NumberFormatSymbols_sl;


/**
 * Number formatting symbols for locale sq.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sq = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00',
  DEF_CURRENCY_CODE: 'ALL'
};


/**
 * Number formatting symbols for locale sq_AL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sq_AL = goog.i18n.NumberFormatSymbols_sq;


/**
 * Number formatting symbols for locale sr.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sr = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'RSD'
};


/**
 * Number formatting symbols for locale sr_Cyrl_RS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sr_Cyrl_RS = goog.i18n.NumberFormatSymbols_sr;


/**
 * Number formatting symbols for locale sr_Latn_RS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sr_Latn_RS = goog.i18n.NumberFormatSymbols_sr;


/**
 * Number formatting symbols for locale sv.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sv = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '\u2212',
  EXP_SYMBOL: '\u00D710^',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: '\u00A4\u00A4\u00A4',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0\u00A0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'SEK'
};


/**
 * Number formatting symbols for locale sv_SE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sv_SE = goog.i18n.NumberFormatSymbols_sv;


/**
 * Number formatting symbols for locale sw.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sw = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale sw_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sw_TZ = goog.i18n.NumberFormatSymbols_sw;


/**
 * Number formatting symbols for locale ta.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ta = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##,##0%',
  CURRENCY_PATTERN: '\u00A4\u00A0#,##,##0.00',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale ta_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ta_IN = goog.i18n.NumberFormatSymbols_ta;


/**
 * Number formatting symbols for locale te.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_te = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale te_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_te_IN = goog.i18n.NumberFormatSymbols_te;


/**
 * Number formatting symbols for locale th.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_th = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'THB'
};


/**
 * Number formatting symbols for locale th_TH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_th_TH = goog.i18n.NumberFormatSymbols_th;


/**
 * Number formatting symbols for locale tl.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_tl = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'PHP'
};


/**
 * Number formatting symbols for locale tr.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_tr = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '%#,##0',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4;(#,##0.00\u00A0\u00A4)',
  DEF_CURRENCY_CODE: 'TRY'
};


/**
 * Number formatting symbols for locale tr_TR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_tr_TR = goog.i18n.NumberFormatSymbols_tr;


/**
 * Number formatting symbols for locale uk.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_uk = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '\u00A0',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: '\u0415',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: '\u041D\u0435\u00A0\u0447\u0438\u0441\u043B\u043E',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'UAH'
};


/**
 * Number formatting symbols for locale uk_UA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_uk_UA = goog.i18n.NumberFormatSymbols_uk;


/**
 * Number formatting symbols for locale ur.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ur = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00',
  DEF_CURRENCY_CODE: 'PKR'
};


/**
 * Number formatting symbols for locale ur_PK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ur_PK = goog.i18n.NumberFormatSymbols_ur;


/**
 * Number formatting symbols for locale vi.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_vi = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00\u00A0\u00A4',
  DEF_CURRENCY_CODE: 'VND'
};


/**
 * Number formatting symbols for locale vi_VN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_vi_VN = goog.i18n.NumberFormatSymbols_vi;


/**
 * Number formatting symbols for locale zh.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'CNY'
};


/**
 * Number formatting symbols for locale zh_CN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_CN = goog.i18n.NumberFormatSymbols_zh;


/**
 * Number formatting symbols for locale zh_HK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_HK = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: '\u975E\u6578\u503C',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'HKD'
};


/**
 * Number formatting symbols for locale zh_Hans_CN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_Hans_CN = goog.i18n.NumberFormatSymbols_zh;


/**
 * Number formatting symbols for locale zh_TW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_TW = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: '\u975E\u6578\u503C',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00',
  DEF_CURRENCY_CODE: 'TWD'
};


/**
 * Number formatting symbols for locale zu.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zu = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '\u2030',
  INFINITY: '\u221E',
  NAN: 'I-NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '\u00A4#,##0.00;(\u00A4#,##0.00)',
  DEF_CURRENCY_CODE: 'ZAR'
};


/**
 * Number formatting symbols for locale zu_ZA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zu_ZA = goog.i18n.NumberFormatSymbols_zu;


/**
 * Selected number formatting symbols by locale.
 */
goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;

if (goog.LOCALE == 'af') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_af;
}

if (goog.LOCALE == 'af_ZA' || goog.LOCALE == 'af-ZA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_af;
}

if (goog.LOCALE == 'am') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_am;
}

if (goog.LOCALE == 'am_ET' || goog.LOCALE == 'am-ET') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_am;
}

if (goog.LOCALE == 'ar') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar;
}

if (goog.LOCALE == 'ar_001' || goog.LOCALE == 'ar-001') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar;
}

if (goog.LOCALE == 'ar_EG' || goog.LOCALE == 'ar-EG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar;
}

if (goog.LOCALE == 'bg') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bg;
}

if (goog.LOCALE == 'bg_BG' || goog.LOCALE == 'bg-BG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bg;
}

if (goog.LOCALE == 'bn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bn;
}

if (goog.LOCALE == 'bn_BD' || goog.LOCALE == 'bn-BD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bn;
}

if (goog.LOCALE == 'ca') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ca;
}

if (goog.LOCALE == 'ca_AD' || goog.LOCALE == 'ca-AD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ca;
}

if (goog.LOCALE == 'ca_ES' || goog.LOCALE == 'ca-ES') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ca;
}

if (goog.LOCALE == 'cs') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_cs;
}

if (goog.LOCALE == 'cs_CZ' || goog.LOCALE == 'cs-CZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_cs;
}

if (goog.LOCALE == 'da') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_da;
}

if (goog.LOCALE == 'da_DK' || goog.LOCALE == 'da-DK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_da;
}

if (goog.LOCALE == 'de') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_de;
}

if (goog.LOCALE == 'de_AT' || goog.LOCALE == 'de-AT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_de_AT;
}

if (goog.LOCALE == 'de_BE' || goog.LOCALE == 'de-BE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_de;
}

if (goog.LOCALE == 'de_CH' || goog.LOCALE == 'de-CH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_de_CH;
}

if (goog.LOCALE == 'de_DE' || goog.LOCALE == 'de-DE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_de;
}

if (goog.LOCALE == 'de_LU' || goog.LOCALE == 'de-LU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_de;
}

if (goog.LOCALE == 'el') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_el;
}

if (goog.LOCALE == 'el_GR' || goog.LOCALE == 'el-GR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_el;
}

if (goog.LOCALE == 'en') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_AS' || goog.LOCALE == 'en-AS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_AU' || goog.LOCALE == 'en-AU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_AU;
}

if (goog.LOCALE == 'en_Dsrt_US' || goog.LOCALE == 'en-Dsrt-US') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_FM' || goog.LOCALE == 'en-FM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_GB' || goog.LOCALE == 'en-GB') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_GB;
}

if (goog.LOCALE == 'en_GU' || goog.LOCALE == 'en-GU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_IE' || goog.LOCALE == 'en-IE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_IE;
}

if (goog.LOCALE == 'en_IN' || goog.LOCALE == 'en-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_IN;
}

if (goog.LOCALE == 'en_MH' || goog.LOCALE == 'en-MH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_MP' || goog.LOCALE == 'en-MP') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_PR' || goog.LOCALE == 'en-PR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_PW' || goog.LOCALE == 'en-PW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_SG' || goog.LOCALE == 'en-SG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_SG;
}

if (goog.LOCALE == 'en_TC' || goog.LOCALE == 'en-TC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_UM' || goog.LOCALE == 'en-UM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_US' || goog.LOCALE == 'en-US') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_VG' || goog.LOCALE == 'en-VG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_VI' || goog.LOCALE == 'en-VI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en;
}

if (goog.LOCALE == 'en_ZA' || goog.LOCALE == 'en-ZA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_ZA;
}

if (goog.LOCALE == 'es') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es;
}

if (goog.LOCALE == 'es_419' || goog.LOCALE == 'es-419') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_419;
}

if (goog.LOCALE == 'es_EA' || goog.LOCALE == 'es-EA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es;
}

if (goog.LOCALE == 'es_ES' || goog.LOCALE == 'es-ES') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es;
}

if (goog.LOCALE == 'es_IC' || goog.LOCALE == 'es-IC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es;
}

if (goog.LOCALE == 'et') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_et;
}

if (goog.LOCALE == 'et_EE' || goog.LOCALE == 'et-EE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_et;
}

if (goog.LOCALE == 'eu') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_eu;
}

if (goog.LOCALE == 'eu_ES' || goog.LOCALE == 'eu-ES') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_eu;
}

if (goog.LOCALE == 'fa') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fa;
}

if (goog.LOCALE == 'fa_IR' || goog.LOCALE == 'fa-IR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fa;
}

if (goog.LOCALE == 'fi') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fi;
}

if (goog.LOCALE == 'fi_FI' || goog.LOCALE == 'fi-FI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fi;
}

if (goog.LOCALE == 'fil') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fil;
}

if (goog.LOCALE == 'fil_PH' || goog.LOCALE == 'fil-PH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fil;
}

if (goog.LOCALE == 'fr') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_BL' || goog.LOCALE == 'fr-BL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_CA' || goog.LOCALE == 'fr-CA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_CA;
}

if (goog.LOCALE == 'fr_FR' || goog.LOCALE == 'fr-FR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_GF' || goog.LOCALE == 'fr-GF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_GP' || goog.LOCALE == 'fr-GP') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_MC' || goog.LOCALE == 'fr-MC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_MF' || goog.LOCALE == 'fr-MF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_MQ' || goog.LOCALE == 'fr-MQ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_RE' || goog.LOCALE == 'fr-RE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_YT' || goog.LOCALE == 'fr-YT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr;
}

if (goog.LOCALE == 'gl') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gl;
}

if (goog.LOCALE == 'gl_ES' || goog.LOCALE == 'gl-ES') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gl;
}

if (goog.LOCALE == 'gsw') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gsw;
}

if (goog.LOCALE == 'gsw_CH' || goog.LOCALE == 'gsw-CH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gsw;
}

if (goog.LOCALE == 'gu') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gu;
}

if (goog.LOCALE == 'gu_IN' || goog.LOCALE == 'gu-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gu;
}

if (goog.LOCALE == 'he') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_he;
}

if (goog.LOCALE == 'he_IL' || goog.LOCALE == 'he-IL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_he;
}

if (goog.LOCALE == 'hi') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hi;
}

if (goog.LOCALE == 'hi_IN' || goog.LOCALE == 'hi-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hi;
}

if (goog.LOCALE == 'hr') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hr;
}

if (goog.LOCALE == 'hr_HR' || goog.LOCALE == 'hr-HR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hr;
}

if (goog.LOCALE == 'hu') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hu;
}

if (goog.LOCALE == 'hu_HU' || goog.LOCALE == 'hu-HU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hu;
}

if (goog.LOCALE == 'id') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_id;
}

if (goog.LOCALE == 'id_ID' || goog.LOCALE == 'id-ID') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_id;
}

if (goog.LOCALE == 'in') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_in;
}

if (goog.LOCALE == 'is') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_is;
}

if (goog.LOCALE == 'is_IS' || goog.LOCALE == 'is-IS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_is;
}

if (goog.LOCALE == 'it') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_it;
}

if (goog.LOCALE == 'it_IT' || goog.LOCALE == 'it-IT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_it;
}

if (goog.LOCALE == 'it_SM' || goog.LOCALE == 'it-SM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_it;
}

if (goog.LOCALE == 'iw') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_iw;
}

if (goog.LOCALE == 'ja') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ja;
}

if (goog.LOCALE == 'ja_JP' || goog.LOCALE == 'ja-JP') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ja;
}

if (goog.LOCALE == 'kn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kn;
}

if (goog.LOCALE == 'kn_IN' || goog.LOCALE == 'kn-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kn;
}

if (goog.LOCALE == 'ko') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ko;
}

if (goog.LOCALE == 'ko_KR' || goog.LOCALE == 'ko-KR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ko;
}

if (goog.LOCALE == 'ln') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ln;
}

if (goog.LOCALE == 'ln_CD' || goog.LOCALE == 'ln-CD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ln;
}

if (goog.LOCALE == 'lt') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lt;
}

if (goog.LOCALE == 'lt_LT' || goog.LOCALE == 'lt-LT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lt;
}

if (goog.LOCALE == 'lv') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lv;
}

if (goog.LOCALE == 'lv_LV' || goog.LOCALE == 'lv-LV') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lv;
}

if (goog.LOCALE == 'ml') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ml;
}

if (goog.LOCALE == 'ml_IN' || goog.LOCALE == 'ml-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ml;
}

if (goog.LOCALE == 'mr') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mr;
}

if (goog.LOCALE == 'mr_IN' || goog.LOCALE == 'mr-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mr;
}

if (goog.LOCALE == 'ms') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ms;
}

if (goog.LOCALE == 'ms_MY' || goog.LOCALE == 'ms-MY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ms;
}

if (goog.LOCALE == 'mt') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mt;
}

if (goog.LOCALE == 'mt_MT' || goog.LOCALE == 'mt-MT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mt;
}

if (goog.LOCALE == 'nl') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nl;
}

if (goog.LOCALE == 'nl_CW' || goog.LOCALE == 'nl-CW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nl;
}

if (goog.LOCALE == 'nl_NL' || goog.LOCALE == 'nl-NL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nl;
}

if (goog.LOCALE == 'nl_SX' || goog.LOCALE == 'nl-SX') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nl;
}

if (goog.LOCALE == 'no') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_no;
}

if (goog.LOCALE == 'or') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_or;
}

if (goog.LOCALE == 'or_IN' || goog.LOCALE == 'or-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_or;
}

if (goog.LOCALE == 'pl') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pl;
}

if (goog.LOCALE == 'pl_PL' || goog.LOCALE == 'pl-PL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pl;
}

if (goog.LOCALE == 'pt') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pt;
}

if (goog.LOCALE == 'pt_BR' || goog.LOCALE == 'pt-BR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pt;
}

if (goog.LOCALE == 'pt_PT' || goog.LOCALE == 'pt-PT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pt_PT;
}

if (goog.LOCALE == 'ro') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ro;
}

if (goog.LOCALE == 'ro_RO' || goog.LOCALE == 'ro-RO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ro;
}

if (goog.LOCALE == 'ru') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ru;
}

if (goog.LOCALE == 'ru_RU' || goog.LOCALE == 'ru-RU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ru;
}

if (goog.LOCALE == 'sk') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sk;
}

if (goog.LOCALE == 'sk_SK' || goog.LOCALE == 'sk-SK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sk;
}

if (goog.LOCALE == 'sl') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sl;
}

if (goog.LOCALE == 'sl_SI' || goog.LOCALE == 'sl-SI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sl;
}

if (goog.LOCALE == 'sq') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sq;
}

if (goog.LOCALE == 'sq_AL' || goog.LOCALE == 'sq-AL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sq;
}

if (goog.LOCALE == 'sr') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sr;
}

if (goog.LOCALE == 'sr_Cyrl_RS' || goog.LOCALE == 'sr-Cyrl-RS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sr;
}

if (goog.LOCALE == 'sr_Latn_RS' || goog.LOCALE == 'sr-Latn-RS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sr;
}

if (goog.LOCALE == 'sv') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sv;
}

if (goog.LOCALE == 'sv_SE' || goog.LOCALE == 'sv-SE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sv;
}

if (goog.LOCALE == 'sw') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sw;
}

if (goog.LOCALE == 'sw_TZ' || goog.LOCALE == 'sw-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sw;
}

if (goog.LOCALE == 'ta') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ta;
}

if (goog.LOCALE == 'ta_IN' || goog.LOCALE == 'ta-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ta;
}

if (goog.LOCALE == 'te') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_te;
}

if (goog.LOCALE == 'te_IN' || goog.LOCALE == 'te-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_te;
}

if (goog.LOCALE == 'th') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_th;
}

if (goog.LOCALE == 'th_TH' || goog.LOCALE == 'th-TH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_th;
}

if (goog.LOCALE == 'tl') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_tl;
}

if (goog.LOCALE == 'tr') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_tr;
}

if (goog.LOCALE == 'tr_TR' || goog.LOCALE == 'tr-TR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_tr;
}

if (goog.LOCALE == 'uk') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_uk;
}

if (goog.LOCALE == 'uk_UA' || goog.LOCALE == 'uk-UA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_uk;
}

if (goog.LOCALE == 'ur') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ur;
}

if (goog.LOCALE == 'ur_PK' || goog.LOCALE == 'ur-PK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ur;
}

if (goog.LOCALE == 'vi') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_vi;
}

if (goog.LOCALE == 'vi_VN' || goog.LOCALE == 'vi-VN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_vi;
}

if (goog.LOCALE == 'zh') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh;
}

if (goog.LOCALE == 'zh_CN' || goog.LOCALE == 'zh-CN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh;
}

if (goog.LOCALE == 'zh_HK' || goog.LOCALE == 'zh-HK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh_HK;
}

if (goog.LOCALE == 'zh_Hans_CN' || goog.LOCALE == 'zh-Hans-CN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh;
}

if (goog.LOCALE == 'zh_TW' || goog.LOCALE == 'zh-TW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh_TW;
}

if (goog.LOCALE == 'zu') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zu;
}

if (goog.LOCALE == 'zu_ZA' || goog.LOCALE == 'zu-ZA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zu;
}

