/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import sun.security.ssl.JsseJce;

final class CloneableDigest
extends MessageDigest
implements Cloneable {
    private final MessageDigest[] digests;

    private CloneableDigest(MessageDigest messageDigest, int n, String string) throws NoSuchAlgorithmException {
        super(string);
        this.digests = new MessageDigest[n];
        this.digests[0] = messageDigest;
        for (int i = 1; i < n; ++i) {
            this.digests[i] = JsseJce.getMessageDigest(string);
        }
    }

    static MessageDigest getDigest(String string, int n) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = JsseJce.getMessageDigest(string);
        try {
            messageDigest.clone();
            return messageDigest;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return new CloneableDigest(messageDigest, n, string);
        }
    }

    private void checkState() {
    }

    @Override
    protected int engineGetDigestLength() {
        this.checkState();
        return this.digests[0].getDigestLength();
    }

    @Override
    protected void engineUpdate(byte by) {
        this.checkState();
        for (int i = 0; i < this.digests.length && this.digests[i] != null; ++i) {
            this.digests[i].update(by);
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.checkState();
        for (int i = 0; i < this.digests.length && this.digests[i] != null; ++i) {
            this.digests[i].update(byArray, n, n2);
        }
    }

    @Override
    protected byte[] engineDigest() {
        this.checkState();
        byte[] byArray = this.digests[0].digest();
        this.digestReset();
        return byArray;
    }

    @Override
    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        this.checkState();
        int n3 = this.digests[0].digest(byArray, n, n2);
        this.digestReset();
        return n3;
    }

    private void digestReset() {
        for (int i = 1; i < this.digests.length && this.digests[i] != null; ++i) {
            this.digests[i].reset();
        }
    }

    @Override
    protected void engineReset() {
        this.checkState();
        for (int i = 0; i < this.digests.length && this.digests[i] != null; ++i) {
            this.digests[i].reset();
        }
    }

    @Override
    public Object clone() {
        this.checkState();
        for (int i = this.digests.length - 1; i >= 0; --i) {
            if (this.digests[i] == null) continue;
            MessageDigest messageDigest = this.digests[i];
            this.digests[i] = null;
            return messageDigest;
        }
        throw new InternalError();
    }
}

