/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

abstract class AbstractPoller
implements Runnable {
    private final LinkedList<Request> requestList = new LinkedList();
    private boolean shutdown = false;

    protected AbstractPoller() {
    }

    public void start() {
        final AbstractPoller abstractPoller = this;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Thread thread = new Thread(abstractPoller);
                thread.setDaemon(true);
                thread.start();
                return null;
            }
        });
    }

    abstract void wakeup() throws IOException;

    abstract Object implRegister(Path var1, Set<? extends WatchEvent.Kind<?>> var2, WatchEvent.Modifier ... var3);

    abstract void implCancelKey(WatchKey var1);

    abstract void implCloseAll();

    final WatchKey register(Path path, WatchEvent.Kind<?>[] kindArray, WatchEvent.Modifier ... modifierArray) throws IOException {
        if (path == null) {
            throw new NullPointerException();
        }
        if (kindArray.length == 0) {
            throw new IllegalArgumentException("No events to register");
        }
        HashSet hashSet = new HashSet(kindArray.length);
        for (WatchEvent.Kind<?> kind : kindArray) {
            if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY || kind == StandardWatchEventKinds.ENTRY_DELETE) {
                hashSet.add(kind);
                continue;
            }
            if (kind == StandardWatchEventKinds.OVERFLOW) {
                if (kindArray.length != 1) continue;
                throw new IllegalArgumentException("No events to register");
            }
            if (kind == null) {
                throw new NullPointerException("An element in event set is 'null'");
            }
            throw new UnsupportedOperationException(kind.name());
        }
        return (WatchKey)this.invoke(RequestType.REGISTER, path, hashSet, modifierArray);
    }

    final void cancel(WatchKey watchKey) {
        try {
            this.invoke(RequestType.CANCEL, watchKey);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException.getMessage());
        }
    }

    final void close() throws IOException {
        this.invoke(RequestType.CLOSE, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(RequestType requestType, Object ... objectArray) throws IOException {
        Request request = new Request(requestType, objectArray);
        Object object = this.requestList;
        synchronized (object) {
            if (this.shutdown) {
                throw new ClosedWatchServiceException();
            }
            this.requestList.add(request);
        }
        this.wakeup();
        object = request.awaitResult();
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processRequests() {
        LinkedList<Request> linkedList = this.requestList;
        synchronized (linkedList) {
            Request request;
            block8: while ((request = this.requestList.poll()) != null) {
                if (this.shutdown) {
                    request.release(new ClosedWatchServiceException());
                }
                switch (request.type()) {
                    case REGISTER: {
                        Object[] objectArray = request.parameters();
                        Object object = (Path)objectArray[0];
                        Set set = (Set)objectArray[1];
                        WatchEvent.Modifier[] modifierArray = (WatchEvent.Modifier[])objectArray[2];
                        request.release(this.implRegister((Path)object, set, modifierArray));
                        continue block8;
                    }
                    case CANCEL: {
                        Object[] objectArray = request.parameters();
                        Object object = (WatchKey)objectArray[0];
                        this.implCancelKey((WatchKey)object);
                        request.release(null);
                        continue block8;
                    }
                    case CLOSE: {
                        this.implCloseAll();
                        request.release(null);
                        this.shutdown = true;
                        continue block8;
                    }
                }
                request.release(new IOException("request not recognized"));
            }
        }
        return this.shutdown;
    }

    private static class Request {
        private final RequestType type;
        private final Object[] params;
        private boolean completed = false;
        private Object result = null;

        Request(RequestType requestType, Object ... objectArray) {
            this.type = requestType;
            this.params = objectArray;
        }

        RequestType type() {
            return this.type;
        }

        Object[] parameters() {
            return this.params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release(Object object) {
            Request request = this;
            synchronized (request) {
                this.completed = true;
                this.result = object;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object awaitResult() {
            Request request = this;
            synchronized (request) {
                while (!this.completed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.result;
            }
        }
    }

    private static enum RequestType {
        REGISTER,
        CANCEL,
        CLOSE;

    }
}

