/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.beans.ConstructorProperties;
import java.io.Serializable;

public class TreePath
implements Serializable {
    private TreePath parentPath;
    private Object lastPathComponent;

    @ConstructorProperties(value={"path"})
    public TreePath(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("path in TreePath must be non null and not empty.");
        }
        this.lastPathComponent = objectArray[objectArray.length - 1];
        if (this.lastPathComponent == null) {
            throw new IllegalArgumentException("Last path component must be non-null");
        }
        if (objectArray.length > 1) {
            this.parentPath = new TreePath(objectArray, objectArray.length - 1);
        }
    }

    public TreePath(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.lastPathComponent = object;
        this.parentPath = null;
    }

    protected TreePath(TreePath treePath, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.parentPath = treePath;
        this.lastPathComponent = object;
    }

    protected TreePath(Object[] objectArray, int n) {
        this.lastPathComponent = objectArray[n - 1];
        if (this.lastPathComponent == null) {
            throw new IllegalArgumentException("Path elements must be non-null");
        }
        if (n > 1) {
            this.parentPath = new TreePath(objectArray, n - 1);
        }
    }

    protected TreePath() {
    }

    public Object[] getPath() {
        int n = this.getPathCount();
        Object[] objectArray = new Object[n--];
        for (TreePath treePath = this; treePath != null; treePath = treePath.getParentPath()) {
            objectArray[n--] = treePath.getLastPathComponent();
        }
        return objectArray;
    }

    public Object getLastPathComponent() {
        return this.lastPathComponent;
    }

    public int getPathCount() {
        int n = 0;
        for (TreePath treePath = this; treePath != null; treePath = treePath.getParentPath()) {
            ++n;
        }
        return n;
    }

    public Object getPathComponent(int n) {
        int n2 = this.getPathCount();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Index " + n + " is out of the specified range");
        }
        TreePath treePath = this;
        for (int i = n2 - 1; i != n; --i) {
            treePath = treePath.getParentPath();
        }
        return treePath.getLastPathComponent();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TreePath) {
            TreePath treePath = (TreePath)object;
            if (this.getPathCount() != treePath.getPathCount()) {
                return false;
            }
            for (TreePath treePath2 = this; treePath2 != null; treePath2 = treePath2.getParentPath()) {
                if (!treePath2.getLastPathComponent().equals(treePath.getLastPathComponent())) {
                    return false;
                }
                treePath = treePath.getParentPath();
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getLastPathComponent().hashCode();
    }

    public boolean isDescendant(TreePath treePath) {
        if (treePath == this) {
            return true;
        }
        if (treePath != null) {
            int n = this.getPathCount();
            int n2 = treePath.getPathCount();
            if (n2 < n) {
                return false;
            }
            while (n2-- > n) {
                treePath = treePath.getParentPath();
            }
            return this.equals(treePath);
        }
        return false;
    }

    public TreePath pathByAddingChild(Object object) {
        if (object == null) {
            throw new NullPointerException("Null child not allowed");
        }
        return new TreePath(this, object);
    }

    public TreePath getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = this.getPathCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getPathComponent(i));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

