/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyRep;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

final class PBKDF2KeyImpl
implements PBEKey {
    static final long serialVersionUID = -2234868909660948157L;
    private char[] passwd;
    private byte[] salt;
    private int iterCount;
    private byte[] key;
    private Mac prf;

    private static byte[] getPasswordBytes(char[] cArray) {
        Charset charset = Charset.forName("UTF-8");
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        int n = byteBuffer.limit();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray, 0, n);
        return byArray;
    }

    PBKDF2KeyImpl(PBEKeySpec pBEKeySpec, String string) throws InvalidKeySpecException {
        char[] cArray = pBEKeySpec.getPassword();
        this.passwd = cArray == null ? new char[0] : (char[])cArray.clone();
        byte[] byArray = PBKDF2KeyImpl.getPasswordBytes(this.passwd);
        this.salt = pBEKeySpec.getSalt();
        if (this.salt == null) {
            throw new InvalidKeySpecException("Salt not found");
        }
        this.iterCount = pBEKeySpec.getIterationCount();
        if (this.iterCount == 0) {
            throw new InvalidKeySpecException("Iteration count not found");
        }
        if (this.iterCount < 0) {
            throw new InvalidKeySpecException("Iteration count is negative");
        }
        int n = pBEKeySpec.getKeyLength();
        if (n == 0) {
            throw new InvalidKeySpecException("Key length not found");
        }
        if (n < 0) {
            throw new InvalidKeySpecException("Key length is negative");
        }
        try {
            this.prf = Mac.getInstance(string, SunJCE.getInstance());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(noSuchAlgorithmException);
            throw invalidKeySpecException;
        }
        this.key = PBKDF2KeyImpl.deriveKey(this.prf, byArray, this.salt, this.iterCount, n);
    }

    private static byte[] deriveKey(final Mac mac, final byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = n2 / 8;
        byte[] byArray3 = new byte[n3];
        try {
            int n4 = mac.getMacLength();
            int n5 = (n3 + n4 - 1) / n4;
            int n6 = n3 - (n5 - 1) * n4;
            byte[] byArray4 = new byte[n4];
            byte[] byArray5 = new byte[n4];
            SecretKey secretKey = new SecretKey(){
                private static final long serialVersionUID = 7874493593505141603L;

                @Override
                public String getAlgorithm() {
                    return mac.getAlgorithm();
                }

                @Override
                public String getFormat() {
                    return "RAW";
                }

                @Override
                public byte[] getEncoded() {
                    return byArray;
                }

                public int hashCode() {
                    return Arrays.hashCode(byArray) * 41 + mac.getAlgorithm().toLowerCase(Locale.ENGLISH).hashCode();
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    SecretKey secretKey = (SecretKey)object;
                    return mac.getAlgorithm().equalsIgnoreCase(secretKey.getAlgorithm()) && MessageDigest.isEqual(byArray, secretKey.getEncoded());
                }
            };
            mac.init(secretKey);
            byte[] byArray6 = new byte[4];
            for (int i = 1; i <= n5; ++i) {
                mac.update(byArray2);
                byArray6[3] = (byte)i;
                byArray6[2] = (byte)(i >> 8 & 0xFF);
                byArray6[1] = (byte)(i >> 16 & 0xFF);
                byArray6[0] = (byte)(i >> 24 & 0xFF);
                mac.update(byArray6);
                mac.doFinal(byArray4, 0);
                System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
                for (int j = 2; j <= n; ++j) {
                    mac.update(byArray4);
                    mac.doFinal(byArray4, 0);
                    for (int k = 0; k < byArray4.length; ++k) {
                        int n7 = k;
                        byArray5[n7] = (byte)(byArray5[n7] ^ byArray4[k]);
                    }
                }
                if (i == n5) {
                    System.arraycopy(byArray5, 0, byArray3, (i - 1) * n4, n6);
                    continue;
                }
                System.arraycopy(byArray5, 0, byArray3, (i - 1) * n4, n4);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Error deriving PBKDF2 keys");
        }
        return byArray3;
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        return "PBKDF2With" + this.prf.getAlgorithm();
    }

    @Override
    public int getIterationCount() {
        return this.iterCount;
    }

    @Override
    public char[] getPassword() {
        return (char[])this.passwd.clone();
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n = 0;
        for (int i = 1; i < this.key.length; ++i) {
            n += this.key[i] * i;
        }
        return n ^= this.getAlgorithm().toLowerCase(Locale.ENGLISH).hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        if (!secretKey.getAlgorithm().equalsIgnoreCase(this.getAlgorithm())) {
            return false;
        }
        if (!secretKey.getFormat().equalsIgnoreCase("RAW")) {
            return false;
        }
        byte[] byArray = secretKey.getEncoded();
        boolean bl = MessageDigest.isEqual(this.key, secretKey.getEncoded());
        Arrays.fill(byArray, (byte)0);
        return bl;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    protected void finalize() throws Throwable {
        try {
            if (this.passwd != null) {
                Arrays.fill(this.passwd, '0');
                this.passwd = null;
            }
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
        }
        finally {
            super.finalize();
        }
    }
}

