/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParameterList;
import java.awt.datatransfer.MimeTypeParseException;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import sun.awt.datatransfer.DataTransferer;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public class DataFlavor
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 8367026044764648243L;
    private static final Class<InputStream> ioInputStreamClass = InputStream.class;
    public static final DataFlavor stringFlavor = DataFlavor.createConstant(String.class, "Unicode String");
    public static final DataFlavor imageFlavor = DataFlavor.createConstant("image/x-java-image; class=java.awt.Image", "Image");
    @Deprecated
    public static final DataFlavor plainTextFlavor = DataFlavor.createConstant("text/plain; charset=unicode; class=java.io.InputStream", "Plain Text");
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    public static final DataFlavor javaFileListFlavor = DataFlavor.createConstant("application/x-java-file-list;class=java.util.List", null);
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-objectref";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    public static DataFlavor selectionHtmlFlavor = DataFlavor.initHtmlDataFlavor("selection");
    public static DataFlavor fragmentHtmlFlavor = DataFlavor.initHtmlDataFlavor("fragment");
    public static DataFlavor allHtmlFlavor = DataFlavor.initHtmlDataFlavor("all");
    private static Comparator<DataFlavor> textFlavorComparator;
    transient int atom;
    MimeType mimeType;
    private String humanPresentableName;
    private Class<?> representationClass;

    protected static final Class<?> tryToLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        ReflectUtil.checkPackageAccess(string);
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
            }
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            try {
                return Class.forName(string, true, classLoader2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classLoader2 = Thread.currentThread().getContextClassLoader();
                if (classLoader2 != null) {
                    try {
                        return Class.forName(string, true, classLoader2);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {}
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return Class.forName(string, true, classLoader);
    }

    private static DataFlavor createConstant(Class<?> clazz, String string) {
        try {
            return new DataFlavor(clazz, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static DataFlavor createConstant(String string, String string2) {
        try {
            return new DataFlavor(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static DataFlavor initHtmlDataFlavor(String string) {
        try {
            return new DataFlavor("text/html; class=java.lang.String;document=" + string + ";charset=Unicode");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataFlavor() {
    }

    private DataFlavor(String string, String string2, MimeTypeParameterList mimeTypeParameterList, Class<?> clazz, String string3) {
        if (string == null) {
            throw new NullPointerException("primaryType");
        }
        if (string2 == null) {
            throw new NullPointerException("subType");
        }
        if (clazz == null) {
            throw new NullPointerException("representationClass");
        }
        if (mimeTypeParameterList == null) {
            mimeTypeParameterList = new MimeTypeParameterList();
        }
        mimeTypeParameterList.set("class", clazz.getName());
        if (string3 == null && (string3 = mimeTypeParameterList.get("humanPresentableName")) == null) {
            string3 = string + "/" + string2;
        }
        try {
            this.mimeType = new MimeType(string, string2, mimeTypeParameterList);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("MimeType Parse Exception: " + mimeTypeParseException.getMessage());
        }
        this.representationClass = clazz;
        this.humanPresentableName = string3;
        this.mimeType.removeParameter("humanPresentableName");
    }

    public DataFlavor(Class<?> clazz, String string) {
        this("application", "x-java-serialized-object", null, clazz, string);
        if (clazz == null) {
            throw new NullPointerException("representationClass");
        }
    }

    public DataFlavor(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("mimeType");
        }
        try {
            this.initialize(string, string2, this.getClass().getClassLoader());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("failed to parse:" + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("can't find specified class: " + classNotFoundException.getMessage());
        }
    }

    public DataFlavor(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        if (string == null) {
            throw new NullPointerException("mimeType");
        }
        try {
            this.initialize(string, string2, classLoader);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("failed to parse:" + string);
        }
    }

    public DataFlavor(String string) throws ClassNotFoundException {
        if (string == null) {
            throw new NullPointerException("mimeType");
        }
        try {
            this.initialize(string, null, this.getClass().getClassLoader());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("failed to parse:" + string);
        }
    }

    private void initialize(String string, String string2, ClassLoader classLoader) throws MimeTypeParseException, ClassNotFoundException {
        if (string == null) {
            throw new NullPointerException("mimeType");
        }
        this.mimeType = new MimeType(string);
        String string3 = this.getParameter("class");
        if (string3 == null) {
            if (javaSerializedObjectMimeType.equals(this.mimeType.getBaseType())) {
                throw new IllegalArgumentException("no representation class specified for:" + string);
            }
            this.representationClass = InputStream.class;
        } else {
            this.representationClass = DataFlavor.tryToLoadClass(string3, classLoader);
        }
        this.mimeType.setParameter("class", this.representationClass.getName());
        if (string2 == null && (string2 = this.mimeType.getParameter("humanPresentableName")) == null) {
            string2 = this.mimeType.getPrimaryType() + "/" + this.mimeType.getSubType();
        }
        this.humanPresentableName = string2;
        this.mimeType.removeParameter("humanPresentableName");
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string + "[" + this.paramString() + "]";
        return string;
    }

    private String paramString() {
        String string = "";
        string = string + "mimetype=";
        string = this.mimeType == null ? string + "null" : string + this.mimeType.getBaseType();
        string = string + ";representationclass=";
        string = this.representationClass == null ? string + "null" : string + this.representationClass.getName();
        if (DataTransferer.isFlavorCharsetTextType(this) && (this.isRepresentationClassInputStream() || this.isRepresentationClassByteBuffer() || byte[].class.equals(this.representationClass))) {
            string = string + ";charset=" + DataTransferer.getTextCharset(this);
        }
        return string;
    }

    public static final DataFlavor getTextPlainUnicodeFlavor() {
        String string = null;
        DataTransferer dataTransferer = DataTransferer.getInstance();
        if (dataTransferer != null) {
            string = dataTransferer.getDefaultUnicodeEncoding();
        }
        return new DataFlavor("text/plain;charset=" + string + ";class=java.io.InputStream", "Plain Text");
    }

    public static final DataFlavor selectBestTextFlavor(DataFlavor[] dataFlavorArray) {
        DataFlavor dataFlavor;
        if (dataFlavorArray == null || dataFlavorArray.length == 0) {
            return null;
        }
        if (textFlavorComparator == null) {
            textFlavorComparator = new TextFlavorComparator();
        }
        if (!(dataFlavor = Collections.max(Arrays.asList(dataFlavorArray), textFlavorComparator)).isFlavorTextType()) {
            return null;
        }
        return dataFlavor;
    }

    public Reader getReaderForText(Transferable transferable) throws UnsupportedFlavorException, IOException {
        Object object;
        Object object2 = transferable.getTransferData(this);
        if (object2 == null) {
            throw new IllegalArgumentException("getTransferData() returned null");
        }
        if (object2 instanceof Reader) {
            return (Reader)object2;
        }
        if (object2 instanceof String) {
            return new StringReader((String)object2);
        }
        if (object2 instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)object2;
            int n = charBuffer.remaining();
            char[] cArray = new char[n];
            charBuffer.get(cArray, 0, n);
            return new CharArrayReader(cArray);
        }
        if (object2 instanceof char[]) {
            return new CharArrayReader((char[])object2);
        }
        InputStream inputStream = null;
        if (object2 instanceof InputStream) {
            inputStream = (InputStream)object2;
        } else if (object2 instanceof ByteBuffer) {
            object = (ByteBuffer)object2;
            int n = ((Buffer)object).remaining();
            byte[] byArray = new byte[n];
            ((ByteBuffer)object).get(byArray, 0, n);
            inputStream = new ByteArrayInputStream(byArray);
        } else if (object2 instanceof byte[]) {
            inputStream = new ByteArrayInputStream((byte[])object2);
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("transfer data is not Reader, String, CharBuffer, char array, InputStream, ByteBuffer, or byte array");
        }
        object = this.getParameter("charset");
        return object == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, (String)object);
    }

    public String getMimeType() {
        return this.mimeType != null ? this.mimeType.toString() : null;
    }

    public Class<?> getRepresentationClass() {
        return this.representationClass;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public String getPrimaryType() {
        return this.mimeType != null ? this.mimeType.getPrimaryType() : null;
    }

    public String getSubType() {
        return this.mimeType != null ? this.mimeType.getSubType() : null;
    }

    public String getParameter(String string) {
        if (string.equals("humanPresentableName")) {
            return this.humanPresentableName;
        }
        return this.mimeType != null ? this.mimeType.getParameter(string) : null;
    }

    public void setHumanPresentableName(String string) {
        this.humanPresentableName = string;
    }

    public boolean equals(Object object) {
        return object instanceof DataFlavor && this.equals((DataFlavor)object);
    }

    public boolean equals(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            return false;
        }
        if (this == dataFlavor) {
            return true;
        }
        if (!Objects.equals(this.getRepresentationClass(), dataFlavor.getRepresentationClass())) {
            return false;
        }
        if (this.mimeType == null) {
            if (dataFlavor.mimeType != null) {
                return false;
            }
        } else {
            if (!this.mimeType.match(dataFlavor.mimeType)) {
                return false;
            }
            if ("text".equals(this.getPrimaryType())) {
                String string;
                String string2;
                if (DataTransferer.doesSubtypeSupportCharset(this) && this.representationClass != null && !this.isStandardTextRepresentationClass() && !Objects.equals(string2 = DataTransferer.canonicalName(this.getParameter("charset")), string = DataTransferer.canonicalName(dataFlavor.getParameter("charset")))) {
                    return false;
                }
                if ("html".equals(this.getSubType()) && !Objects.equals(string2 = this.getParameter("document"), string = dataFlavor.getParameter("document"))) {
                    return false;
                }
            }
        }
        return true;
    }

    @Deprecated
    public boolean equals(String string) {
        if (string == null || this.mimeType == null) {
            return false;
        }
        return this.isMimeTypeEqual(string);
    }

    public int hashCode() {
        int n = 0;
        if (this.representationClass != null) {
            n += this.representationClass.hashCode();
        }
        if (this.mimeType != null) {
            String string = this.mimeType.getPrimaryType();
            if (string != null) {
                n += string.hashCode();
            }
            if ("text".equals(string)) {
                String string2;
                if (DataTransferer.doesSubtypeSupportCharset(this) && this.representationClass != null && !this.isStandardTextRepresentationClass() && (string2 = DataTransferer.canonicalName(this.getParameter("charset"))) != null) {
                    n += string2.hashCode();
                }
                if ("html".equals(this.getSubType()) && (string2 = this.getParameter("document")) != null) {
                    n += string2.hashCode();
                }
            }
        }
        return n;
    }

    public boolean match(DataFlavor dataFlavor) {
        return this.equals(dataFlavor);
    }

    public boolean isMimeTypeEqual(String string) {
        if (string == null) {
            throw new NullPointerException("mimeType");
        }
        if (this.mimeType == null) {
            return false;
        }
        try {
            return this.mimeType.match(new MimeType(string));
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            return false;
        }
    }

    public final boolean isMimeTypeEqual(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor.mimeType);
    }

    private boolean isMimeTypeEqual(MimeType mimeType) {
        if (this.mimeType == null) {
            return mimeType == null;
        }
        return this.mimeType.match(mimeType);
    }

    private boolean isStandardTextRepresentationClass() {
        return this.isRepresentationClassReader() || String.class.equals(this.representationClass) || this.isRepresentationClassCharBuffer() || char[].class.equals(this.representationClass);
    }

    public boolean isMimeTypeSerializedObject() {
        return this.isMimeTypeEqual(javaSerializedObjectMimeType);
    }

    public final Class<?> getDefaultRepresentationClass() {
        return ioInputStreamClass;
    }

    public final String getDefaultRepresentationClassAsString() {
        return this.getDefaultRepresentationClass().getName();
    }

    public boolean isRepresentationClassInputStream() {
        return ioInputStreamClass.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassReader() {
        return Reader.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassCharBuffer() {
        return CharBuffer.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassByteBuffer() {
        return ByteBuffer.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassSerializable() {
        return Serializable.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassRemote() {
        return DataTransferer.isRemote(this.representationClass);
    }

    public boolean isFlavorSerializedObjectType() {
        return this.isRepresentationClassSerializable() && this.isMimeTypeEqual(javaSerializedObjectMimeType);
    }

    public boolean isFlavorRemoteObjectType() {
        return this.isRepresentationClassRemote() && this.isRepresentationClassSerializable() && this.isMimeTypeEqual(javaRemoteObjectMimeType);
    }

    public boolean isFlavorJavaFileListType() {
        if (this.mimeType == null || this.representationClass == null) {
            return false;
        }
        return List.class.isAssignableFrom(this.representationClass) && this.mimeType.match(DataFlavor.javaFileListFlavor.mimeType);
    }

    public boolean isFlavorTextType() {
        return DataTransferer.isFlavorCharsetTextType(this) || DataTransferer.isFlavorNoncharsetTextType(this);
    }

    @Override
    public synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.mimeType != null) {
            this.mimeType.setParameter("humanPresentableName", this.humanPresentableName);
            objectOutput.writeObject(this.mimeType);
            this.mimeType.removeParameter("humanPresentableName");
        } else {
            objectOutput.writeObject(null);
        }
        objectOutput.writeObject(this.representationClass);
    }

    @Override
    public synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        block5: {
            String string = null;
            this.mimeType = (MimeType)objectInput.readObject();
            if (this.mimeType != null) {
                this.humanPresentableName = this.mimeType.getParameter("humanPresentableName");
                this.mimeType.removeParameter("humanPresentableName");
                string = this.mimeType.getParameter("class");
                if (string == null) {
                    throw new IOException("no class parameter specified in: " + this.mimeType);
                }
            }
            try {
                this.representationClass = (Class)objectInput.readObject();
            }
            catch (OptionalDataException optionalDataException) {
                if (!optionalDataException.eof || optionalDataException.length != 0) {
                    throw optionalDataException;
                }
                if (string == null) break block5;
                this.representationClass = DataFlavor.tryToLoadClass(string, this.getClass().getClassLoader());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        if (this.mimeType != null) {
            ((DataFlavor)object).mimeType = (MimeType)this.mimeType.clone();
        }
        return object;
    }

    @Deprecated
    protected String normalizeMimeTypeParameter(String string, String string2) {
        return string2;
    }

    @Deprecated
    protected String normalizeMimeType(String string) {
        return string;
    }

    static class TextFlavorComparator
    extends DataTransferer.DataFlavorComparator {
        TextFlavorComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            DataFlavor dataFlavor = (DataFlavor)object;
            DataFlavor dataFlavor2 = (DataFlavor)object2;
            if (dataFlavor.isFlavorTextType()) {
                if (dataFlavor2.isFlavorTextType()) {
                    return super.compare(object, object2);
                }
                return 1;
            }
            if (dataFlavor2.isFlavorTextType()) {
                return -1;
            }
            return 0;
        }
    }
}

