/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;
import sun.security.action.GetPropertyAction;

public final class ObjID
implements Serializable {
    public static final int REGISTRY_ID = 0;
    public static final int ACTIVATOR_ID = 1;
    public static final int DGC_ID = 2;
    private static final long serialVersionUID = -6386392263968365220L;
    private static final AtomicLong nextObjNum = new AtomicLong(0L);
    private static final UID mySpace = new UID();
    private static final SecureRandom secureRandom = new SecureRandom();
    private final long objNum;
    private final UID space;

    public ObjID() {
        if (ObjID.useRandomIDs()) {
            this.space = new UID();
            this.objNum = secureRandom.nextLong();
        } else {
            this.space = mySpace;
            this.objNum = nextObjNum.getAndIncrement();
        }
    }

    public ObjID(int n) {
        this.space = new UID(0);
        this.objNum = n;
    }

    private ObjID(long l, UID uID) {
        this.objNum = l;
        this.space = uID;
    }

    public void write(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.objNum);
        this.space.write(objectOutput);
    }

    public static ObjID read(ObjectInput objectInput) throws IOException {
        long l = objectInput.readLong();
        UID uID = UID.read(objectInput);
        return new ObjID(l, uID);
    }

    public int hashCode() {
        return (int)this.objNum;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjID) {
            ObjID objID = (ObjID)object;
            return this.objNum == objID.objNum && this.space.equals(objID.space);
        }
        return false;
    }

    public String toString() {
        return "[" + (this.space.equals(mySpace) ? "" : this.space + ", ") + this.objNum + "]";
    }

    private static boolean useRandomIDs() {
        String string = AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.randomIDs"));
        return string == null ? true : Boolean.parseBoolean(string);
    }
}

