/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.security.auth.kerberos.ServicePermission;

final class KrbServicePermissionCollection
extends PermissionCollection
implements Serializable {
    private transient List<Permission> perms = new ArrayList<Permission>();
    private static final long serialVersionUID = -4118834211490102011L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Vector.class)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        int n = servicePermission.getMask();
        int n2 = 0;
        int n3 = n;
        KrbServicePermissionCollection krbServicePermissionCollection = this;
        synchronized (krbServicePermissionCollection) {
            int n4 = this.perms.size();
            for (int i = 0; i < n4; ++i) {
                ServicePermission servicePermission2 = (ServicePermission)this.perms.get(i);
                if ((n3 & servicePermission2.getMask()) == 0 || !servicePermission2.impliesIgnoreMask(servicePermission)) continue;
                if (((n2 |= servicePermission2.getMask()) & n) == n) {
                    return true;
                }
                n3 = n ^ n2;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        KrbServicePermissionCollection krbServicePermissionCollection = this;
        synchronized (krbServicePermissionCollection) {
            this.perms.add(0, permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Permission> elements() {
        KrbServicePermissionCollection krbServicePermissionCollection = this;
        synchronized (krbServicePermissionCollection) {
            return Collections.enumeration(this.perms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Permission> vector = new Vector<Permission>(this.perms.size());
        Object object = this;
        synchronized (object) {
            vector.addAll(this.perms);
        }
        object = objectOutputStream.putFields();
        ((ObjectOutputStream.PutField)object).put("permissions", vector);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Vector vector = (Vector)getField.get("permissions", null);
        this.perms = new ArrayList<Permission>(vector.size());
        this.perms.addAll(vector);
    }
}

