/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XIMStyles
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 8 : 16;
    }

    @Override
    public int getDataSize() {
        return XIMStyles.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XIMStyles(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XIMStyles() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XIMStyles.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public short get_count_styles() {
        log.finest("");
        return Native.getShort(this.pData + 0L);
    }

    public void set_count_styles(short s) {
        log.finest("");
        Native.putShort(this.pData + 0L, s);
    }

    public long get_supported_styles(int n) {
        log.finest("");
        return Native.getLong(Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8)) + (long)(n * Native.getLongSize()));
    }

    public long get_supported_styles() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_supported_styles(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), l);
    }

    @Override
    String getName() {
        return "XIMStyles";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("count_styles = ").append(this.get_count_styles()).append(", ");
        stringBuilder.append("supported_styles = ").append(this.get_supported_styles()).append(", ");
        return stringBuilder.toString();
    }
}

