/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.URISyntax;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterStateReason;
import javax.print.attribute.standard.PrinterStateReasons;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import sun.awt.image.ByteInterleavedRaster;
import sun.print.CustomMediaSizeName;
import sun.print.OpenBook;
import sun.print.PageableDoc;
import sun.print.PathGraphics;
import sun.print.PeekGraphics;
import sun.print.PrinterGraphicsConfig;
import sun.print.PrinterJobWrapper;
import sun.print.ProxyGraphics2D;
import sun.print.ServiceDialog;
import sun.print.SunAlternateMedia;
import sun.print.SunPageSelection;
import sun.print.SunPrinterJobService;
import sun.security.action.GetPropertyAction;

public abstract class RasterPrinterJob
extends PrinterJob {
    protected static final int PRINTER = 0;
    protected static final int FILE = 1;
    protected static final int STREAM = 2;
    private static final int MAX_BAND_SIZE = 0x400000;
    private static final float DPI = 72.0f;
    private static final String FORCE_PIPE_PROP = "sun.java2d.print.pipeline";
    private static final String FORCE_RASTER = "raster";
    private static final String FORCE_PDL = "pdl";
    private static final String SHAPE_TEXT_PROP = "sun.java2d.print.shapetext";
    public static boolean forcePDL;
    public static boolean forceRaster;
    public static boolean shapeTextProp;
    private int cachedBandWidth = 0;
    private int cachedBandHeight = 0;
    private BufferedImage cachedBand = null;
    private int mNumCopies = 1;
    private boolean mCollate = false;
    private int mFirstPage = -1;
    private int mLastPage = -1;
    private Paper previousPaper;
    protected Pageable mDocument = new Book();
    private String mDocName = "Java Printing";
    protected boolean performingPrinting = false;
    protected boolean userCancelled = false;
    private FilePermission printToFilePermission;
    private ArrayList redrawList = new ArrayList();
    private int copiesAttr;
    private String jobNameAttr;
    private String userNameAttr;
    private PageRanges pageRangesAttr;
    protected Sides sidesAttr;
    protected String destinationAttr;
    protected boolean noJobSheet = false;
    protected int mDestType = 1;
    protected String mDestination = "";
    protected boolean collateAttReq = false;
    protected boolean landscapeRotates270 = false;
    protected PrintRequestAttributeSet attributes = null;
    protected PrintService myService;
    public static boolean debugPrint;
    private int deviceWidth;
    private int deviceHeight;
    private AffineTransform defaultDeviceTransform;
    private PrinterGraphicsConfig pgConfig;

    protected abstract double getXRes();

    protected abstract double getYRes();

    protected abstract double getPhysicalPrintableX(Paper var1);

    protected abstract double getPhysicalPrintableY(Paper var1);

    protected abstract double getPhysicalPrintableWidth(Paper var1);

    protected abstract double getPhysicalPrintableHeight(Paper var1);

    protected abstract double getPhysicalPageWidth(Paper var1);

    protected abstract double getPhysicalPageHeight(Paper var1);

    protected abstract void startPage(PageFormat var1, Printable var2, int var3, boolean var4) throws PrinterException;

    protected abstract void endPage(PageFormat var1, Printable var2, int var3) throws PrinterException;

    protected abstract void printBand(byte[] var1, int var2, int var3, int var4, int var5) throws PrinterException;

    public void saveState(AffineTransform affineTransform, Shape shape, Rectangle2D rectangle2D, double d, double d2) {
        GraphicsState graphicsState = new GraphicsState();
        graphicsState.theTransform = affineTransform;
        graphicsState.theClip = shape;
        graphicsState.region = rectangle2D;
        graphicsState.sx = d;
        graphicsState.sy = d2;
        this.redrawList.add(graphicsState);
    }

    protected static PrintService lookupDefaultPrintService() {
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printService != null && printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
            return printService;
        }
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (printServiceArray.length > 0) {
            return printServiceArray[0];
        }
        return null;
    }

    @Override
    public PrintService getPrintService() {
        if (this.myService == null) {
            PrintService[] printServiceArray;
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            if (printService != null && printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE)) {
                try {
                    this.setPrintService(printService);
                    this.myService = printService;
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
            if (this.myService == null && (printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null)).length > 0) {
                try {
                    this.setPrintService(printServiceArray[0]);
                    this.myService = printServiceArray[0];
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
        }
        return this.myService;
    }

    @Override
    public void setPrintService(PrintService printService) throws PrinterException {
        PrinterStateReasons printerStateReasons;
        if (printService == null) {
            throw new PrinterException("Service cannot be null");
        }
        if (!(printService instanceof StreamPrintService) && printService.getName() == null) {
            throw new PrinterException("Null PrintService name.");
        }
        PrinterState printerState = printService.getAttribute(PrinterState.class);
        if (printerState == PrinterState.STOPPED && (printerStateReasons = printService.getAttribute(PrinterStateReasons.class)) != null && printerStateReasons.containsKey(PrinterStateReason.SHUTDOWN)) {
            throw new PrinterException("PrintService is no longer available.");
        }
        if (!printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || !printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
            throw new PrinterException("Not a 2D print service: " + printService);
        }
        this.myService = printService;
    }

    protected void updatePageAttributes(PrintService printService, PageFormat pageFormat) {
        OrientationRequested orientationRequested;
        if (printService == null || pageFormat == null) {
            return;
        }
        float f = (float)Math.rint(pageFormat.getPaper().getWidth() * 25400.0 / 72.0) / 25400.0f;
        float f2 = (float)Math.rint(pageFormat.getPaper().getHeight() * 25400.0 / 72.0) / 25400.0f;
        Media[] mediaArray = (Media[])printService.getSupportedAttributeValues(Media.class, null, null);
        Media media = null;
        try {
            media = CustomMediaSizeName.findMedia(mediaArray, f, f2, 25400);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (media == null || !printService.isAttributeValueSupported(media, null, null)) {
            media = (Media)printService.getDefaultAttributeValue(Media.class);
        }
        switch (pageFormat.getOrientation()) {
            case 0: {
                orientationRequested = OrientationRequested.LANDSCAPE;
                break;
            }
            case 2: {
                orientationRequested = OrientationRequested.REVERSE_LANDSCAPE;
                break;
            }
            default: {
                orientationRequested = OrientationRequested.PORTRAIT;
            }
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        if (media != null) {
            this.attributes.add(media);
        }
        this.attributes.add(orientationRequested);
        float f3 = (float)(pageFormat.getPaper().getImageableX() / 72.0);
        float f4 = (float)(pageFormat.getPaper().getImageableWidth() / 72.0);
        float f5 = (float)(pageFormat.getPaper().getImageableY() / 72.0);
        float f6 = (float)(pageFormat.getPaper().getImageableHeight() / 72.0);
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f5 < 0.0f) {
            f5 = 0.0f;
        }
        try {
            this.attributes.add(new MediaPrintableArea(f3, f5, f4, f6, 25400));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public PageFormat pageDialog(PageFormat pageFormat) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        final GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        PrintService printService = (PrintService)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrintService printService = RasterPrinterJob.this.getPrintService();
                if (printService == null) {
                    ServiceDialog.showNoPrintService(graphicsConfiguration);
                    return null;
                }
                return printService;
            }
        });
        if (printService == null) {
            return pageFormat;
        }
        this.updatePageAttributes(printService, pageFormat);
        PageFormat pageFormat2 = this.pageDialog(this.attributes);
        if (pageFormat2 == null) {
            return pageFormat;
        }
        return pageFormat2;
    }

    @Override
    public PageFormat pageDialog(PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        final GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        int n = rectangle.x + rectangle.width / 3;
        int n2 = rectangle.y + rectangle.height / 3;
        PrintService printService = (PrintService)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrintService printService = RasterPrinterJob.this.getPrintService();
                if (printService == null) {
                    ServiceDialog.showNoPrintService(graphicsConfiguration);
                    return null;
                }
                return printService;
            }
        });
        if (printService == null) {
            return null;
        }
        ServiceDialog serviceDialog = new ServiceDialog(graphicsConfiguration, n, n2, printService, (DocFlavor)DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet, (Frame)null);
        serviceDialog.show();
        if (serviceDialog.getStatus() == 1) {
            double d;
            double d2;
            double d3;
            double d4;
            MediaSize mediaSize;
            PrintRequestAttributeSet printRequestAttributeSet2 = serviceDialog.getAttributes();
            Class<SunAlternateMedia> clazz = SunAlternateMedia.class;
            if (printRequestAttributeSet.containsKey(clazz) && !printRequestAttributeSet2.containsKey(clazz)) {
                printRequestAttributeSet.remove(clazz);
            }
            printRequestAttributeSet.addAll(printRequestAttributeSet2);
            PageFormat pageFormat = this.defaultPage();
            OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
            int n3 = 1;
            if (orientationRequested != null) {
                if (orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
                    n3 = 2;
                } else if (orientationRequested == OrientationRequested.LANDSCAPE) {
                    n3 = 0;
                }
            }
            pageFormat.setOrientation(n3);
            Media media = (Media)printRequestAttributeSet.get(Media.class);
            if (media == null) {
                media = (Media)printService.getDefaultAttributeValue(Media.class);
            }
            if (!(media instanceof MediaSizeName)) {
                media = MediaSizeName.NA_LETTER;
            }
            if ((mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media)) == null) {
                mediaSize = MediaSize.NA.LETTER;
            }
            Paper paper = new Paper();
            float[] fArray = mediaSize.getSize(1);
            double d5 = Math.rint((double)fArray[0] * 72.0 / 25400.0);
            double d6 = Math.rint((double)fArray[1] * 72.0 / 25400.0);
            paper.setSize(d5, d6);
            MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
            if (mediaPrintableArea != null) {
                d4 = Math.rint(mediaPrintableArea.getX(25400) * 72.0f);
                d3 = Math.rint(mediaPrintableArea.getY(25400) * 72.0f);
                d2 = Math.rint(mediaPrintableArea.getWidth(25400) * 72.0f);
                d = Math.rint(mediaPrintableArea.getHeight(25400) * 72.0f);
            } else {
                if (d5 >= 432.0) {
                    d4 = 72.0;
                    d2 = d5 - 144.0;
                } else {
                    d4 = d5 / 6.0;
                    d2 = d5 * 0.75;
                }
                if (d6 >= 432.0) {
                    d3 = 72.0;
                    d = d6 - 144.0;
                } else {
                    d3 = d6 / 6.0;
                    d = d6 * 0.75;
                }
            }
            paper.setImageableArea(d4, d3, d2, d);
            pageFormat.setPaper(paper);
            return pageFormat;
        }
        return null;
    }

    @Override
    public boolean printDialog(PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        PrintService printService;
        PrintService[] printServiceArray;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        DialogTypeSelection dialogTypeSelection = (DialogTypeSelection)printRequestAttributeSet.get(DialogTypeSelection.class);
        if (dialogTypeSelection == DialogTypeSelection.NATIVE) {
            this.attributes = printRequestAttributeSet;
            try {
                this.debug_println("calling setAttributes in printDialog");
                this.setAttributes(printRequestAttributeSet);
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
            boolean bl = this.printDialog();
            this.attributes = printRequestAttributeSet;
            return bl;
        }
        final GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        PrintService printService2 = (PrintService)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrintService printService = RasterPrinterJob.this.getPrintService();
                if (printService == null) {
                    ServiceDialog.showNoPrintService(graphicsConfiguration);
                    return null;
                }
                return printService;
            }
        });
        if (printService2 == null) {
            return false;
        }
        StreamPrintServiceFactory[] streamPrintServiceFactoryArray = null;
        if (printService2 instanceof StreamPrintService) {
            streamPrintServiceFactoryArray = RasterPrinterJob.lookupStreamPrintServices(null);
            printServiceArray = new StreamPrintService[streamPrintServiceFactoryArray.length];
            for (int i = 0; i < streamPrintServiceFactoryArray.length; ++i) {
                printServiceArray[i] = streamPrintServiceFactoryArray[i].getPrintService(null);
            }
        } else {
            printServiceArray = (PrintService[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
                    return printServiceArray;
                }
            });
            if (printServiceArray == null || printServiceArray.length == 0) {
                printServiceArray = new PrintService[]{printService2};
            }
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        int n = rectangle.x + rectangle.width / 3;
        int n2 = rectangle.y + rectangle.height / 3;
        PrinterJobWrapper printerJobWrapper = new PrinterJobWrapper(this);
        printRequestAttributeSet.add(printerJobWrapper);
        try {
            printService = ServiceUI.printDialog(graphicsConfiguration, n, n2, printServiceArray, printService2, DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            printService = ServiceUI.printDialog(graphicsConfiguration, n, n2, printServiceArray, printServiceArray[0], DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet);
        }
        printRequestAttributeSet.remove(PrinterJobWrapper.class);
        if (printService == null) {
            return false;
        }
        if (!printService2.equals(printService)) {
            try {
                this.setPrintService(printService);
            }
            catch (PrinterException printerException) {
                this.myService = printService;
            }
        }
        return true;
    }

    @Override
    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(new Copies(this.getCopies()));
        hashPrintRequestAttributeSet.add(new JobName(this.getJobName(), null));
        boolean bl = this.printDialog(hashPrintRequestAttributeSet);
        if (bl) {
            Destination destination;
            Copies copies;
            JobName jobName = (JobName)hashPrintRequestAttributeSet.get(JobName.class);
            if (jobName != null) {
                this.setJobName(jobName.getValue());
            }
            if ((copies = (Copies)hashPrintRequestAttributeSet.get(Copies.class)) != null) {
                this.setCopies(copies.getValue());
            }
            if ((destination = (Destination)hashPrintRequestAttributeSet.get(Destination.class)) != null) {
                try {
                    this.mDestType = 1;
                    this.mDestination = new File(destination.getURI()).getPath();
                }
                catch (Exception exception) {
                    Destination destination2;
                    this.mDestination = "out.prn";
                    PrintService printService = this.getPrintService();
                    if (printService != null && (destination2 = (Destination)printService.getDefaultAttributeValue(Destination.class)) != null) {
                        this.mDestination = new File(destination2.getURI()).getPath();
                    }
                }
            } else {
                this.mDestType = 0;
                PrintService printService = this.getPrintService();
                if (printService != null) {
                    this.mDestination = printService.getName();
                }
            }
        }
        return bl;
    }

    @Override
    public void setPrintable(Printable printable) {
        this.setPageable(new OpenBook(this.defaultPage(new PageFormat()), printable));
    }

    @Override
    public void setPrintable(Printable printable, PageFormat pageFormat) {
        this.setPageable(new OpenBook(pageFormat, printable));
        this.updatePageAttributes(this.getPrintService(), pageFormat);
    }

    @Override
    public void setPageable(Pageable pageable) throws NullPointerException {
        if (pageable == null) {
            throw new NullPointerException();
        }
        this.mDocument = pageable;
    }

    protected void initPrinter() {
    }

    protected boolean isSupportedValue(Attribute attribute, PrintRequestAttributeSet printRequestAttributeSet) {
        PrintService printService = this.getPrintService();
        return attribute != null && printService != null && printService.isAttributeValueSupported(attribute, DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet);
    }

    protected void setAttributes(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        JobSheets jobSheets;
        Cloneable cloneable;
        boolean bl;
        PrintService printService;
        block29: {
            Object object;
            Object object2;
            this.setCollated(false);
            this.sidesAttr = null;
            this.pageRangesAttr = null;
            this.copiesAttr = 0;
            this.jobNameAttr = null;
            this.userNameAttr = null;
            this.destinationAttr = null;
            this.collateAttReq = false;
            printService = this.getPrintService();
            if (printRequestAttributeSet == null || printService == null) {
                return;
            }
            bl = false;
            Fidelity fidelity = (Fidelity)printRequestAttributeSet.get(Fidelity.class);
            if (fidelity != null && fidelity == Fidelity.FIDELITY_TRUE) {
                bl = true;
            }
            if (bl && (object2 = printService.getUnsupportedAttributes(DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet)) != null) {
                throw new PrinterException("Fidelity cannot be satisfied");
            }
            object2 = (SheetCollate)printRequestAttributeSet.get(SheetCollate.class);
            if (this.isSupportedValue((Attribute)object2, printRequestAttributeSet)) {
                this.setCollated(object2 == SheetCollate.COLLATED);
            }
            this.sidesAttr = (Sides)printRequestAttributeSet.get(Sides.class);
            if (!this.isSupportedValue(this.sidesAttr, printRequestAttributeSet)) {
                this.sidesAttr = Sides.ONE_SIDED;
            }
            this.pageRangesAttr = (PageRanges)printRequestAttributeSet.get(PageRanges.class);
            if (!this.isSupportedValue(this.pageRangesAttr, printRequestAttributeSet)) {
                this.pageRangesAttr = null;
            } else if ((SunPageSelection)printRequestAttributeSet.get(SunPageSelection.class) == SunPageSelection.RANGE) {
                object = this.pageRangesAttr.getMembers();
                this.setPageRange((int)(object[0][0] - true), (int)(object[0][1] - true));
            } else {
                this.setPageRange(-1, -1);
            }
            object = (Copies)printRequestAttributeSet.get(Copies.class);
            if (this.isSupportedValue((Attribute)object, printRequestAttributeSet) || !bl && object != null) {
                this.copiesAttr = ((IntegerSyntax)object).getValue();
                this.setCopies(this.copiesAttr);
            } else {
                this.copiesAttr = this.getCopies();
            }
            Destination destination = (Destination)printRequestAttributeSet.get(Destination.class);
            if (this.isSupportedValue(destination, printRequestAttributeSet)) {
                try {
                    this.destinationAttr = "" + new File(destination.getURI().getSchemeSpecificPart());
                }
                catch (Exception exception) {
                    cloneable = (Destination)printService.getDefaultAttributeValue(Destination.class);
                    if (cloneable == null) break block29;
                    this.destinationAttr = "" + new File(((URISyntax)cloneable).getURI().getSchemeSpecificPart());
                }
            }
        }
        if ((jobSheets = (JobSheets)printRequestAttributeSet.get(JobSheets.class)) != null) {
            boolean bl2 = this.noJobSheet = jobSheets == JobSheets.NONE;
        }
        if (this.isSupportedValue((Attribute)((Object)(cloneable = (JobName)printRequestAttributeSet.get(JobName.class))), printRequestAttributeSet) || !bl && cloneable != null) {
            this.jobNameAttr = ((TextSyntax)cloneable).getValue();
            this.setJobName(this.jobNameAttr);
        } else {
            this.jobNameAttr = this.getJobName();
        }
        RequestingUserName requestingUserName = (RequestingUserName)printRequestAttributeSet.get(RequestingUserName.class);
        if (this.isSupportedValue(requestingUserName, printRequestAttributeSet) || !bl && requestingUserName != null) {
            this.userNameAttr = requestingUserName.getValue();
        } else {
            try {
                this.userNameAttr = this.getUserName();
            }
            catch (SecurityException securityException) {
                this.userNameAttr = "";
            }
        }
        Media media = (Media)printRequestAttributeSet.get(Media.class);
        OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
        if ((orientationRequested != null || media != null || mediaPrintableArea != null) && this.getPageable() instanceof OpenBook) {
            MediaSize mediaSize;
            Object object;
            Pageable pageable = this.getPageable();
            Printable printable = pageable.getPrintable(0);
            PageFormat pageFormat = (PageFormat)pageable.getPageFormat(0).clone();
            Paper paper = pageFormat.getPaper();
            if (mediaPrintableArea == null && media != null && printService.isAttributeCategorySupported(MediaPrintableArea.class) && (object = printService.getSupportedAttributeValues(MediaPrintableArea.class, null, printRequestAttributeSet)) instanceof MediaPrintableArea[] && ((MediaPrintableArea[])object).length > 0) {
                mediaPrintableArea = ((MediaPrintableArea[])object)[0];
            }
            if (this.isSupportedValue(orientationRequested, printRequestAttributeSet) || !bl && orientationRequested != null) {
                int n = orientationRequested.equals(OrientationRequested.REVERSE_LANDSCAPE) ? 2 : (orientationRequested.equals(OrientationRequested.LANDSCAPE) ? 0 : 1);
                pageFormat.setOrientation(n);
            }
            if ((this.isSupportedValue(media, printRequestAttributeSet) || !bl && media != null) && media instanceof MediaSizeName && (mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)(object = (MediaSizeName)media))) != null) {
                float f = mediaSize.getX(25400) * 72.0f;
                float f2 = mediaSize.getY(25400) * 72.0f;
                paper.setSize(f, f2);
                if (mediaPrintableArea == null) {
                    paper.setImageableArea(72.0, 72.0, (double)f - 144.0, (double)f2 - 144.0);
                }
            }
            if (this.isSupportedValue(mediaPrintableArea, printRequestAttributeSet) || !bl && mediaPrintableArea != null) {
                object = mediaPrintableArea.getPrintableArea(25400);
                for (int i = 0; i < ((Object)object).length; ++i) {
                    object[i] = object[i] * 72.0f;
                }
                paper.setImageableArea((double)object[0], (double)object[1], (double)object[2], (double)object[3]);
            }
            pageFormat.setPaper(paper);
            pageFormat = this.validatePage(pageFormat);
            this.setPrintable(printable, pageFormat);
        } else {
            this.attributes = printRequestAttributeSet;
        }
    }

    protected void spoolToService(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        if (printService == null) {
            throw new PrinterException("No print service found.");
        }
        DocPrintJob docPrintJob = printService.createPrintJob();
        PageableDoc pageableDoc = new PageableDoc(this.getPageable());
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
        }
        try {
            docPrintJob.print(pageableDoc, printRequestAttributeSet);
        }
        catch (PrintException printException) {
            throw new PrinterException(printException.toString());
        }
    }

    @Override
    public void print() throws PrinterException {
        this.print(this.attributes);
    }

    protected void debug_println(String string) {
        if (debugPrint) {
            System.out.println("RasterPrinterJob " + string + " " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        int n;
        PrinterStateReasons printerStateReasons;
        PrintService printService = this.getPrintService();
        this.debug_println("psvc = " + printService);
        if (printService == null) {
            throw new PrinterException("No print service found.");
        }
        PrinterState printerState = printService.getAttribute(PrinterState.class);
        if (printerState == PrinterState.STOPPED && (printerStateReasons = printService.getAttribute(PrinterStateReasons.class)) != null && printerStateReasons.containsKey(PrinterStateReason.SHUTDOWN)) {
            throw new PrinterException("PrintService is no longer available.");
        }
        if (printService.getAttribute(PrinterIsAcceptingJobs.class) == PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS) {
            throw new PrinterException("Printer is not accepting job.");
        }
        if (printService instanceof SunPrinterJobService && ((SunPrinterJobService)((Object)printService)).usesClass(this.getClass())) {
            this.setAttributes(printRequestAttributeSet);
            if (this.destinationAttr != null) {
                this.validateDestination(this.destinationAttr);
            }
        } else {
            this.spoolToService(printService, printRequestAttributeSet);
            return;
        }
        this.initPrinter();
        int n2 = this.getCollatedCopies();
        int n3 = this.getNoncollatedCopies();
        this.debug_println("getCollatedCopies()  " + n2 + " getNoncollatedCopies() " + n3);
        int n4 = this.mDocument.getNumberOfPages();
        if (n4 == 0) {
            return;
        }
        int n5 = this.getFirstPage();
        int n6 = this.getLastPage();
        if (n6 == -1 && (n = this.mDocument.getNumberOfPages()) != -1) {
            n6 = this.mDocument.getNumberOfPages() - 1;
        }
        try {
            SunPageSelection sunPageSelection;
            RasterPrinterJob rasterPrinterJob = this;
            synchronized (rasterPrinterJob) {
                this.performingPrinting = true;
                this.userCancelled = false;
            }
            this.startDoc();
            if (this.isCancelled()) {
                this.cancelDoc();
            }
            boolean bl = true;
            if (printRequestAttributeSet != null && (sunPageSelection = (SunPageSelection)printRequestAttributeSet.get(SunPageSelection.class)) != null && sunPageSelection != SunPageSelection.RANGE) {
                bl = false;
            }
            this.debug_println("after startDoc rangeSelected? " + bl + " numNonCollatedCopies " + n3);
            block12: for (int i = 0; i < n2; ++i) {
                int n7 = 0;
                for (int j = n5; (j <= n6 || n6 == -1) && n7 == 0; ++j) {
                    int n8;
                    if (this.pageRangesAttr != null && bl) {
                        n8 = this.pageRangesAttr.next(j);
                        if (n8 == -1) continue block12;
                        if (n8 != j + 1) continue;
                    }
                    for (n8 = 0; n8 < n3 && n7 == 0; ++n8) {
                        if (this.isCancelled()) {
                            this.cancelDoc();
                        }
                        this.debug_println("printPage " + j);
                        n7 = this.printPage(this.mDocument, j);
                    }
                }
            }
            if (this.isCancelled()) {
                this.cancelDoc();
            }
        }
        finally {
            this.previousPaper = null;
            RasterPrinterJob rasterPrinterJob = this;
            synchronized (rasterPrinterJob) {
                if (this.performingPrinting) {
                    this.endDoc();
                }
                this.performingPrinting = false;
                this.notify();
            }
        }
    }

    protected void validateDestination(String string) throws PrinterException {
        if (string == null) {
            return;
        }
        File file = new File(string);
        try {
            if (file.createNewFile()) {
                file.delete();
            }
        }
        catch (IOException iOException) {
            throw new PrinterException("Cannot write to file:" + string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        File file2 = file.getParentFile();
        if (file.exists() && (!file.isFile() || !file.canWrite()) || file2 != null && (!file2.exists() || file2.exists() && !file2.canWrite())) {
            throw new PrinterException("Cannot write to file:" + string);
        }
    }

    protected void validatePaper(Paper paper, Paper paper2) {
        if (paper == null || paper2 == null) {
            return;
        }
        double d = paper.getWidth();
        double d2 = paper.getHeight();
        double d3 = paper.getImageableX();
        double d4 = paper.getImageableY();
        double d5 = paper.getImageableWidth();
        double d6 = paper.getImageableHeight();
        Paper paper3 = new Paper();
        d = d > 0.0 ? d : paper3.getWidth();
        d2 = d2 > 0.0 ? d2 : paper3.getHeight();
        d3 = d3 > 0.0 ? d3 : paper3.getImageableX();
        d4 = d4 > 0.0 ? d4 : paper3.getImageableY();
        d5 = d5 > 0.0 ? d5 : paper3.getImageableWidth();
        double d7 = d6 = d6 > 0.0 ? d6 : paper3.getImageableHeight();
        if (d5 > d) {
            d5 = d;
        }
        if (d6 > d2) {
            d6 = d2;
        }
        if (d3 + d5 > d) {
            d3 = d - d5;
        }
        if (d4 + d6 > d2) {
            d4 = d2 - d6;
        }
        paper2.setSize(d, d2);
        paper2.setImageableArea(d3, d4, d5, d6);
    }

    @Override
    public PageFormat defaultPage(PageFormat pageFormat) {
        Object object;
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        pageFormat2.setOrientation(1);
        Paper paper = new Paper();
        double d = 72.0;
        Media media = null;
        PrintService printService = this.getPrintService();
        if (printService != null && (media = (Media)printService.getDefaultAttributeValue(Media.class)) instanceof MediaSizeName && (object = MediaSize.getMediaSizeForName((MediaSizeName)media)) != null) {
            double d2 = (double)((Size2DSyntax)object).getX(25400) * d;
            double d3 = (double)((Size2DSyntax)object).getY(25400) * d;
            paper.setSize(d2, d3);
            paper.setImageableArea(d, d, d2 - 2.0 * d, d3 - 2.0 * d);
            pageFormat2.setPaper(paper);
            return pageFormat2;
        }
        object = Locale.getDefault().getCountry();
        if (!(Locale.getDefault().equals(Locale.ENGLISH) || object == null || ((String)object).equals(Locale.US.getCountry()) || ((String)object).equals(Locale.CANADA.getCountry()))) {
            double d4 = 25.4;
            double d5 = Math.rint(210.0 * d / d4);
            double d6 = Math.rint(297.0 * d / d4);
            paper.setSize(d5, d6);
            paper.setImageableArea(d, d, d5 - 2.0 * d, d6 - 2.0 * d);
        }
        pageFormat2.setPaper(paper);
        return pageFormat2;
    }

    @Override
    public PageFormat validatePage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        Paper paper = new Paper();
        this.validatePaper(pageFormat2.getPaper(), paper);
        pageFormat2.setPaper(paper);
        return pageFormat2;
    }

    @Override
    public void setCopies(int n) {
        this.mNumCopies = n;
    }

    @Override
    public int getCopies() {
        return this.mNumCopies;
    }

    protected int getCopiesInt() {
        return this.copiesAttr > 0 ? this.copiesAttr : this.getCopies();
    }

    @Override
    public String getUserName() {
        return System.getProperty("user.name");
    }

    protected String getUserNameInt() {
        if (this.userNameAttr != null) {
            return this.userNameAttr;
        }
        try {
            return this.getUserName();
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    @Override
    public void setJobName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.mDocName = string;
    }

    @Override
    public String getJobName() {
        return this.mDocName;
    }

    protected String getJobNameInt() {
        return this.jobNameAttr != null ? this.jobNameAttr : this.getJobName();
    }

    protected void setPageRange(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            this.mFirstPage = n;
            this.mLastPage = n2;
            if (this.mLastPage < this.mFirstPage) {
                this.mLastPage = this.mFirstPage;
            }
        } else {
            this.mFirstPage = -1;
            this.mLastPage = -1;
        }
    }

    protected int getFirstPage() {
        return this.mFirstPage == -1 ? 0 : this.mFirstPage;
    }

    protected int getLastPage() {
        return this.mLastPage;
    }

    protected void setCollated(boolean bl) {
        this.mCollate = bl;
        this.collateAttReq = true;
    }

    protected boolean isCollated() {
        return this.mCollate;
    }

    protected abstract void startDoc() throws PrinterException;

    protected abstract void endDoc() throws PrinterException;

    protected abstract void abortDoc();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelDoc() throws PrinterAbortException {
        this.abortDoc();
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            this.userCancelled = false;
            this.performingPrinting = false;
            this.notify();
        }
        throw new PrinterAbortException();
    }

    protected int getCollatedCopies() {
        return this.isCollated() ? this.getCopiesInt() : 1;
    }

    protected int getNoncollatedCopies() {
        return this.isCollated() ? 1 : this.getCopiesInt();
    }

    synchronized void setGraphicsConfigInfo(AffineTransform affineTransform, double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        affineTransform.transform(double_, double_);
        if (this.pgConfig == null || this.defaultDeviceTransform == null || !affineTransform.equals(this.defaultDeviceTransform) || this.deviceWidth != (int)double_.getX() || this.deviceHeight != (int)double_.getY()) {
            this.deviceWidth = (int)double_.getX();
            this.deviceHeight = (int)double_.getY();
            this.defaultDeviceTransform = affineTransform;
            this.pgConfig = null;
        }
    }

    synchronized PrinterGraphicsConfig getPrinterGraphicsConfig() {
        if (this.pgConfig != null) {
            return this.pgConfig;
        }
        String string = "Printer Device";
        PrintService printService = this.getPrintService();
        if (printService != null) {
            string = printService.toString();
        }
        this.pgConfig = new PrinterGraphicsConfig(string, this.defaultDeviceTransform, this.deviceWidth, this.deviceHeight);
        return this.pgConfig;
    }

    protected int printPage(Pageable pageable, int n) throws PrinterException {
        double d;
        double d2;
        Printable printable;
        PageFormat pageFormat;
        PageFormat pageFormat2;
        try {
            pageFormat2 = pageable.getPageFormat(n);
            pageFormat = (PageFormat)pageFormat2.clone();
            printable = pageable.getPrintable(n);
        }
        catch (Exception exception) {
            PrinterException printerException = new PrinterException("Error getting page or printable.[ " + exception + " ]");
            printerException.initCause(exception);
            throw printerException;
        }
        Paper paper = pageFormat.getPaper();
        if (pageFormat.getOrientation() != 1 && this.landscapeRotates270) {
            d2 = paper.getImageableX();
            d = paper.getImageableY();
            double d3 = paper.getImageableWidth();
            double d4 = paper.getImageableHeight();
            paper.setImageableArea(paper.getWidth() - d2 - d3, paper.getHeight() - d - d4, d3, d4);
            pageFormat.setPaper(paper);
            if (pageFormat.getOrientation() == 0) {
                pageFormat.setOrientation(2);
            } else {
                pageFormat.setOrientation(0);
            }
        }
        d2 = this.getXRes() / 72.0;
        d = this.getYRes() / 72.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(paper.getImageableX() * d2, paper.getImageableY() * d, paper.getImageableWidth() * d2, paper.getImageableHeight() * d);
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.scale(d2, d);
        int n2 = (int)((RectangularShape)double_).getWidth();
        if (n2 % 4 != 0) {
            n2 += 4 - n2 % 4;
        }
        if (n2 <= 0) {
            throw new PrinterException("Paper's imageable width is too small.");
        }
        int n3 = (int)((RectangularShape)double_).getHeight();
        if (n3 <= 0) {
            throw new PrinterException("Paper's imageable height is too small.");
        }
        int n4 = 0x400000 / n2 / 3;
        int n5 = (int)Math.rint(paper.getImageableX() * d2);
        int n6 = (int)Math.rint(paper.getImageableY() * d);
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.translate(-n5, n6);
        affineTransform3.translate(0.0, n4);
        affineTransform3.scale(1.0, -1.0);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 5);
        PeekGraphics peekGraphics = this.createPeekGraphics(bufferedImage.createGraphics(), this);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        peekGraphics.transform(affineTransform2);
        peekGraphics.translate(-this.getPhysicalPrintableX(paper) / d2, -this.getPhysicalPrintableY(paper) / d);
        peekGraphics.transform(new AffineTransform(pageFormat.getMatrix()));
        this.initPrinterGraphics(peekGraphics, double_2);
        AffineTransform affineTransform4 = peekGraphics.getTransform();
        this.setGraphicsConfigInfo(affineTransform2, paper.getWidth(), paper.getHeight());
        int n7 = printable.print(peekGraphics, pageFormat2, n);
        this.debug_println("pageResult " + n7);
        if (n7 == 0) {
            this.debug_println("startPage " + n);
            Paper paper2 = pageFormat.getPaper();
            boolean bl = this.previousPaper == null || paper2.getWidth() != this.previousPaper.getWidth() || paper2.getHeight() != this.previousPaper.getHeight();
            this.previousPaper = paper2;
            this.startPage(pageFormat, printable, n, bl);
            Graphics2D graphics2D = this.createPathGraphics(peekGraphics, this, printable, pageFormat, n);
            if (graphics2D != null) {
                graphics2D.transform(affineTransform2);
                graphics2D.translate(-this.getPhysicalPrintableX(paper) / d2, -this.getPhysicalPrintableY(paper) / d);
                graphics2D.transform(new AffineTransform(pageFormat.getMatrix()));
                this.initPrinterGraphics(graphics2D, double_2);
                this.redrawList.clear();
                AffineTransform affineTransform5 = graphics2D.getTransform();
                printable.print(graphics2D, pageFormat2, n);
                for (int i = 0; i < this.redrawList.size(); ++i) {
                    GraphicsState graphicsState = (GraphicsState)this.redrawList.get(i);
                    graphics2D.setTransform(affineTransform5);
                    ((PathGraphics)graphics2D).redrawRegion(graphicsState.region, graphicsState.sx, graphicsState.sy, graphicsState.theClip, graphicsState.theTransform);
                }
            } else {
                BufferedImage bufferedImage2 = this.cachedBand;
                if (this.cachedBand == null || n2 != this.cachedBandWidth || n4 != this.cachedBandHeight) {
                    this.cachedBand = bufferedImage2 = new BufferedImage(n2, n4, 5);
                    this.cachedBandWidth = n2;
                    this.cachedBandHeight = n4;
                }
                Graphics2D graphics2D2 = bufferedImage2.createGraphics();
                Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 0.0, n2, n4);
                this.initPrinterGraphics(graphics2D2, double_3);
                ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D2, this);
                Graphics2D graphics2D3 = bufferedImage2.createGraphics();
                graphics2D3.setColor(Color.white);
                ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage2.getRaster();
                byte[] byArray = byteInterleavedRaster.getDataStorage();
                int n8 = n6 + n3;
                int n9 = (int)this.getPhysicalPrintableX(paper);
                int n10 = (int)this.getPhysicalPrintableY(paper);
                for (int i = 0; i <= n3; i += n4) {
                    int n11;
                    graphics2D3.fillRect(0, 0, n2, n4);
                    graphics2D2.setTransform(affineTransform);
                    graphics2D2.transform(affineTransform3);
                    affineTransform3.translate(0.0, -n4);
                    graphics2D2.transform(affineTransform2);
                    graphics2D2.transform(new AffineTransform(pageFormat.getMatrix()));
                    Rectangle rectangle = graphics2D2.getClipBounds();
                    rectangle = affineTransform4.createTransformedShape(rectangle).getBounds();
                    if (rectangle != null && (!peekGraphics.hitsDrawingArea(rectangle) || n2 <= 0 || n4 <= 0)) continue;
                    int n12 = n5 - n9;
                    if (n12 < 0) {
                        graphics2D2.translate((double)n12 / d2, 0.0);
                        n12 = 0;
                    }
                    if ((n11 = n6 + i - n10) < 0) {
                        graphics2D2.translate(0.0, (double)n11 / d);
                        n11 = 0;
                    }
                    proxyGraphics2D.setDelegate((Graphics2D)graphics2D2.create());
                    printable.print(proxyGraphics2D, pageFormat2, n);
                    proxyGraphics2D.dispose();
                    this.printBand(byArray, n12, n11, n2, n4);
                }
                graphics2D3.dispose();
                graphics2D2.dispose();
            }
            this.debug_println("calling endPage " + n);
            this.endPage(pageFormat, printable, n);
        }
        return n7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            if (this.performingPrinting) {
                this.userCancelled = true;
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        boolean bl = false;
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            bl = this.performingPrinting && this.userCancelled;
            this.notify();
        }
        return bl;
    }

    protected Pageable getPageable() {
        return this.mDocument;
    }

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        return null;
    }

    protected PeekGraphics createPeekGraphics(Graphics2D graphics2D, PrinterJob printerJob) {
        return new PeekGraphics(graphics2D, printerJob);
    }

    protected void initPrinterGraphics(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setClip(rectangle2D);
        graphics2D.setPaint(Color.black);
    }

    public boolean checkAllowedToPrintToFile() {
        try {
            this.throwPrintToFile();
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private void throwPrintToFile() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.printToFilePermission == null) {
                this.printToFilePermission = new FilePermission("<<ALL FILES>>", "read,write");
            }
            securityManager.checkPermission(this.printToFilePermission);
        }
    }

    protected String removeControlChars(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char[] cArray2 = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c <= '\r' && c >= '\t' && c != '\u000b' && c != '\f') continue;
            cArray2[n2++] = c;
        }
        if (n2 == n) {
            return string;
        }
        return new String(cArray2, 0, n2);
    }

    static {
        String string;
        forcePDL = false;
        forceRaster = false;
        shapeTextProp = false;
        String string2 = AccessController.doPrivileged(new GetPropertyAction(FORCE_PIPE_PROP));
        if (string2 != null) {
            if (string2.equalsIgnoreCase(FORCE_PDL)) {
                forcePDL = true;
            } else if (string2.equalsIgnoreCase(FORCE_RASTER)) {
                forceRaster = true;
            }
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction(SHAPE_TEXT_PROP))) != null) {
            shapeTextProp = true;
        }
        debugPrint = false;
    }

    private class GraphicsState {
        Rectangle2D region;
        Shape theClip;
        AffineTransform theTransform;
        double sx;
        double sy;

        private GraphicsState() {
        }
    }
}

