/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.StringTokenizer;

public class TracedEventQueue
extends EventQueue {
    static boolean trace = false;
    static int[] suppressedIDs = null;

    @Override
    public void postEvent(AWTEvent aWTEvent) {
        boolean bl = true;
        int n = aWTEvent.getID();
        for (int i = 0; i < suppressedIDs.length; ++i) {
            if (n != suppressedIDs[i]) continue;
            bl = false;
            break;
        }
        if (bl) {
            System.out.println(Thread.currentThread().getName() + ": " + aWTEvent);
        }
        super.postEvent(aWTEvent);
    }

    static {
        String string = Toolkit.getProperty("AWT.IgnoreEventIDs", "");
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            suppressedIDs = new int[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                try {
                    TracedEventQueue.suppressedIDs[i] = Integer.parseInt(string2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Bad ID listed in AWT.IgnoreEventIDs in awt.properties: \"" + string2 + "\" -- skipped");
                    TracedEventQueue.suppressedIDs[i] = 0;
                }
            }
        } else {
            suppressedIDs = new int[0];
        }
    }
}

