/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Date;
import sun.security.util.DerOutputStream;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.SerialNumber;

class AdaptableX509CertSelector
extends X509CertSelector {
    private Date startDate;
    private Date endDate;
    private boolean isSKIDSensitive = false;
    private boolean isSNSensitive = false;

    AdaptableX509CertSelector() {
    }

    void setValidityPeriod(Date date, Date date2) {
        this.startDate = date;
        this.endDate = date2;
    }

    void parseAuthorityKeyIdentifierExtension(AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension) throws IOException {
        if (authorityKeyIdentifierExtension != null) {
            Object object;
            KeyIdentifier keyIdentifier = (KeyIdentifier)authorityKeyIdentifierExtension.get("key_id");
            if (keyIdentifier != null && (this.isSKIDSensitive || this.getSubjectKeyIdentifier() == null)) {
                object = new DerOutputStream();
                ((DerOutputStream)object).putOctetString(keyIdentifier.getIdentifier());
                super.setSubjectKeyIdentifier(((ByteArrayOutputStream)object).toByteArray());
                this.isSKIDSensitive = true;
            }
            if ((object = (SerialNumber)authorityKeyIdentifierExtension.get("serial_number")) != null && (this.isSNSensitive || this.getSerialNumber() == null)) {
                super.setSerialNumber(((SerialNumber)object).getNumber());
                this.isSNSensitive = true;
            }
        }
    }

    @Override
    public boolean match(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        int n = x509Certificate.getVersion();
        if (n < 3) {
            if (this.startDate != null) {
                try {
                    x509Certificate.checkValidity(this.startDate);
                }
                catch (CertificateException certificateException) {
                    return false;
                }
            }
            if (this.endDate != null) {
                try {
                    x509Certificate.checkValidity(this.endDate);
                }
                catch (CertificateException certificateException) {
                    return false;
                }
            }
        }
        if (this.isSKIDSensitive && (n < 3 || x509Certificate.getExtensionValue("2.5.29.14") == null)) {
            this.setSubjectKeyIdentifier(null);
        }
        if (this.isSNSensitive && n < 3) {
            this.setSerialNumber(null);
        }
        return super.match(certificate);
    }

    @Override
    public Object clone() {
        AdaptableX509CertSelector adaptableX509CertSelector = (AdaptableX509CertSelector)super.clone();
        if (this.startDate != null) {
            adaptableX509CertSelector.startDate = (Date)this.startDate.clone();
        }
        if (this.endDate != null) {
            adaptableX509CertSelector.endDate = (Date)this.endDate.clone();
        }
        return adaptableX509CertSelector;
    }
}

