/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.Handler;
import sun.net.www.protocol.jar.JarFileFactory;

public class JarURLConnection
extends java.net.JarURLConnection {
    private static final boolean debug = false;
    private static final JarFileFactory factory = JarFileFactory.getInstance();
    private URL jarFileURL = this.getJarFileURL();
    private Permission permission;
    private URLConnection jarFileURLConnection = this.jarFileURL.openConnection();
    private String entryName = this.getEntryName();
    private JarEntry jarEntry;
    private JarFile jarFile;
    private String contentType;

    public JarURLConnection(URL uRL, Handler handler) throws MalformedURLException, IOException {
        super(uRL);
    }

    @Override
    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntry;
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.jarFileURLConnection.getPermission();
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.jarFile = factory.get(this.getJarFileURL(), this.getUseCaches());
            if (this.getUseCaches()) {
                this.jarFileURLConnection = factory.getConnection(this.jarFile);
            }
            if (this.entryName != null) {
                this.jarEntry = (JarEntry)this.jarFile.getEntry(this.entryName);
                if (this.jarEntry == null) {
                    try {
                        if (!this.getUseCaches()) {
                            this.jarFile.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
                }
            }
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        JarURLInputStream jarURLInputStream = null;
        if (this.entryName == null) {
            throw new IOException("no entry name specified");
        }
        if (this.jarEntry == null) {
            throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
        }
        jarURLInputStream = new JarURLInputStream(this.jarFile.getInputStream(this.jarEntry));
        return jarURLInputStream;
    }

    @Override
    public int getContentLength() {
        long l = this.getContentLengthLong();
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    @Override
    public long getContentLengthLong() {
        long l = -1L;
        try {
            this.connect();
            l = this.jarEntry == null ? this.jarFileURLConnection.getContentLengthLong() : this.getJarEntry().getSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l;
    }

    @Override
    public Object getContent() throws IOException {
        Object object = null;
        this.connect();
        object = this.entryName == null ? this.jarFile : super.getContent();
        return object;
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            if (this.entryName == null) {
                this.contentType = "x-java/jar";
            } else {
                try {
                    this.connect();
                    InputStream inputStream = this.jarFile.getInputStream(this.jarEntry);
                    this.contentType = JarURLConnection.guessContentTypeFromStream(new BufferedInputStream(inputStream));
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.contentType == null) {
                this.contentType = JarURLConnection.guessContentTypeFromName(this.entryName);
            }
            if (this.contentType == null) {
                this.contentType = "content/unknown";
            }
        }
        return this.contentType;
    }

    @Override
    public String getHeaderField(String string) {
        return this.jarFileURLConnection.getHeaderField(string);
    }

    @Override
    public void setRequestProperty(String string, String string2) {
        this.jarFileURLConnection.setRequestProperty(string, string2);
    }

    @Override
    public String getRequestProperty(String string) {
        return this.jarFileURLConnection.getRequestProperty(string);
    }

    @Override
    public void addRequestProperty(String string, String string2) {
        this.jarFileURLConnection.addRequestProperty(string, string2);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.jarFileURLConnection.getRequestProperties();
    }

    @Override
    public void setAllowUserInteraction(boolean bl) {
        this.jarFileURLConnection.setAllowUserInteraction(bl);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.jarFileURLConnection.getAllowUserInteraction();
    }

    @Override
    public void setUseCaches(boolean bl) {
        this.jarFileURLConnection.setUseCaches(bl);
    }

    @Override
    public boolean getUseCaches() {
        return this.jarFileURLConnection.getUseCaches();
    }

    @Override
    public void setIfModifiedSince(long l) {
        this.jarFileURLConnection.setIfModifiedSince(l);
    }

    @Override
    public void setDefaultUseCaches(boolean bl) {
        this.jarFileURLConnection.setDefaultUseCaches(bl);
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.jarFileURLConnection.getDefaultUseCaches();
    }

    class JarURLInputStream
    extends FilterInputStream {
        JarURLInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                if (!JarURLConnection.this.getUseCaches()) {
                    JarURLConnection.this.jarFile.close();
                }
            }
        }
    }
}

