/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.NoSuchElementException;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public final class OptionalLong {
    private static final OptionalLong EMPTY = new OptionalLong();
    private final boolean isPresent;
    private final long value;

    private OptionalLong() {
        this.isPresent = false;
        this.value = 0L;
    }

    public static OptionalLong empty() {
        return EMPTY;
    }

    private OptionalLong(long l) {
        this.isPresent = true;
        this.value = l;
    }

    public static OptionalLong of(long l) {
        return new OptionalLong(l);
    }

    public long getAsLong() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(LongConsumer longConsumer) {
        if (this.isPresent) {
            longConsumer.accept(this.value);
        }
    }

    public long orElse(long l) {
        return this.isPresent ? this.value : l;
    }

    public long orElseGet(LongSupplier longSupplier) {
        return this.isPresent ? this.value : longSupplier.getAsLong();
    }

    public <X extends Throwable> long orElseThrow(Supplier<X> supplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)supplier.get();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OptionalLong)) {
            return false;
        }
        OptionalLong optionalLong = (OptionalLong)object;
        return this.isPresent && optionalLong.isPresent ? this.value == optionalLong.value : this.isPresent == optionalLong.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? Long.hashCode(this.value) : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalLong[%s]", this.value) : "OptionalLong.empty";
    }
}

