/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import sun.awt.SunToolkit;

public class JWindow
extends Window
implements Accessible,
RootPaneContainer,
TransferHandler.HasGetTransferHandler {
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    private TransferHandler transferHandler;
    protected AccessibleContext accessibleContext = null;

    public JWindow() {
        this((Frame)null);
    }

    public JWindow(GraphicsConfiguration graphicsConfiguration) {
        this(null, graphicsConfiguration);
        super.setFocusableWindowState(false);
    }

    public JWindow(Frame frame) {
        super(frame == null ? SwingUtilities.getSharedOwnerFrame() : frame);
        if (frame == null) {
            WindowListener windowListener = SwingUtilities.getSharedOwnerFrameShutdownListener();
            this.addWindowListener(windowListener);
        }
        this.windowInit();
    }

    public JWindow(Window window) {
        super(window == null ? SwingUtilities.getSharedOwnerFrame() : window);
        if (window == null) {
            WindowListener windowListener = SwingUtilities.getSharedOwnerFrameShutdownListener();
            this.addWindowListener(windowListener);
        }
        this.windowInit();
    }

    public JWindow(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window == null ? SwingUtilities.getSharedOwnerFrame() : window, graphicsConfiguration);
        if (window == null) {
            WindowListener windowListener = SwingUtilities.getSharedOwnerFrameShutdownListener();
            this.addWindowListener(windowListener);
        }
        this.windowInit();
    }

    protected void windowInit() {
        this.setLocale(JComponent.getDefaultLocale());
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
        SunToolkit.checkAndSetPolicy(this);
    }

    protected JRootPane createRootPane() {
        JRootPane jRootPane = new JRootPane();
        jRootPane.setOpaque(true);
        return jRootPane;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        TransferHandler transferHandler2 = this.transferHandler;
        this.transferHandler = transferHandler;
        SwingUtilities.installSwingDropTargetAsNecessary(this, this.transferHandler);
        this.firePropertyChange("transferHandler", transferHandler2, transferHandler);
    }

    @Override
    public TransferHandler getTransferHandler() {
        return this.transferHandler;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n);
        } else {
            super.addImpl(component, object, n);
        }
    }

    @Override
    public void remove(Component component) {
        if (component == this.rootPane) {
            super.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    @Override
    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    @Override
    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    @Override
    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    @Override
    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    @Override
    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    @Override
    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    @Override
    public Graphics getGraphics() {
        JComponent.getGraphicsInvoked(this);
        return super.getGraphics();
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (RepaintManager.HANDLE_TOP_LEVEL_PAINT) {
            RepaintManager.currentManager(this).addDirtyRegion(this, n, n2, n3, n4);
        } else {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    @Override
    protected String paramString() {
        String string = this.rootPaneCheckingEnabled ? "true" : "false";
        return super.paramString() + ",rootPaneCheckingEnabled=" + string;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJWindow();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJWindow
    extends Window.AccessibleAWTWindow {
        protected AccessibleJWindow() {
            super(JWindow.this);
        }
    }
}

