/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import sun.awt.image.GifFrame;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFetcher;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.NativeLibLoader;

public class GifImageDecoder
extends ImageDecoder {
    private static final boolean verbose = false;
    private static final int IMAGESEP = 44;
    private static final int EXBLOCK = 33;
    private static final int EX_GRAPHICS_CONTROL = 249;
    private static final int EX_COMMENT = 254;
    private static final int EX_APPLICATION = 255;
    private static final int TERMINATOR = 59;
    private static final int TRANSPARENCYMASK = 1;
    private static final int INTERLACEMASK = 64;
    private static final int COLORMAPMASK = 128;
    int num_global_colors;
    byte[] global_colormap;
    int trans_pixel = -1;
    IndexColorModel global_model;
    Hashtable props = new Hashtable();
    byte[] saved_image;
    IndexColorModel saved_model;
    int global_width;
    int global_height;
    int global_bgpixel;
    GifFrame curframe;
    private static final int normalflags = 30;
    private static final int interlaceflags = 29;
    private short[] prefix = new short[4096];
    private byte[] suffix = new byte[4096];
    private byte[] outCode = new byte[4097];

    public GifImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) {
        super(inputStreamImageSource, inputStream);
    }

    private static void error(String string) throws ImageFormatException {
        throw new ImageFormatException(string);
    }

    private int readBytes(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            try {
                int n3 = this.input.read(byArray, n, n2);
                if (n3 < 0) break;
                n += n3;
                n2 -= n3;
            }
            catch (IOException iOException) {
                break;
            }
        }
        return n2;
    }

    private static final int ExtractByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    private static final int ExtractWord(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceImage() throws IOException, ImageFormatException {
        try {
            this.readHeader();
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            int n4 = 0;
            int n5 = -1;
            boolean bl = false;
            boolean bl2 = false;
            while (!this.aborted) {
                int n6 = this.input.read();
                block12 : switch (n6) {
                    case 33: {
                        n6 = this.input.read();
                        switch (n6) {
                            case 249: {
                                byte[] byArray = new byte[6];
                                if (this.readBytes(byArray, 0, 6) != 0) {
                                    return;
                                }
                                if (byArray[0] != 4 || byArray[5] != 0) {
                                    return;
                                }
                                n5 = GifImageDecoder.ExtractWord(byArray, 2) * 10;
                                if (n5 > 0 && !bl2) {
                                    bl2 = true;
                                    ImageFetcher.startingAnimation();
                                }
                                n4 = byArray[1] >> 2 & 7;
                                if ((byArray[1] & 1) != 0) {
                                    this.trans_pixel = GifImageDecoder.ExtractByte(byArray, 4);
                                    break block12;
                                }
                                this.trans_pixel = -1;
                                break block12;
                            }
                            default: {
                                int n7;
                                boolean bl3 = false;
                                String string = "";
                                while ((n7 = this.input.read()) > 0) {
                                    byte[] byArray = new byte[n7];
                                    if (this.readBytes(byArray, 0, n7) != 0) {
                                        return;
                                    }
                                    if (n6 == 254) {
                                        string = string + new String(byArray, 0);
                                        continue;
                                    }
                                    if (n6 != 255) continue;
                                    if (bl3) {
                                        if (n7 == 3 && byArray[0] == 1) {
                                            if (bl) {
                                                GifImageDecoder.ExtractWord(byArray, 1);
                                            } else {
                                                n3 = GifImageDecoder.ExtractWord(byArray, 1);
                                                bl = true;
                                            }
                                        } else {
                                            bl3 = false;
                                        }
                                    }
                                    if (!"NETSCAPE2.0".equals(new String(byArray, 0))) continue;
                                    bl3 = true;
                                }
                                if (n6 == 254) {
                                    this.props.put("comment", string);
                                }
                                if (!bl3 || bl2) break block12;
                                bl2 = true;
                                ImageFetcher.startingAnimation();
                                break block12;
                            }
                            case -1: {
                                return;
                            }
                        }
                    }
                    case 44: {
                        if (!bl2) {
                            this.input.mark(0);
                        }
                        try {
                            if (!this.readImage(n == 0, n4, n5)) {
                                return;
                            }
                        }
                        catch (Exception exception) {
                            return;
                        }
                        ++n2;
                        ++n;
                        break;
                    }
                    default: {
                        if (n2 == 0) {
                            return;
                        }
                    }
                    case 59: {
                        if (n3 == 0 || n3-- >= 0) {
                            try {
                                if (this.curframe != null) {
                                    this.curframe.dispose();
                                    this.curframe = null;
                                }
                                this.input.reset();
                                this.saved_image = null;
                                this.saved_model = null;
                                n2 = 0;
                                break;
                            }
                            catch (IOException iOException) {
                                this.close();
                                return;
                            }
                        }
                        this.imageComplete(3, true);
                        return;
                    }
                }
            }
        }
        finally {
            this.close();
        }
    }

    private void readHeader() throws IOException, ImageFormatException {
        byte[] byArray = new byte[13];
        if (this.readBytes(byArray, 0, 13) != 0) {
            throw new IOException();
        }
        if (byArray[0] != 71 || byArray[1] != 73 || byArray[2] != 70) {
            GifImageDecoder.error("not a GIF file.");
        }
        this.global_width = GifImageDecoder.ExtractWord(byArray, 6);
        this.global_height = GifImageDecoder.ExtractWord(byArray, 8);
        int n = GifImageDecoder.ExtractByte(byArray, 10);
        if ((n & 0x80) == 0) {
            this.num_global_colors = 2;
            this.global_bgpixel = 0;
            this.global_colormap = new byte[6];
            this.global_colormap[2] = 0;
            this.global_colormap[1] = 0;
            this.global_colormap[0] = 0;
            this.global_colormap[5] = -1;
            this.global_colormap[4] = -1;
            this.global_colormap[3] = -1;
        } else {
            this.num_global_colors = 1 << (n & 7) + 1;
            this.global_bgpixel = GifImageDecoder.ExtractByte(byArray, 11);
            if (byArray[12] != 0) {
                this.props.put("aspectratio", "" + (double)(GifImageDecoder.ExtractByte(byArray, 12) + 15) / 64.0);
            }
            this.global_colormap = new byte[this.num_global_colors * 3];
            if (this.readBytes(this.global_colormap, 0, this.num_global_colors * 3) != 0) {
                throw new IOException();
            }
        }
        this.input.mark(Integer.MAX_VALUE);
    }

    private static native void initIDs();

    private native boolean parseImage(int var1, int var2, int var3, int var4, boolean var5, int var6, byte[] var7, byte[] var8, IndexColorModel var9);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int sendPixels(int n, int n2, int n3, int n4, byte[] byArray, ColorModel colorModel) {
        boolean bl;
        int n5;
        int n6;
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n2 + n4 > this.global_height) {
            n4 = this.global_height - n2;
        }
        if (n4 <= 0) {
            return 1;
        }
        if (n < 0) {
            n6 = -n;
            n3 += n;
            n5 = 0;
        } else {
            n6 = 0;
            n5 = n;
        }
        if (n5 + n3 > this.global_width) {
            n3 = this.global_width - n5;
        }
        if (n3 <= 0) {
            return 1;
        }
        int n7 = n6 + n3;
        int n8 = n2 * this.global_width + n5;
        boolean bl2 = bl = this.curframe.disposal_method == 1;
        if (this.trans_pixel >= 0 && !this.curframe.initialframe) {
            if (this.saved_image != null && colorModel.equals(this.saved_model)) {
                int n9 = n6;
                while (n9 < n7) {
                    byte by = byArray[n9];
                    if ((by & 0xFF) == this.trans_pixel) {
                        byArray[n9] = this.saved_image[n8];
                    } else if (bl) {
                        this.saved_image[n8] = by;
                    }
                    ++n9;
                    ++n8;
                }
                return this.setPixels(n5, n2, n3, n4, colorModel, byArray, n6, 0);
            }
            int n10 = -1;
            int n11 = 1;
            int n12 = n6;
            while (n12 < n7) {
                byte by = byArray[n12];
                if ((by & 0xFF) == this.trans_pixel) {
                    if (n10 >= 0 && (n11 = this.setPixels(n + n10, n2, n12 - n10, 1, colorModel, byArray, n10, 0)) == 0) break;
                    n10 = -1;
                } else {
                    if (n10 < 0) {
                        n10 = n12;
                    }
                    if (bl) {
                        this.saved_image[n8] = by;
                    }
                }
                ++n12;
                ++n8;
            }
            if (n10 < 0) return n11;
            return this.setPixels(n + n10, n2, n7 - n10, 1, colorModel, byArray, n10, 0);
        }
        if (!bl) return this.setPixels(n5, n2, n3, n4, colorModel, byArray, n6, 0);
        System.arraycopy(byArray, n6, this.saved_image, n8, n3);
        return this.setPixels(n5, n2, n3, n4, colorModel, byArray, n6, 0);
    }

    private boolean readImage(boolean bl, int n, int n2) throws IOException {
        int n3;
        byte[] byArray;
        int n4;
        if (this.curframe != null && !this.curframe.dispose()) {
            this.abort();
            return false;
        }
        long l = 0L;
        byte[] byArray2 = new byte[259];
        if (this.readBytes(byArray2, 0, 10) != 0) {
            throw new IOException();
        }
        int n5 = GifImageDecoder.ExtractWord(byArray2, 0);
        int n6 = GifImageDecoder.ExtractWord(byArray2, 2);
        int n7 = GifImageDecoder.ExtractWord(byArray2, 4);
        int n8 = GifImageDecoder.ExtractWord(byArray2, 6);
        if (n7 == 0 && this.global_width != 0) {
            n7 = this.global_width - n5;
        }
        if (n8 == 0 && this.global_height != 0) {
            n8 = this.global_height - n6;
        }
        boolean bl2 = (byArray2[8] & 0x40) != 0;
        IndexColorModel indexColorModel = this.global_model;
        if ((byArray2[8] & 0x80) != 0) {
            n4 = 1 << (byArray2[8] & 7) + 1;
            byArray = new byte[n4 * 3];
            byArray[0] = byArray2[9];
            if (this.readBytes(byArray, 1, n4 * 3 - 1) != 0) {
                throw new IOException();
            }
            if (this.readBytes(byArray2, 9, 1) != 0) {
                throw new IOException();
            }
            if (this.trans_pixel >= n4) {
                n4 = this.trans_pixel + 1;
                byArray = GifImageDecoder.grow_colormap(byArray, n4);
            }
            indexColorModel = new IndexColorModel(8, n4, byArray, 0, false, this.trans_pixel);
        } else if (indexColorModel == null || this.trans_pixel != indexColorModel.getTransparentPixel()) {
            if (this.trans_pixel >= this.num_global_colors) {
                this.num_global_colors = this.trans_pixel + 1;
                this.global_colormap = GifImageDecoder.grow_colormap(this.global_colormap, this.num_global_colors);
            }
            this.global_model = indexColorModel = new IndexColorModel(8, this.num_global_colors, this.global_colormap, 0, false, this.trans_pixel);
        }
        if (bl) {
            if (this.global_width == 0) {
                this.global_width = n7;
            }
            if (this.global_height == 0) {
                this.global_height = n8;
            }
            this.setDimensions(this.global_width, this.global_height);
            this.setProperties(this.props);
            this.setColorModel(indexColorModel);
            this.headerComplete();
        }
        if (n == 1 && this.saved_image == null) {
            this.saved_image = new byte[this.global_width * this.global_height];
            if (n8 < this.global_height && indexColorModel != null && (n4 = (int)((byte)indexColorModel.getTransparentPixel())) >= 0) {
                byArray = new byte[this.global_width];
                for (n3 = 0; n3 < this.global_width; ++n3) {
                    byArray[n3] = n4;
                }
                this.setPixels(0, 0, this.global_width, n6, (ColorModel)indexColorModel, byArray, 0, 0);
                this.setPixels(0, n6 + n8, this.global_width, this.global_height - n8 - n6, (ColorModel)indexColorModel, byArray, 0, 0);
            }
        }
        n4 = bl2 ? 29 : 30;
        this.setHints(n4);
        this.curframe = new GifFrame(this, n, n2, this.curframe == null, indexColorModel, n5, n6, n7, n8);
        byArray = new byte[n7];
        n3 = GifImageDecoder.ExtractByte(byArray2, 9);
        if (n3 >= 12) {
            return false;
        }
        boolean bl3 = this.parseImage(n5, n6, n7, n8, bl2, n3, byArray2, byArray, indexColorModel);
        if (!bl3) {
            this.abort();
        }
        return bl3;
    }

    public static byte[] grow_colormap(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n * 3];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    static {
        NativeLibLoader.loadLibraries();
        GifImageDecoder.initIDs();
    }
}

