/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.peer.DialogPeer;
import java.util.List;
import java.util.Vector;
import sun.awt.AWTAccessor;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;

class XDialogPeer
extends XDecoratedPeer
implements DialogPeer {
    private Boolean undecorated;

    XDialogPeer(Dialog dialog) {
        super(dialog);
    }

    @Override
    public void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        Dialog dialog = (Dialog)this.target;
        this.undecorated = dialog.isUndecorated();
        boolean bl = this.winAttr.nativeDecor = !dialog.isUndecorated();
        this.winAttr.decorations = this.winAttr.nativeDecor ? XWindowAttributesData.AWT_DECOR_ALL : XWindowAttributesData.AWT_DECOR_NONE;
        this.winAttr.functions = 1;
        this.winAttr.isResizable = true;
        this.winAttr.initialResizability = dialog.isResizable();
        this.winAttr.title = dialog.getTitle();
        this.winAttr.initialState = XWindowAttributesData.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean bl) {
        XToolkit.awtLock();
        try {
            Dialog dialog = (Dialog)this.target;
            if (bl) {
                if (dialog.getModalityType() != Dialog.ModalityType.MODELESS && !this.isModalBlocked()) {
                    XBaseWindow.ungrabInput();
                }
            } else {
                XDialogPeer.restoreTransientFor(this);
                this.prevTransientFor = null;
                this.nextTransientFor = null;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        super.setVisible(bl);
    }

    @Override
    boolean isTargetUndecorated() {
        if (this.undecorated != null) {
            return this.undecorated;
        }
        return ((Dialog)this.target).isUndecorated();
    }

    @Override
    int getDecorations() {
        int n = super.getDecorations();
        n = (n & 1) != 0 ? (n |= 0x60) : (n &= 0xFFFFFF9F);
        return n;
    }

    @Override
    int getFunctions() {
        int n = super.getFunctions();
        n = (n & 1) != 0 ? (n |= 0x18) : (n &= 0xFFFFFFE7);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockWindows(List<Window> list) {
        Vector<XWindowPeer> vector = null;
        XToolkit.awtLock();
        try {
            vector = XWindowPeer.collectJavaToplevels();
            for (Window window : list) {
                XWindowPeer xWindowPeer = (XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(window);
                if (xWindowPeer == null) continue;
                xWindowPeer.setModalBlocked((Dialog)this.target, true, vector);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isFocusedWindowModalBlocker() {
        Window window = XKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow();
        XWindowPeer xWindowPeer = null;
        xWindowPeer = window != null ? (XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(window) : XDialogPeer.getNativeFocusedWindowPeer();
        Object object = this.getStateLock();
        synchronized (object) {
            if (xWindowPeer != null && xWindowPeer.modalBlocker == this.target) {
                return true;
            }
        }
        return super.isFocusedWindowModalBlocker();
    }
}

