/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.IllegalComponentStateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import sun.awt.DisplayChangedListener;
import sun.util.logging.PlatformLogger;

public class SunDisplayChanger {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.multiscreen.SunDisplayChanger");
    private Map listeners = Collections.synchronizedMap(new WeakHashMap(1));

    public void add(DisplayChangedListener displayChangedListener) {
        if (log.isLoggable(500) && displayChangedListener == null) {
            log.fine("Assertion (theListener != null) failed");
        }
        if (log.isLoggable(400)) {
            log.finer("Adding listener: " + displayChangedListener);
        }
        this.listeners.put(displayChangedListener, null);
    }

    public void remove(DisplayChangedListener displayChangedListener) {
        if (log.isLoggable(500) && displayChangedListener == null) {
            log.fine("Assertion (theListener != null) failed");
        }
        if (log.isLoggable(400)) {
            log.finer("Removing listener: " + displayChangedListener);
        }
        this.listeners.remove(displayChangedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        HashMap hashMap;
        if (log.isLoggable(300)) {
            log.finest("notifyListeners");
        }
        Map map = this.listeners;
        synchronized (map) {
            hashMap = new HashMap(this.listeners);
        }
        Set set = hashMap.keySet();
        for (DisplayChangedListener displayChangedListener : set) {
            try {
                if (log.isLoggable(300)) {
                    log.finest("displayChanged for listener: " + displayChangedListener);
                }
                displayChangedListener.displayChanged();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                this.listeners.remove(displayChangedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPaletteChanged() {
        HashMap hashMap;
        if (log.isLoggable(300)) {
            log.finest("notifyPaletteChanged");
        }
        Map map = this.listeners;
        synchronized (map) {
            hashMap = new HashMap(this.listeners);
        }
        Set set = hashMap.keySet();
        for (DisplayChangedListener displayChangedListener : set) {
            try {
                if (log.isLoggable(300)) {
                    log.finest("paletteChanged for listener: " + displayChangedListener);
                }
                displayChangedListener.paletteChanged();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                this.listeners.remove(displayChangedListener);
            }
        }
    }
}

