-- test on normal numbers (results in 15)
sarr = { 1, 2, 3, 4, 5 }
res = 0
map(sarr, function(e)
	   res = res + e
end)
print(res)

-- add array of ECP points
rng = RNG.new()
arr = { ECP.hashtopoint(rng:octet(32)),
		ECP.hashtopoint(rng:octet(32)),
		ECP.hashtopoint(rng:octet(32)),
		ECP.hashtopoint(rng:octet(32)),
		ECP.hashtopoint(rng:octet(32)) }
res = ECP.generator()
map(arr,function(e)
	   res = ECP.add(res,e)
end)
print(res)

-- concatenate and hash an array of ecp points
concat = OCTET.new()
map(arr,function(e)
	   concat = concat .. e:octet()
end)
print(arr[1]:octet())
print(concat)
print("hash: ")
print(sha512(concat))

-- concatenate and hash a mixed array of ECP and ECP2 points
arr = { ECP2.hashtopoint(rng:octet(32)),
		ECP.hashtopoint(rng:octet(32)),
		ECP2.hashtopoint(rng:octet(32)),
		ECP.hashtopoint(rng:octet(32)),
		ECP2.hashtopoint(rng:octet(32)),
		rng:big(), rng:big()
}
concat = OCTET.new()
map(arr,function(e)
	   t = type(e)
	   if(t == "zenroom.octet") then
		  concat = concat .. e
	   elseif(t == "zenroom.big") then
		  concat = concat .. e:octet()
	   elseif(t == "zenroom.ecp") then
		  concat = concat .. e:octet()
	   elseif(t == "zenroom.ecp2") then
		  concat = concat .. e:octet()
	   end
end)
assert(concat == OCTET.serialize(arr))
