/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.policytool;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.MessageFormat;
import sun.security.provider.PolicyParser;
import sun.security.tools.policytool.PolicyTool;
import sun.security.tools.policytool.TaggedList;
import sun.security.tools.policytool.ToolDialog;
import sun.security.tools.policytool.ToolWindow;

class NewPolicyPrinOKButtonListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;
    private ToolDialog listDialog;
    private ToolDialog infoDialog;
    private boolean edit;

    NewPolicyPrinOKButtonListener(PolicyTool policyTool, ToolWindow toolWindow, ToolDialog toolDialog, ToolDialog toolDialog2, boolean bl) {
        this.tool = policyTool;
        this.tw = toolWindow;
        this.listDialog = toolDialog;
        this.infoDialog = toolDialog2;
        this.edit = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            PolicyParser.PrincipalEntry principalEntry = this.infoDialog.getPrinFromDialog();
            if (principalEntry != null) {
                Object object;
                try {
                    this.tool.verifyPrincipal(principalEntry.getPrincipalClass(), principalEntry.getPrincipalName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object = new MessageFormat(PolicyTool.rb.getString("Warning.Class.not.found.class"));
                    Object[] objectArray = new Object[]{principalEntry.getPrincipalClass()};
                    this.tool.warnings.addElement(((Format)object).format(objectArray));
                    this.tw.displayStatusDialog(this.infoDialog, ((Format)object).format(objectArray));
                }
                TaggedList taggedList = (TaggedList)this.listDialog.getComponent(6);
                object = ToolDialog.PrincipalEntryToUserFriendlyString(principalEntry);
                if (this.edit) {
                    int n = taggedList.getSelectedIndex();
                    taggedList.replaceTaggedItem((String)object, principalEntry, n);
                } else {
                    taggedList.addTaggedItem((String)object, principalEntry);
                }
            }
            this.infoDialog.dispose();
        }
        catch (Exception exception) {
            this.tw.displayErrorDialog((Window)this.infoDialog, exception);
        }
    }
}

