/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jmx.defaults.JmxProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;

public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    private Number highThreshold = INTEGER_ZERO;
    private Number lowThreshold = INTEGER_ZERO;
    private boolean notifyHigh = false;
    private boolean notifyLow = false;
    private boolean differenceMode = false;
    private static final String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.gauge.high", "jmx.monitor.gauge.low"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the GaugeMonitor MBean")};
    private static final int RISING = 0;
    private static final int FALLING = 1;
    private static final int RISING_OR_FALLING = 2;

    @Override
    public synchronized void start() {
        if (this.isActive()) {
            ((Logger)((Object)JmxProperties.MONITOR_LOGGER)).logp(Level.FINER, GaugeMonitor.class.getName(), "start", "the monitor is already active");
            return;
        }
        for (Monitor.ObservedObject observedObject : this.observedObjects) {
            GaugeMonitorObservedObject gaugeMonitorObservedObject = (GaugeMonitorObservedObject)observedObject;
            gaugeMonitorObservedObject.setStatus(2);
            gaugeMonitorObservedObject.setPreviousScanGauge(null);
        }
        this.doStart();
    }

    @Override
    public synchronized void stop() {
        this.doStop();
    }

    @Override
    public synchronized Number getDerivedGauge(ObjectName objectName) {
        return (Number)super.getDerivedGauge(objectName);
    }

    @Override
    public synchronized long getDerivedGaugeTimeStamp(ObjectName objectName) {
        return super.getDerivedGaugeTimeStamp(objectName);
    }

    @Override
    @Deprecated
    public synchronized Number getDerivedGauge() {
        if (this.observedObjects.isEmpty()) {
            return null;
        }
        return (Number)((Monitor.ObservedObject)this.observedObjects.get(0)).getDerivedGauge();
    }

    @Override
    @Deprecated
    public synchronized long getDerivedGaugeTimeStamp() {
        if (this.observedObjects.isEmpty()) {
            return 0L;
        }
        return ((Monitor.ObservedObject)this.observedObjects.get(0)).getDerivedGaugeTimeStamp();
    }

    @Override
    public synchronized Number getHighThreshold() {
        return this.highThreshold;
    }

    @Override
    public synchronized Number getLowThreshold() {
        return this.lowThreshold;
    }

    @Override
    public synchronized void setThresholds(Number number, Number number2) throws IllegalArgumentException {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("Null threshold value");
        }
        if (number.getClass() != number2.getClass()) {
            throw new IllegalArgumentException("Different type threshold values");
        }
        if (this.isFirstStrictlyGreaterThanLast(number2, number, number.getClass().getName())) {
            throw new IllegalArgumentException("High threshold less than low threshold");
        }
        if (this.highThreshold.equals(number) && this.lowThreshold.equals(number2)) {
            return;
        }
        this.highThreshold = number;
        this.lowThreshold = number2;
        int n = 0;
        for (Monitor.ObservedObject observedObject : this.observedObjects) {
            this.resetAlreadyNotified(observedObject, n++, 16);
            GaugeMonitorObservedObject gaugeMonitorObservedObject = (GaugeMonitorObservedObject)observedObject;
            gaugeMonitorObservedObject.setStatus(2);
        }
    }

    @Override
    public synchronized boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    @Override
    public synchronized void setNotifyHigh(boolean bl) {
        if (this.notifyHigh == bl) {
            return;
        }
        this.notifyHigh = bl;
    }

    @Override
    public synchronized boolean getNotifyLow() {
        return this.notifyLow;
    }

    @Override
    public synchronized void setNotifyLow(boolean bl) {
        if (this.notifyLow == bl) {
            return;
        }
        this.notifyLow = bl;
    }

    @Override
    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    @Override
    public synchronized void setDifferenceMode(boolean bl) {
        if (this.differenceMode == bl) {
            return;
        }
        this.differenceMode = bl;
        for (Monitor.ObservedObject observedObject : this.observedObjects) {
            GaugeMonitorObservedObject gaugeMonitorObservedObject = (GaugeMonitorObservedObject)observedObject;
            gaugeMonitorObservedObject.setStatus(2);
            gaugeMonitorObservedObject.setPreviousScanGauge(null);
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return (MBeanNotificationInfo[])notifsInfo.clone();
    }

    private synchronized boolean updateDerivedGauge(Object object, GaugeMonitorObservedObject gaugeMonitorObservedObject) {
        boolean bl;
        if (this.differenceMode) {
            if (gaugeMonitorObservedObject.getPreviousScanGauge() != null) {
                this.setDerivedGaugeWithDifference((Number)object, gaugeMonitorObservedObject);
                bl = true;
            } else {
                bl = false;
            }
            gaugeMonitorObservedObject.setPreviousScanGauge((Number)object);
        } else {
            gaugeMonitorObservedObject.setDerivedGauge((Number)object);
            bl = true;
        }
        return bl;
    }

    private synchronized MonitorNotification updateNotifications(GaugeMonitorObservedObject gaugeMonitorObservedObject) {
        MonitorNotification monitorNotification = null;
        if (gaugeMonitorObservedObject.getStatus() == 2) {
            if (this.isFirstGreaterThanLast((Number)gaugeMonitorObservedObject.getDerivedGauge(), this.highThreshold, gaugeMonitorObservedObject.getType())) {
                if (this.notifyHigh) {
                    monitorNotification = new MonitorNotification("jmx.monitor.gauge.high", this, 0L, 0L, "", null, null, null, this.highThreshold);
                }
                gaugeMonitorObservedObject.setStatus(1);
            } else if (this.isFirstGreaterThanLast(this.lowThreshold, (Number)gaugeMonitorObservedObject.getDerivedGauge(), gaugeMonitorObservedObject.getType())) {
                if (this.notifyLow) {
                    monitorNotification = new MonitorNotification("jmx.monitor.gauge.low", this, 0L, 0L, "", null, null, null, this.lowThreshold);
                }
                gaugeMonitorObservedObject.setStatus(0);
            }
        } else if (gaugeMonitorObservedObject.getStatus() == 0) {
            if (this.isFirstGreaterThanLast((Number)gaugeMonitorObservedObject.getDerivedGauge(), this.highThreshold, gaugeMonitorObservedObject.getType())) {
                if (this.notifyHigh) {
                    monitorNotification = new MonitorNotification("jmx.monitor.gauge.high", this, 0L, 0L, "", null, null, null, this.highThreshold);
                }
                gaugeMonitorObservedObject.setStatus(1);
            }
        } else if (gaugeMonitorObservedObject.getStatus() == 1 && this.isFirstGreaterThanLast(this.lowThreshold, (Number)gaugeMonitorObservedObject.getDerivedGauge(), gaugeMonitorObservedObject.getType())) {
            if (this.notifyLow) {
                monitorNotification = new MonitorNotification("jmx.monitor.gauge.low", this, 0L, 0L, "", null, null, null, this.lowThreshold);
            }
            gaugeMonitorObservedObject.setStatus(0);
        }
        return monitorNotification;
    }

    private synchronized void setDerivedGaugeWithDifference(Number number, GaugeMonitorObservedObject gaugeMonitorObservedObject) {
        Number number2;
        Number number3 = gaugeMonitorObservedObject.getPreviousScanGauge();
        switch (gaugeMonitorObservedObject.getType()) {
            case INTEGER: {
                number2 = (Integer)number - (Integer)number3;
                break;
            }
            case BYTE: {
                number2 = (byte)((Byte)number - (Byte)number3);
                break;
            }
            case SHORT: {
                number2 = (short)((Short)number - (Short)number3);
                break;
            }
            case LONG: {
                number2 = (Long)number - (Long)number3;
                break;
            }
            case FLOAT: {
                number2 = Float.valueOf(((Float)number).floatValue() - ((Float)number3).floatValue());
                break;
            }
            case DOUBLE: {
                number2 = (Double)number - (Double)number3;
                break;
            }
            default: {
                ((Logger)((Object)JmxProperties.MONITOR_LOGGER)).logp(Level.FINEST, GaugeMonitor.class.getName(), "setDerivedGaugeWithDifference", "the threshold type is invalid");
                return;
            }
        }
        gaugeMonitorObservedObject.setDerivedGauge(number2);
    }

    private boolean isFirstGreaterThanLast(Number number, Number number2, Monitor.NumericalType numericalType) {
        switch (numericalType) {
            case INTEGER: 
            case BYTE: 
            case SHORT: 
            case LONG: {
                return number.longValue() >= number2.longValue();
            }
            case FLOAT: 
            case DOUBLE: {
                return number.doubleValue() >= number2.doubleValue();
            }
        }
        ((Logger)((Object)JmxProperties.MONITOR_LOGGER)).logp(Level.FINEST, GaugeMonitor.class.getName(), "isFirstGreaterThanLast", "the threshold type is invalid");
        return false;
    }

    private boolean isFirstStrictlyGreaterThanLast(Number number, Number number2, String string) {
        if (string.equals("java.lang.Integer") || string.equals("java.lang.Byte") || string.equals("java.lang.Short") || string.equals("java.lang.Long")) {
            return number.longValue() > number2.longValue();
        }
        if (string.equals("java.lang.Float") || string.equals("java.lang.Double")) {
            return number.doubleValue() > number2.doubleValue();
        }
        ((Logger)((Object)JmxProperties.MONITOR_LOGGER)).logp(Level.FINEST, GaugeMonitor.class.getName(), "isFirstStrictlyGreaterThanLast", "the threshold type is invalid");
        return false;
    }

    @Override
    Monitor.ObservedObject createObservedObject(ObjectName objectName) {
        GaugeMonitorObservedObject gaugeMonitorObservedObject = new GaugeMonitorObservedObject(objectName);
        gaugeMonitorObservedObject.setStatus(2);
        gaugeMonitorObservedObject.setPreviousScanGauge(null);
        return gaugeMonitorObservedObject;
    }

    @Override
    synchronized boolean isComparableTypeValid(ObjectName objectName, String string, Comparable<?> comparable) {
        GaugeMonitorObservedObject gaugeMonitorObservedObject = (GaugeMonitorObservedObject)this.getObservedObject(objectName);
        if (gaugeMonitorObservedObject == null) {
            return false;
        }
        if (comparable instanceof Integer) {
            gaugeMonitorObservedObject.setType(Monitor.NumericalType.INTEGER);
        } else if (comparable instanceof Byte) {
            gaugeMonitorObservedObject.setType(Monitor.NumericalType.BYTE);
        } else if (comparable instanceof Short) {
            gaugeMonitorObservedObject.setType(Monitor.NumericalType.SHORT);
        } else if (comparable instanceof Long) {
            gaugeMonitorObservedObject.setType(Monitor.NumericalType.LONG);
        } else if (comparable instanceof Float) {
            gaugeMonitorObservedObject.setType(Monitor.NumericalType.FLOAT);
        } else if (comparable instanceof Double) {
            gaugeMonitorObservedObject.setType(Monitor.NumericalType.DOUBLE);
        } else {
            return false;
        }
        return true;
    }

    @Override
    synchronized Comparable<?> getDerivedGaugeFromComparable(ObjectName objectName, String string, Comparable<?> comparable) {
        GaugeMonitorObservedObject gaugeMonitorObservedObject = (GaugeMonitorObservedObject)this.getObservedObject(objectName);
        if (gaugeMonitorObservedObject == null) {
            return null;
        }
        gaugeMonitorObservedObject.setDerivedGaugeValid(this.updateDerivedGauge(comparable, gaugeMonitorObservedObject));
        return (Comparable)gaugeMonitorObservedObject.getDerivedGauge();
    }

    @Override
    synchronized void onErrorNotification(MonitorNotification monitorNotification) {
        GaugeMonitorObservedObject gaugeMonitorObservedObject = (GaugeMonitorObservedObject)this.getObservedObject(monitorNotification.getObservedObject());
        if (gaugeMonitorObservedObject == null) {
            return;
        }
        gaugeMonitorObservedObject.setStatus(2);
        gaugeMonitorObservedObject.setPreviousScanGauge(null);
    }

    @Override
    synchronized MonitorNotification buildAlarmNotification(ObjectName objectName, String string, Comparable<?> comparable) {
        GaugeMonitorObservedObject gaugeMonitorObservedObject = (GaugeMonitorObservedObject)this.getObservedObject(objectName);
        if (gaugeMonitorObservedObject == null) {
            return null;
        }
        MonitorNotification monitorNotification = gaugeMonitorObservedObject.getDerivedGaugeValid() ? this.updateNotifications(gaugeMonitorObservedObject) : null;
        return monitorNotification;
    }

    @Override
    synchronized boolean isThresholdTypeValid(ObjectName objectName, String string, Comparable<?> comparable) {
        GaugeMonitorObservedObject gaugeMonitorObservedObject = (GaugeMonitorObservedObject)this.getObservedObject(objectName);
        if (gaugeMonitorObservedObject == null) {
            return false;
        }
        Class<? extends Number> clazz = GaugeMonitor.classForType(gaugeMonitorObservedObject.getType());
        return GaugeMonitor.isValidForType(this.highThreshold, clazz) && GaugeMonitor.isValidForType(this.lowThreshold, clazz);
    }

    static class GaugeMonitorObservedObject
    extends Monitor.ObservedObject {
        private boolean derivedGaugeValid;
        private Monitor.NumericalType type;
        private Number previousScanGauge;
        private int status;

        public GaugeMonitorObservedObject(ObjectName objectName) {
            super(objectName);
        }

        public final synchronized boolean getDerivedGaugeValid() {
            return this.derivedGaugeValid;
        }

        public final synchronized void setDerivedGaugeValid(boolean bl) {
            this.derivedGaugeValid = bl;
        }

        public final synchronized Monitor.NumericalType getType() {
            return this.type;
        }

        public final synchronized void setType(Monitor.NumericalType numericalType) {
            this.type = numericalType;
        }

        public final synchronized Number getPreviousScanGauge() {
            return this.previousScanGauge;
        }

        public final synchronized void setPreviousScanGauge(Number number) {
            this.previousScanGauge = number;
        }

        public final synchronized int getStatus() {
            return this.status;
        }

        public final synchronized void setStatus(int n) {
            this.status = n;
        }
    }
}

