/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.pipe.BufferedPaints;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

abstract class XRPaints {
    static XRCompositeManager xrCompMan;
    static final XRGradient xrGradient;
    static final XRLinearGradient xrLinearGradient;
    static final XRRadialGradient xrRadialGradient;
    static final XRTexture xrTexture;

    XRPaints() {
    }

    public static void register(XRCompositeManager xRCompositeManager) {
        xrCompMan = xRCompositeManager;
    }

    private static XRPaints getXRPaint(SunGraphics2D sunGraphics2D) {
        switch (sunGraphics2D.paintState) {
            case 2: {
                return xrGradient;
            }
            case 3: {
                return xrLinearGradient;
            }
            case 4: {
                return xrRadialGradient;
            }
            case 5: {
                return xrTexture;
            }
        }
        return null;
    }

    static boolean isValid(SunGraphics2D sunGraphics2D) {
        XRPaints xRPaints = XRPaints.getXRPaint(sunGraphics2D);
        return xRPaints != null && xRPaints.isPaintValid(sunGraphics2D);
    }

    static void setPaint(SunGraphics2D sunGraphics2D, Paint paint) {
        XRPaints xRPaints = XRPaints.getXRPaint(sunGraphics2D);
        if (xRPaints != null) {
            xRPaints.setXRPaint(sunGraphics2D, paint);
        }
    }

    abstract boolean isPaintValid(SunGraphics2D var1);

    abstract void setXRPaint(SunGraphics2D var1, Paint var2);

    public int getGradientLength(Point2D point2D, Point2D point2D2) {
        double d = Math.max(point2D.getX(), point2D2.getX()) - Math.min(point2D.getX(), point2D2.getX());
        double d2 = Math.max(point2D.getY(), point2D2.getY()) - Math.min(point2D.getY(), point2D2.getY());
        return (int)Math.ceil(Math.sqrt(d * d + d2 * d2));
    }

    public int[] convertToIntArgbPixels(Color[] colorArray, boolean bl) {
        int[] nArray = new int[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            nArray[i] = this.colorToIntArgbPixel(colorArray[i], bl);
        }
        return nArray;
    }

    public int colorToIntArgbPixel(Color color, boolean bl) {
        int n = color.getRGB();
        int n2 = n >>> 24;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        if (bl) {
            n3 = BufferedPaints.convertSRGBtoLinearRGB(n3);
            n4 = BufferedPaints.convertSRGBtoLinearRGB(n4);
            n5 = BufferedPaints.convertSRGBtoLinearRGB(n5);
        }
        n2 = (int)((float)n2 * xrCompMan.getExtraAlpha());
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    static {
        xrGradient = new XRGradient();
        xrLinearGradient = new XRLinearGradient();
        xrRadialGradient = new XRRadialGradient();
        xrTexture = new XRTexture();
    }

    private static class XRTexture
    extends XRPaints {
        private XRTexture() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            TexturePaint texturePaint = (TexturePaint)sunGraphics2D.paint;
            BufferedImage bufferedImage = texturePaint.getImage();
            XRSurfaceData xRSurfaceData = (XRSurfaceData)sunGraphics2D.getDestSurface();
            SurfaceData surfaceData = xRSurfaceData.getSourceSurfaceData(bufferedImage, 0, CompositeType.SrcOver, null);
            return surfaceData instanceof XRSurfaceData || (surfaceData = xRSurfaceData.getSourceSurfaceData(bufferedImage, 0, CompositeType.SrcOver, null)) instanceof XRSurfaceData;
        }

        @Override
        void setXRPaint(SunGraphics2D sunGraphics2D, Paint paint) {
            SurfaceData surfaceData = sunGraphics2D.surfaceData;
            TexturePaint texturePaint = (TexturePaint)paint;
            BufferedImage bufferedImage = texturePaint.getImage();
            SurfaceData surfaceData2 = surfaceData.getSourceSurfaceData(bufferedImage, 0, CompositeType.SrcOver, null);
            if (!(surfaceData2 instanceof XRSurfaceData) && !((surfaceData2 = surfaceData.getSourceSurfaceData(texturePaint.getImage(), 0, CompositeType.SrcOver, null)) instanceof XRSurfaceData)) {
                throw new InternalError("Surface not cachable");
            }
            XRSurfaceData xRSurfaceData = (XRSurfaceData)surfaceData2;
            AffineTransform affineTransform = (AffineTransform)sunGraphics2D.transform.clone();
            Rectangle2D rectangle2D = texturePaint.getAnchorRect();
            affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
            affineTransform.scale(rectangle2D.getWidth() / (double)bufferedImage.getWidth(), rectangle2D.getHeight() / (double)bufferedImage.getHeight());
            try {
                affineTransform.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                affineTransform.setToIdentity();
            }
            xRSurfaceData.validateAsSource(affineTransform, 1, XRUtils.ATransOpToXRQuality(sunGraphics2D.interpolationType));
            xrCompMan.setTexturePaint((XRSurfaceData)surfaceData2);
        }
    }

    private static class XRRadialGradient
    extends XRPaints {
        private XRRadialGradient() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            RadialGradientPaint radialGradientPaint = (RadialGradientPaint)sunGraphics2D.paint;
            return radialGradientPaint.getFocusPoint().equals(radialGradientPaint.getCenterPoint());
        }

        @Override
        void setXRPaint(SunGraphics2D sunGraphics2D, Paint paint) {
            RadialGradientPaint radialGradientPaint = (RadialGradientPaint)paint;
            boolean bl = radialGradientPaint.getColorSpace() == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB;
            Color[] colorArray = radialGradientPaint.getColors();
            Point2D point2D = radialGradientPaint.getCenterPoint();
            Point2D point2D2 = radialGradientPaint.getFocusPoint();
            int n = XRUtils.getRepeatForCycleMethod(radialGradientPaint.getCycleMethod());
            float[] fArray = radialGradientPaint.getFractions();
            int[] nArray = this.convertToIntArgbPixels(colorArray, bl);
            float f = radialGradientPaint.getRadius();
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX();
            double d4 = point2D2.getY();
            AffineTransform affineTransform = radialGradientPaint.getTransform();
            affineTransform.preConcatenate(sunGraphics2D.transform);
            point2D2 = affineTransform.transform(point2D2, point2D2);
            affineTransform.translate(d, d2);
            affineTransform.rotate(d3 - d, d4 - d2);
            try {
                affineTransform.invert();
            }
            catch (Exception exception) {
                affineTransform.setToScale(0.0, 0.0);
            }
            point2D2 = affineTransform.transform(point2D2, point2D2);
            d3 = Math.min(point2D2.getX(), 0.99);
            XRBackend xRBackend = xrCompMan.getBackend();
            int n2 = xRBackend.createRadialGradient(new Point2D.Float(0.0f, 0.0f), new Point2D.Float(0.0f, 0.0f), 0.0f, f, fArray, nArray, n, affineTransform);
            xrCompMan.setGradientPaint(new XRSurfaceData.XRInternalSurfaceData(xRBackend, n2, affineTransform));
        }
    }

    private static class XRLinearGradient
    extends XRPaints {
        private XRLinearGradient() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            return true;
        }

        @Override
        void setXRPaint(SunGraphics2D sunGraphics2D, Paint paint) {
            LinearGradientPaint linearGradientPaint = (LinearGradientPaint)paint;
            boolean bl = linearGradientPaint.getColorSpace() == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB;
            Color[] colorArray = linearGradientPaint.getColors();
            Point2D point2D = linearGradientPaint.getStartPoint();
            Point2D point2D2 = linearGradientPaint.getEndPoint();
            AffineTransform affineTransform = linearGradientPaint.getTransform();
            affineTransform.preConcatenate(sunGraphics2D.transform);
            int n = XRUtils.getRepeatForCycleMethod(linearGradientPaint.getCycleMethod());
            float[] fArray = linearGradientPaint.getFractions();
            int[] nArray = this.convertToIntArgbPixels(colorArray, bl);
            try {
                affineTransform.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
            XRBackend xRBackend = xrCompMan.getBackend();
            int n2 = xRBackend.createLinearGradient(point2D, point2D2, fArray, nArray, n, affineTransform);
            xrCompMan.setGradientPaint(new XRSurfaceData.XRInternalSurfaceData(xRBackend, n2, affineTransform));
        }
    }

    private static class XRGradient
    extends XRPaints {
        private XRGradient() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sunGraphics2D) {
            return true;
        }

        @Override
        void setXRPaint(SunGraphics2D sunGraphics2D, Paint paint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            int[] nArray = this.convertToIntArgbPixels(new Color[]{gradientPaint.getColor1(), gradientPaint.getColor2()}, false);
            float[] fArray = new float[]{0.0f, 1.0f};
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            AffineTransform affineTransform = (AffineTransform)sunGraphics2D.transform.clone();
            try {
                affineTransform.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                affineTransform.setToIdentity();
            }
            int n = gradientPaint.isCyclic() ? 3 : 2;
            XRBackend xRBackend = xrCompMan.getBackend();
            int n2 = xRBackend.createLinearGradient(point2D, point2D2, fArray, nArray, n, affineTransform);
            xrCompMan.setGradientPaint(new XRSurfaceData.XRInternalSurfaceData(xRBackend, n2, affineTransform));
        }
    }
}

