/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthRootPaneUI
extends BasicRootPaneUI
implements SynthUI {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthRootPaneUI();
    }

    @Override
    protected void installDefaults(JRootPane jRootPane) {
        this.updateStyle(jRootPane);
    }

    @Override
    protected void uninstallDefaults(JRootPane jRootPane) {
        SynthContext synthContext = this.getContext(jRootPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(jComponent, this.style, n);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private void updateStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle && synthStyle != null) {
            this.uninstallKeyboardActions((JRootPane)jComponent);
            this.installKeyboardActions((JRootPane)jComponent);
        }
        synthContext.dispose();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintRootPaneBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintRootPaneBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JRootPane)propertyChangeEvent.getSource());
        }
        super.propertyChange(propertyChangeEvent);
    }
}

