/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;

public class Role
implements Serializable {
    private static final long oldSerialVersionUID = -1959486389343113026L;
    private static final long newSerialVersionUID = -279985518429862552L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myName", String.class), new ObjectStreamField("myObjNameList", ArrayList.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", String.class), new ObjectStreamField("objectNameList", List.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private String name = null;
    private List<ObjectName> objectNameList = new ArrayList<ObjectName>();

    public Role(String string, List<ObjectName> list) throws IllegalArgumentException {
        if (string == null || list == null) {
            String string2 = "Invalid parameter";
            throw new IllegalArgumentException(string2);
        }
        this.setRoleName(string);
        this.setRoleValue(list);
    }

    public String getRoleName() {
        return this.name;
    }

    public List<ObjectName> getRoleValue() {
        return this.objectNameList;
    }

    public void setRoleName(String string) throws IllegalArgumentException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        this.name = string;
    }

    public void setRoleValue(List<ObjectName> list) throws IllegalArgumentException {
        if (list == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        this.objectNameList = new ArrayList<ObjectName>(list);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("role name: " + this.name + "; role value: ");
        Iterator<ObjectName> iterator = this.objectNameList.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = iterator.next();
            stringBuilder.append(objectName.toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public Object clone() {
        try {
            return new Role(this.name, this.objectNameList);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static String roleValueToString(List<ObjectName> list) throws IllegalArgumentException {
        if (list == null) {
            String string = "Invalid parameter";
            throw new IllegalArgumentException(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ObjectName objectName : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(objectName.toString());
        }
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.name = (String)getField.get("myName", null);
            if (getField.defaulted("myName")) {
                throw new NullPointerException("myName");
            }
            this.objectNameList = (List)Util.cast(getField.get("myObjNameList", null));
            if (getField.defaulted("myObjNameList")) {
                throw new NullPointerException("myObjNameList");
            }
        } else {
            objectInputStream.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("myName", this.name);
            putField.put("myObjNameList", this.objectNameList);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -1959486389343113026L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -279985518429862552L;
        }
    }
}

