/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
*/

#include "arch.h"
#include "ecp_BLS461.h"

/* Curve BLS383 - Pairing friendly BLS curve */

#if CHUNK==16

#error Not supported

#endif

#if CHUNK==32

const int CURVE_Cof_I_BLS461= 0;
const int CURVE_A_BLS461= 0;
const int CURVE_B_I_BLS461= 9;
const BIG_464_28 CURVE_B_BLS461= {0x9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0};
const BIG_464_28 CURVE_Order_BLS461= {0x1,0x0,0xFFFFC00,0x7FEFFFE,0x110000,0x7FFC800,0x801FC01,0x5FD000E,0x17FE0,0xFFFC018,0xFFFFFF7,0x0,0x0,0x0,0x0,0x0,0x0};
const BIG_464_28 CURVE_Gx_BLS461= {0xADEE93D,0x4D026A8,0x74B7411,0xD9C00EE,0x31AC7F2,0xC3981B5,0x9218229,0xD3564DC,0xA096650,0x6F7C292,0x9743616,0xBE922B1,0x12CF668,0xC81327,0x463B73A,0xE74E99B,0xAD0};
const BIG_464_28 CURVE_Gy_BLS461= {0xAD1D465,0xF763157,0xC4FF470,0x17884C8,0xB8D215D,0xA819E66,0xF4959D0,0xE5C3245,0xB84910A,0xB8BFA40,0xBE96EEC,0x8BF9F8C,0xF277ACC,0x5F1C3F2,0x5F68C9,0xCDB14B3,0x77B};

const BIG_464_28 CURVE_Bnx_BLS461= {0x0,0xFBFFFE0,0x1FFFFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0};
const BIG_464_28 CURVE_Cof_BLS461= {0xAAAAAAB,0xA7FFFEA,0x1556AA,0xD55AAAB,0x554FFFF,0x1555,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0};
const BIG_464_28 CURVE_Cru_BLS461= {0xFFFFFFE,0x40001F,0xFE00000,0xFFE7FFF,0xF0FFF6F,0x7200C47,0x7BCC604,0x15796DB,0xCF47771,0x9875433,0x613F0E8,0x5000502,0xEBFFF60,0x1FFFFF,0x0,0x0,0x0};
const BIG_464_28 CURVE_Pxa_BLS461= {0x6D0A37C,0x5B50318,0x75DCC46,0xC2E492E,0xD6878A9,0xE01F919,0xF92F564,0x86DB74F,0x66803F0,0x46D581A,0x7ED78D,0x2F97C29,0xC270C89,0xF679453,0x6A50A9A,0x54138A0,0x10CC};
const BIG_464_28 CURVE_Pxb_BLS461= {0x2C1C0AD,0xF85CA8C,0x25CADE9,0x6CD66C4,0xA289609,0xC612951,0xEE2401A,0x529ABEB,0xF65B17D,0xBA09D33,0xD4C5AF5,0x4D4371E,0x46A672E,0xA279D22,0xACEA37C,0x1FB4FE5,0x95C};
const BIG_464_28 CURVE_Pya_BLS461= {0x2FB006,0xCCD0C1B,0xA12A337,0x3D194A4,0xC92C895,0x4960CFC,0x39FC68B,0x3A9B00F,0xED1BA0F,0xA7DBBC5,0xA9CDFD8,0x27CC2F7,0x4E73ED2,0x6070F4F,0xEBA7E67,0xAC848E7,0x226};
const BIG_464_28 CURVE_Pyb_BLS461= {0xDF1457C,0xA506ADF,0x4C20A8,0xD6A31DC,0x36E3FB4,0xEA9A8F1,0x92F5668,0x3C3BE44,0x67A1297,0x74BEABA,0x56A20BE,0x4C42E38,0x45157F0,0x2AB1D00,0xBB402EA,0x101B4FA,0xE38};
const BIG_464_28 CURVE_W_BLS461[2]= {{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}};
const BIG_464_28 CURVE_SB_BLS461[2][2]= {{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}},{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}};
const BIG_464_28 CURVE_WB_BLS461[4]= {{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}};
const BIG_464_28 CURVE_BB_BLS461[4][4]= {{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}},{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}},{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}},{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}};

#endif

#if CHUNK==64

const int CURVE_Cof_I_BLS461= 0;
const int CURVE_A_BLS461= 0;
const int CURVE_B_I_BLS461= 9;
const BIG_464_60 CURVE_B_BLS461= {0x9L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L};
const BIG_464_60 CURVE_Order_BLS461= {0x1L,0x7FEFFFEFFFFC0L,0xC017FFC80001100L,0x7FE05FD000E801FL,0xFFFF7FFFC018001L,0xFFL,0x0L,0x0L};
const BIG_464_60 CURVE_Gx_BLS461= {0x14D026A8ADEE93DL,0xF2D9C00EE74B741L,0x229C3981B531AC7L,0x6650D3564DC9218L,0x436166F7C292A09L,0x2CF668BE922B197L,0x463B73A0C813271L,0xAD0E74E99BL};
const BIG_464_60 CURVE_Gy_BLS461= {0xF763157AD1D465L,0x5D17884C8C4FF47L,0x9D0A819E66B8D21L,0x910AE5C3245F495L,0x96EECB8BFA40B84L,0x277ACC8BF9F8CBEL,0x5F68C95F1C3F2FL,0x77BCDB14B3L};

const BIG_464_60 CURVE_Bnx_BLS461= {0xFFBFFFE00000000L,0x1FFFFL,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L};
const BIG_464_60 CURVE_Cof_BLS461= {0xAA7FFFEAAAAAAABL,0xFFD55AAAB01556AL,0x1555554FFL,0x0L,0x0L,0x0L,0x0L,0x0L};
const BIG_464_60 CURVE_Cru_BLS461= {0x40001FFFFFFFEL,0x6FFFE7FFFFE0000L,0x6047200C47F0FFFL,0x777115796DB7BCCL,0x3F0E89875433CF4L,0xBFFF60500050261L,0x1FFFFFEL,0x0L};
const BIG_464_60 CURVE_Pxa_BLS461= {0x65B503186D0A37CL,0xA9C2E492E75DCC4L,0x564E01F919D6878L,0x3F086DB74FF92FL,0xED78D46D581A668L,0x270C892F97C2907L,0x6A50A9AF679453CL,0x10CC54138A0L};
const BIG_464_60 CURVE_Pxb_BLS461= {0x9F85CA8C2C1C0ADL,0x96CD66C425CADEL,0x1AC612951A2896L,0xB17D529ABEBEE24L,0xC5AF5BA09D33F65L,0x6A672E4D4371ED4L,0xACEA37CA279D224L,0x95C1FB4FE5L};
const BIG_464_60 CURVE_Pya_BLS461= {0x7CCD0C1B02FB006L,0x953D194A4A12A33L,0x68B4960CFCC92C8L,0xBA0F3A9B00F39FCL,0xCDFD8A7DBBC5ED1L,0xE73ED227CC2F7A9L,0xEBA7E676070F4F4L,0x226AC848E7L};
const BIG_464_60 CURVE_Pyb_BLS461= {0x8A506ADFDF1457CL,0xB4D6A31DC04C20AL,0x668EA9A8F136E3FL,0x12973C3BE4492F5L,0xA20BE74BEABA67AL,0x5157F04C42E3856L,0xBB402EA2AB1D004L,0xE38101B4FAL};
const BIG_464_60 CURVE_W_BLS461[2]= {{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}};
const BIG_464_60 CURVE_SB_BLS461[2][2]= {{{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}},{{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}}};
const BIG_464_60 CURVE_WB_BLS461[4]= {{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}};
const BIG_464_60 CURVE_BB_BLS461[4][4]= {{{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}},{{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}},{{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}},{{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}}};


#endif
