/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import com.sun.imageio.stream.StreamCloser;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileCacheImageOutputStream
extends ImageOutputStreamImpl {
    private OutputStream stream;
    private File cacheFile;
    private RandomAccessFile cache;
    private long maxStreamPos = 0L;
    private final StreamCloser.CloseAction closeAction;

    public FileCacheImageOutputStream(OutputStream outputStream, File file) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory!");
        }
        this.stream = outputStream;
        this.cacheFile = file == null ? Files.createTempFile("imageio", ".tmp", new FileAttribute[0]).toFile() : Files.createTempFile(file.toPath(), "imageio", ".tmp", new FileAttribute[0]).toFile();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
        this.closeAction = StreamCloser.createCloseAction(this);
        StreamCloser.addToQueue(this.closeAction);
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int n = this.cache.read();
        if (n != -1) {
            ++this.streamPos;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (byArray == null) {
            throw new NullPointerException("b == null!");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off+len > b.length || off+len < 0!");
        }
        this.bitOffset = 0;
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.cache.read(byArray, n, n2);
        if (n3 != -1) {
            this.streamPos += (long)n3;
        }
        return n3;
    }

    @Override
    public void write(int n) throws IOException {
        this.flushBits();
        this.cache.write(n);
        ++this.streamPos;
        this.maxStreamPos = Math.max(this.maxStreamPos, this.streamPos);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.flushBits();
        this.cache.write(byArray, n, n2);
        this.streamPos += (long)n2;
        this.maxStreamPos = Math.max(this.maxStreamPos, this.streamPos);
    }

    @Override
    public long length() {
        try {
            this.checkClosed();
            return this.cache.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public void seek(long l) throws IOException {
        this.checkClosed();
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException();
        }
        this.cache.seek(l);
        this.streamPos = this.cache.getFilePointer();
        this.maxStreamPos = Math.max(this.maxStreamPos, this.streamPos);
        this.bitOffset = 0;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedFile() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.maxStreamPos = this.cache.length();
        this.seek(this.maxStreamPos);
        this.flushBefore(this.maxStreamPos);
        super.close();
        this.cache.close();
        this.cache = null;
        this.cacheFile.delete();
        this.cacheFile = null;
        this.stream.flush();
        this.stream = null;
        StreamCloser.removeFromQueue(this.closeAction);
    }

    @Override
    public void flushBefore(long l) throws IOException {
        long l2;
        long l3 = this.flushedPos;
        super.flushBefore(l);
        if (l2 > 0L) {
            int n;
            int n2 = 512;
            byte[] byArray = new byte[n2];
            this.cache.seek(l3);
            for (l2 = this.flushedPos - l3; l2 > 0L; l2 -= (long)n) {
                n = (int)Math.min(l2, (long)n2);
                this.cache.readFully(byArray, 0, n);
                this.stream.write(byArray, 0, n);
            }
            this.stream.flush();
        }
    }
}

