/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XVisualInfo
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 40 : 64;
    }

    @Override
    public int getDataSize() {
        return XVisualInfo.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XVisualInfo(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XVisualInfo() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XVisualInfo.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_visual(int n) {
        log.finest("");
        return Native.getLong(this.pData + 0L) + (long)(n * Native.getLongSize());
    }

    public long get_visual() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_visual(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public long get_visualid() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_visualid(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), l);
    }

    public int get_screen() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16));
    }

    public void set_screen(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16), n);
    }

    public int get_depth() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 20));
    }

    public void set_depth(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 20), n);
    }

    public int get_class() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 24));
    }

    public void set_class(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 24), n);
    }

    public long get_red_mask() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 32));
    }

    public void set_red_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 32), l);
    }

    public long get_green_mask() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 40));
    }

    public void set_green_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 40), l);
    }

    public long get_blue_mask() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 48));
    }

    public void set_blue_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 48), l);
    }

    public int get_colormap_size() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 56));
    }

    public void set_colormap_size(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 56), n);
    }

    public int get_bits_per_rgb() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 60));
    }

    public void set_bits_per_rgb(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 60), n);
    }

    @Override
    String getName() {
        return "XVisualInfo";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(400);
        stringBuilder.append("visual = ").append(this.get_visual()).append(", ");
        stringBuilder.append("visualid = ").append(this.get_visualid()).append(", ");
        stringBuilder.append("screen = ").append(this.get_screen()).append(", ");
        stringBuilder.append("depth = ").append(this.get_depth()).append(", ");
        stringBuilder.append("class = ").append(this.get_class()).append(", ");
        stringBuilder.append("red_mask = ").append(this.get_red_mask()).append(", ");
        stringBuilder.append("green_mask = ").append(this.get_green_mask()).append(", ");
        stringBuilder.append("blue_mask = ").append(this.get_blue_mask()).append(", ");
        stringBuilder.append("colormap_size = ").append(this.get_colormap_size()).append(", ");
        stringBuilder.append("bits_per_rgb = ").append(this.get_bits_per_rgb()).append(", ");
        return stringBuilder.toString();
    }
}

