/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class XMLFormatter
extends Formatter {
    private LogManager manager = LogManager.getLogManager();

    private void a2(StringBuilder stringBuilder, int n) {
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
    }

    private void appendISO8601(StringBuilder stringBuilder, long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        stringBuilder.append(gregorianCalendar.get(1));
        stringBuilder.append('-');
        this.a2(stringBuilder, gregorianCalendar.get(2) + 1);
        stringBuilder.append('-');
        this.a2(stringBuilder, gregorianCalendar.get(5));
        stringBuilder.append('T');
        this.a2(stringBuilder, gregorianCalendar.get(11));
        stringBuilder.append(':');
        this.a2(stringBuilder, gregorianCalendar.get(12));
        stringBuilder.append(':');
        this.a2(stringBuilder, gregorianCalendar.get(13));
    }

    private void escape(StringBuilder stringBuilder, String string) {
        if (string == null) {
            string = "<null>";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            stringBuilder.append(c);
        }
    }

    @Override
    public String format(LogRecord logRecord) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("<record>\n");
        stringBuilder.append("  <date>");
        this.appendISO8601(stringBuilder, logRecord.getMillis());
        stringBuilder.append("</date>\n");
        stringBuilder.append("  <millis>");
        stringBuilder.append(logRecord.getMillis());
        stringBuilder.append("</millis>\n");
        stringBuilder.append("  <sequence>");
        stringBuilder.append(logRecord.getSequenceNumber());
        stringBuilder.append("</sequence>\n");
        String string = logRecord.getLoggerName();
        if (string != null) {
            stringBuilder.append("  <logger>");
            this.escape(stringBuilder, string);
            stringBuilder.append("</logger>\n");
        }
        stringBuilder.append("  <level>");
        this.escape(stringBuilder, logRecord.getLevel().toString());
        stringBuilder.append("</level>\n");
        if (logRecord.getSourceClassName() != null) {
            stringBuilder.append("  <class>");
            this.escape(stringBuilder, logRecord.getSourceClassName());
            stringBuilder.append("</class>\n");
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuilder.append("  <method>");
            this.escape(stringBuilder, logRecord.getSourceMethodName());
            stringBuilder.append("</method>\n");
        }
        stringBuilder.append("  <thread>");
        stringBuilder.append(logRecord.getThreadID());
        stringBuilder.append("</thread>\n");
        if (logRecord.getMessage() != null) {
            object = this.formatMessage(logRecord);
            stringBuilder.append("  <message>");
            this.escape(stringBuilder, (String)object);
            stringBuilder.append("</message>");
            stringBuilder.append("\n");
        }
        object = logRecord.getResourceBundle();
        try {
            if (object != null && ((ResourceBundle)object).getString(logRecord.getMessage()) != null) {
                stringBuilder.append("  <key>");
                this.escape(stringBuilder, logRecord.getMessage());
                stringBuilder.append("</key>\n");
                stringBuilder.append("  <catalog>");
                this.escape(stringBuilder, logRecord.getResourceBundleName());
                stringBuilder.append("</catalog>\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] objectArray = logRecord.getParameters();
        if (objectArray != null && objectArray.length != 0 && logRecord.getMessage().indexOf("{") == -1) {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuilder.append("  <param>");
                try {
                    this.escape(stringBuilder, objectArray[i].toString());
                }
                catch (Exception exception) {
                    stringBuilder.append("???");
                }
                stringBuilder.append("</param>\n");
            }
        }
        if (logRecord.getThrown() != null) {
            Throwable throwable = logRecord.getThrown();
            stringBuilder.append("  <exception>\n");
            stringBuilder.append("    <message>");
            this.escape(stringBuilder, throwable.toString());
            stringBuilder.append("</message>\n");
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                stringBuilder.append("    <frame>\n");
                stringBuilder.append("      <class>");
                this.escape(stringBuilder, stackTraceElement.getClassName());
                stringBuilder.append("</class>\n");
                stringBuilder.append("      <method>");
                this.escape(stringBuilder, stackTraceElement.getMethodName());
                stringBuilder.append("</method>\n");
                if (stackTraceElement.getLineNumber() >= 0) {
                    stringBuilder.append("      <line>");
                    stringBuilder.append(stackTraceElement.getLineNumber());
                    stringBuilder.append("</line>\n");
                }
                stringBuilder.append("    </frame>\n");
            }
            stringBuilder.append("  </exception>\n");
        }
        stringBuilder.append("</record>\n");
        return stringBuilder.toString();
    }

    @Override
    public String getHead(Handler handler) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\"");
        String string = handler != null ? handler.getEncoding() : null;
        if (string == null) {
            string = Charset.defaultCharset().name();
        }
        try {
            Charset charset = Charset.forName(string);
            string = charset.name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuilder.append(" encoding=\"");
        stringBuilder.append(string);
        stringBuilder.append("\"");
        stringBuilder.append(" standalone=\"no\"?>\n");
        stringBuilder.append("<!DOCTYPE log SYSTEM \"logger.dtd\">\n");
        stringBuilder.append("<log>\n");
        return stringBuilder.toString();
    }

    @Override
    public String getTail(Handler handler) {
        return "</log>\n";
    }
}

