/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.SerializationTester;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.TooManyListenersException;
import javax.swing.Timer;

public class DropTarget
implements DropTargetListener,
Serializable {
    private static final long serialVersionUID = -6283860791671019047L;
    private DropTargetContext dropTargetContext = this.createDropTargetContext();
    private Component component;
    private transient ComponentPeer componentPeer;
    private transient ComponentPeer nativePeer;
    int actions = 3;
    boolean active = true;
    private transient DropTargetAutoScroller autoScroller;
    private transient DropTargetListener dtListener;
    private transient FlavorMap flavorMap;
    private transient boolean isDraggingInside;

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener, boolean bl, FlavorMap flavorMap) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.component = component;
        this.setDefaultActions(n);
        if (dropTargetListener != null) {
            try {
                this.addDropTargetListener(dropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
        if (component != null) {
            component.setDropTarget(this);
            this.setActive(bl);
        }
        this.flavorMap = flavorMap != null ? flavorMap : SystemFlavorMap.getDefaultFlavorMap();
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener, boolean bl) throws HeadlessException {
        this(component, n, dropTargetListener, bl, null);
    }

    public DropTarget() throws HeadlessException {
        this(null, 3, null, true, null);
    }

    public DropTarget(Component component, DropTargetListener dropTargetListener) throws HeadlessException {
        this(component, 3, dropTargetListener, true, null);
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener) throws HeadlessException {
        this(component, n, dropTargetListener, true);
    }

    public synchronized void setComponent(Component component) {
        block6: {
            if (this.component == component || this.component != null && this.component.equals(component)) {
                return;
            }
            ComponentPeer componentPeer = null;
            Component component2 = this.component;
            if (component2 != null) {
                this.clearAutoscroll();
                this.component = null;
                if (this.componentPeer != null) {
                    componentPeer = this.componentPeer;
                    this.removeNotify(this.componentPeer);
                }
                component2.setDropTarget(null);
            }
            if ((this.component = component) != null) {
                try {
                    component.setDropTarget(this);
                }
                catch (Exception exception) {
                    if (component2 == null) break block6;
                    component2.setDropTarget(this);
                    this.addNotify(componentPeer);
                }
            }
        }
    }

    public synchronized Component getComponent() {
        return this.component;
    }

    public void setDefaultActions(int n) {
        this.getDropTargetContext().setTargetActions(n & 0x40000003);
    }

    void doSetDefaultActions(int n) {
        this.actions = n;
    }

    public int getDefaultActions() {
        return this.actions;
    }

    public synchronized void setActive(boolean bl) {
        if (bl != this.active) {
            this.active = bl;
        }
        if (!this.active) {
            this.clearAutoscroll();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (dropTargetListener == null) {
            return;
        }
        if (this.equals(dropTargetListener)) {
            throw new IllegalArgumentException("DropTarget may not be its own Listener");
        }
        if (this.dtListener != null) {
            throw new TooManyListenersException();
        }
        this.dtListener = dropTargetListener;
    }

    public synchronized void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener != null && this.dtListener != null) {
            if (this.dtListener.equals(dropTargetListener)) {
                this.dtListener = null;
            } else {
                throw new IllegalArgumentException("listener mismatch");
            }
        }
    }

    @Override
    public synchronized void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.isDraggingInside = true;
        if (!this.active) {
            return;
        }
        if (this.dtListener != null) {
            this.dtListener.dragEnter(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.getDropTargetContext().setTargetActions(0);
        }
        this.initializeAutoscrolling(dropTargetDragEvent.getLocation());
    }

    @Override
    public synchronized void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.active) {
            return;
        }
        if (this.dtListener != null && this.active) {
            this.dtListener.dragOver(dropTargetDragEvent);
        }
        this.updateAutoscroll(dropTargetDragEvent.getLocation());
    }

    @Override
    public synchronized void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.active) {
            return;
        }
        if (this.dtListener != null) {
            this.dtListener.dropActionChanged(dropTargetDragEvent);
        }
        this.updateAutoscroll(dropTargetDragEvent.getLocation());
    }

    @Override
    public synchronized void dragExit(DropTargetEvent dropTargetEvent) {
        this.isDraggingInside = false;
        if (!this.active) {
            return;
        }
        if (this.dtListener != null && this.active) {
            this.dtListener.dragExit(dropTargetEvent);
        }
        this.clearAutoscroll();
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.isDraggingInside = false;
        this.clearAutoscroll();
        if (this.dtListener != null && this.active) {
            this.dtListener.drop(dropTargetDropEvent);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    public void setFlavorMap(FlavorMap flavorMap) {
        this.flavorMap = flavorMap == null ? SystemFlavorMap.getDefaultFlavorMap() : flavorMap;
    }

    public void addNotify(ComponentPeer componentPeer) {
        if (componentPeer == this.componentPeer) {
            return;
        }
        this.componentPeer = componentPeer;
        for (Component component = this.component; component != null && componentPeer instanceof LightweightPeer; component = component.getParent()) {
            componentPeer = component.getPeer();
        }
        if (componentPeer instanceof DropTargetPeer) {
            this.nativePeer = componentPeer;
            ((DropTargetPeer)((Object)componentPeer)).addDropTarget(this);
        } else {
            this.nativePeer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify(ComponentPeer componentPeer) {
        if (this.nativePeer != null) {
            ((DropTargetPeer)((Object)this.nativePeer)).removeDropTarget(this);
        }
        this.nativePeer = null;
        this.componentPeer = null;
        DropTarget dropTarget = this;
        synchronized (dropTarget) {
            if (this.isDraggingInside) {
                this.dragExit(new DropTargetEvent(this.getDropTargetContext()));
            }
        }
    }

    public DropTargetContext getDropTargetContext() {
        return this.dropTargetContext;
    }

    protected DropTargetContext createDropTargetContext() {
        return new DropTargetContext(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(SerializationTester.test(this.dtListener) ? this.dtListener : null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        try {
            this.dropTargetContext = (DropTargetContext)getField.get("dropTargetContext", null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.dropTargetContext == null) {
            this.dropTargetContext = this.createDropTargetContext();
        }
        this.component = (Component)getField.get("component", null);
        this.actions = getField.get("actions", 3);
        this.active = getField.get("active", true);
        try {
            this.dtListener = (DropTargetListener)getField.get("dtListener", null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.dtListener = (DropTargetListener)objectInputStream.readObject();
        }
    }

    protected DropTargetAutoScroller createDropTargetAutoScroller(Component component, Point point) {
        return new DropTargetAutoScroller(component, point);
    }

    protected void initializeAutoscrolling(Point point) {
        if (this.component == null || !(this.component instanceof Autoscroll)) {
            return;
        }
        this.autoScroller = this.createDropTargetAutoScroller(this.component, point);
    }

    protected void updateAutoscroll(Point point) {
        if (this.autoScroller != null) {
            this.autoScroller.updateLocation(point);
        }
    }

    protected void clearAutoscroll() {
        if (this.autoScroller != null) {
            this.autoScroller.stop();
            this.autoScroller = null;
        }
    }

    protected static class DropTargetAutoScroller
    implements ActionListener {
        private Component component;
        private Autoscroll autoScroll;
        private Timer timer;
        private Point locn;
        private Point prev;
        private Rectangle outer = new Rectangle();
        private Rectangle inner = new Rectangle();
        private int hysteresis = 10;

        protected DropTargetAutoScroller(Component component, Point point) {
            this.component = component;
            this.autoScroll = (Autoscroll)((Object)this.component);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Integer n = 100;
            Integer n2 = 100;
            try {
                n = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.initialDelay");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n2 = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.interval");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timer = new Timer(n2, this);
            this.timer.setCoalesce(true);
            this.timer.setInitialDelay(n);
            this.locn = point;
            this.prev = point;
            try {
                this.hysteresis = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timer.start();
        }

        private void updateRegion() {
            Insets insets = this.autoScroll.getAutoscrollInsets();
            Dimension dimension = this.component.getSize();
            if (dimension.width != this.outer.width || dimension.height != this.outer.height) {
                this.outer.reshape(0, 0, dimension.width, dimension.height);
            }
            if (this.inner.x != insets.left || this.inner.y != insets.top) {
                this.inner.setLocation(insets.left, insets.top);
            }
            int n = dimension.width - (insets.left + insets.right);
            int n2 = dimension.height - (insets.top + insets.bottom);
            if (n != this.inner.width || n2 != this.inner.height) {
                this.inner.setSize(n, n2);
            }
        }

        protected synchronized void updateLocation(Point point) {
            this.prev = this.locn;
            this.locn = point;
            if (Math.abs(this.locn.x - this.prev.x) > this.hysteresis || Math.abs(this.locn.y - this.prev.y) > this.hysteresis) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }

        protected void stop() {
            this.timer.stop();
        }

        @Override
        public synchronized void actionPerformed(ActionEvent actionEvent) {
            this.updateRegion();
            if (this.outer.contains(this.locn) && !this.inner.contains(this.locn)) {
                this.autoScroll.autoscroll(this.locn);
            }
        }
    }
}

