/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingChooser;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.FixedList;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PackageWriter
extends BandStructure {
    Package pkg;
    OutputStream finalOut;
    Package.Version packageVersion;
    Set<ConstantPool.Entry> requiredEntries;
    Map<Attribute.Layout, int[]> backCountTable;
    int[][] attrCounts;
    int[] maxFlags;
    List<Map<Attribute.Layout, int[]>> allLayouts;
    Attribute.Layout[] attrDefsWritten;
    private Code curCode;
    private Package.Class curClass;
    private ConstantPool.Entry[] curCPMap;
    int[] codeHist = new int[256];
    int[] ldcHist = new int[20];

    PackageWriter(Package package_, OutputStream outputStream) throws IOException {
        this.pkg = package_;
        this.finalOut = outputStream;
        this.initHighestClassVersion(package_.getHighestClassVersion());
    }

    void write() throws IOException {
        boolean bl = false;
        try {
            if (this.verbose > 0) {
                Utils.log.info("Setting up constant pool...");
            }
            this.setup();
            if (this.verbose > 0) {
                Utils.log.info("Packing...");
            }
            this.writeConstantPool();
            this.writeFiles();
            this.writeAttrDefs();
            this.writeInnerClasses();
            this.writeClassesAndByteCodes();
            this.writeAttrCounts();
            if (this.verbose > 1) {
                this.printCodeHist();
            }
            if (this.verbose > 0) {
                Utils.log.info("Coding...");
            }
            this.all_bands.chooseBandCodings();
            this.writeFileHeader();
            this.writeAllBandsTo(this.finalOut);
            bl = true;
        }
        catch (Exception exception) {
            Utils.log.warning("Error on output: " + exception, exception);
            if (this.verbose > 0) {
                this.finalOut.close();
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new Error("error packing", exception);
        }
    }

    void setup() {
        this.requiredEntries = new HashSet<ConstantPool.Entry>();
        this.setArchiveOptions();
        this.trimClassAttributes();
        this.collectAttributeLayouts();
        this.pkg.buildGlobalConstantPool(this.requiredEntries);
        this.setBandIndexes();
        this.makeNewAttributeBands();
        this.collectInnerClasses();
    }

    void chooseDefaultPackageVersion() throws IOException {
        if (this.pkg.packageVersion != null) {
            this.packageVersion = this.pkg.packageVersion;
            if (this.verbose > 0) {
                Utils.log.info("package version overridden with: " + this.packageVersion);
            }
            return;
        }
        Package.Version version = this.getHighestClassVersion();
        this.packageVersion = version.lessThan(Constants.JAVA6_MAX_CLASS_VERSION) ? Constants.JAVA5_PACKAGE_VERSION : (version.equals(Constants.JAVA6_MAX_CLASS_VERSION) || version.equals(Constants.JAVA7_MAX_CLASS_VERSION) && !this.pkg.cp.haveExtraTags() ? Constants.JAVA6_PACKAGE_VERSION : (version.equals(Constants.JAVA7_MAX_CLASS_VERSION) ? Constants.JAVA7_PACKAGE_VERSION : Constants.JAVA8_PACKAGE_VERSION));
        if (this.verbose > 0) {
            Utils.log.info("Highest version class file: " + version + " package version: " + this.packageVersion);
        }
    }

    void checkVersion() throws IOException {
        assert (this.packageVersion != null);
        if (this.packageVersion.lessThan(Constants.JAVA7_PACKAGE_VERSION) && PackageWriter.testBit(this.archiveOptions, 8)) {
            throw new IOException("Format bits for Java 7 must be zero in previous releases");
        }
        if (PackageWriter.testBit(this.archiveOptions, -8192)) {
            throw new IOException("High archive option bits are reserved and must be zero: " + Integer.toHexString(this.archiveOptions));
        }
    }

    /*
     * WARNING - void declaration
     */
    void setArchiveOptions() {
        void var9_19;
        Object object;
        int n = this.pkg.default_modtime;
        int n2 = this.pkg.default_modtime;
        int n3 = -1;
        int n4 = 0;
        this.archiveOptions |= this.pkg.default_options;
        for (Package.File file : this.pkg.files) {
            int n5 = file.modtime;
            int n6 = file.options;
            if (n == 0) {
                n = n2 = n5;
            } else {
                if (n > n5) {
                    n = n5;
                }
                if (n2 < n5) {
                    n2 = n5;
                }
            }
            n3 &= n6;
            n4 |= n6;
        }
        if (this.pkg.default_modtime == 0) {
            this.pkg.default_modtime = n;
        }
        if (n != 0 && n != n2) {
            this.archiveOptions |= 0x40;
        }
        if (!PackageWriter.testBit(this.archiveOptions, 32) && n3 != -1) {
            if (PackageWriter.testBit(n3, 1)) {
                this.archiveOptions |= 0x20;
                --n3;
                --n4;
            }
            this.pkg.default_options |= n3;
            if (n3 != n4 || n3 != this.pkg.default_options) {
                this.archiveOptions |= 0x80;
            }
        }
        HashMap hashMap = new HashMap();
        boolean n7 = false;
        Package.Version version = null;
        for (Package.Class comparable : this.pkg.classes) {
            void var11_23;
            object = comparable.getVersion();
            int[] nArray = (int[])hashMap.get(object);
            if (nArray == null) {
                int[] nArray2 = new int[1];
                hashMap.put(object, nArray2);
            }
            void v0 = var11_23;
            v0[0] = v0[0] + true;
            void var12_28 = v0[0];
            if (n7 >= var12_28) continue;
            n7 = var12_28;
            version = object;
        }
        hashMap.clear();
        if (version == null) {
            version = Constants.JAVA_MIN_CLASS_VERSION;
        }
        this.pkg.defaultClassVersion = version;
        if (this.verbose > 0) {
            Utils.log.info("Consensus version number in segment is " + version);
        }
        if (this.verbose > 0) {
            Utils.log.info("Highest version number in segment is " + this.pkg.getHighestClassVersion());
        }
        for (Package.Class clazz : this.pkg.classes) {
            if (clazz.getVersion().equals(version)) continue;
            object = this.makeClassFileVersionAttr(clazz.getVersion());
            if (this.verbose > 1) {
                Utils.log.fine("Version " + clazz.getVersion() + " of " + clazz + " doesn't match package version " + version);
            }
            clazz.addAttribute((Attribute)object);
        }
        for (Package.File file : this.pkg.files) {
            long l = file.getFileLength();
            if (l == (long)((int)l)) continue;
            this.archiveOptions |= 0x100;
            if (this.verbose <= 0) break;
            Utils.log.info("Note: Huge resource file " + file.getFileName() + " forces 64-bit sizing");
            break;
        }
        int n9 = 0;
        boolean bl = false;
        for (Package.Class clazz : this.pkg.classes) {
            for (Package.Class.Method method : clazz.getMethods()) {
                if (method.code == null) continue;
                if (method.code.attributeSize() == 0) {
                    ++var9_19;
                    continue;
                }
                if (PackageWriter.shortCodeHeader(method.code) == 0) continue;
                n9 += 3;
            }
        }
        if (n9 > var9_19) {
            this.archiveOptions |= 4;
        }
        if (this.verbose > 0) {
            Utils.log.info("archiveOptions = 0b" + Integer.toBinaryString(this.archiveOptions));
        }
    }

    void writeFileHeader() throws IOException {
        this.chooseDefaultPackageVersion();
        this.writeArchiveMagic();
        this.writeArchiveHeader();
    }

    private void putMagicInt32(int n) throws IOException {
        int n2 = n;
        for (int i = 0; i < 4; ++i) {
            this.archive_magic.putByte(0xFF & n2 >>> 24);
            n2 <<= 8;
        }
    }

    void writeArchiveMagic() throws IOException {
        this.putMagicInt32(this.pkg.magic);
    }

    void writeArchiveHeader() throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n = 15;
        boolean bl4 = PackageWriter.testBit(this.archiveOptions, 1);
        if (!bl4) {
            bl4 |= this.band_headers.length() != 0;
            if (bl4 |= this.attrDefsWritten.length != 0) {
                this.archiveOptions |= 1;
            }
        }
        if (bl4) {
            n += 2;
        }
        if (!(bl3 = PackageWriter.testBit(this.archiveOptions, 16))) {
            bl3 |= this.archiveNextCount > 0;
            if (bl3 |= this.pkg.default_modtime != 0) {
                this.archiveOptions |= 0x10;
            }
        }
        if (bl3) {
            n += 5;
        }
        if (!(bl2 = PackageWriter.testBit(this.archiveOptions, 2)) && (bl2 |= this.pkg.cp.haveNumbers())) {
            this.archiveOptions |= 2;
        }
        if (bl2) {
            n += 4;
        }
        if (!(bl = PackageWriter.testBit(this.archiveOptions, 8)) && (bl |= this.pkg.cp.haveExtraTags())) {
            this.archiveOptions |= 8;
        }
        if (bl) {
            n += 4;
        }
        this.checkVersion();
        this.archive_header_0.putInt(this.packageVersion.minor);
        this.archive_header_0.putInt(this.packageVersion.major);
        if (this.verbose > 0) {
            Utils.log.info("Package Version for this segment:" + this.packageVersion);
        }
        this.archive_header_0.putInt(this.archiveOptions);
        assert (this.archive_header_0.length() == 3);
        if (bl3) {
            assert (this.archive_header_S.length() == 0);
            this.archive_header_S.putInt(0);
            assert (this.archive_header_S.length() == 1);
            this.archive_header_S.putInt(0);
            assert (this.archive_header_S.length() == 2);
        }
        if (bl3) {
            this.archive_header_1.putInt(this.archiveNextCount);
            this.archive_header_1.putInt(this.pkg.default_modtime);
            this.archive_header_1.putInt(this.pkg.files.size());
        } else assert (this.pkg.files.isEmpty());
        if (bl4) {
            this.archive_header_1.putInt(this.band_headers.length());
            this.archive_header_1.putInt(this.attrDefsWritten.length);
        } else {
            assert (this.band_headers.length() == 0);
            assert (this.attrDefsWritten.length == 0);
        }
        this.writeConstantPoolCounts(bl2, bl);
        this.archive_header_1.putInt(this.pkg.getAllInnerClasses().size());
        this.archive_header_1.putInt(this.pkg.defaultClassVersion.minor);
        this.archive_header_1.putInt(this.pkg.defaultClassVersion.major);
        this.archive_header_1.putInt(this.pkg.classes.size());
        assert (this.archive_header_0.length() + this.archive_header_S.length() + this.archive_header_1.length() == n);
        this.archiveSize0 = 0L;
        this.archiveSize1 = this.all_bands.outputSize();
        this.archiveSize0 += this.archive_magic.outputSize();
        this.archiveSize0 += this.archive_header_0.outputSize();
        this.archiveSize0 += this.archive_header_S.outputSize();
        this.archiveSize1 -= this.archiveSize0;
        if (bl3) {
            int n2 = (int)(this.archiveSize1 >>> 32);
            int n3 = (int)(this.archiveSize1 >>> 0);
            this.archive_header_S.patchValue(0, n2);
            this.archive_header_S.patchValue(1, n3);
            int n4 = UNSIGNED5.getLength(0);
            this.archiveSize0 += (long)(UNSIGNED5.getLength(n2) - n4);
            this.archiveSize0 += (long)(UNSIGNED5.getLength(n3) - n4);
        }
        if (this.verbose > 1) {
            Utils.log.fine("archive sizes: " + this.archiveSize0 + "+" + this.archiveSize1);
        }
        assert (this.all_bands.outputSize() == this.archiveSize0 + this.archiveSize1);
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeConstantPoolCounts(boolean bl, boolean bl2) throws IOException {
        byte[] byArray = ConstantPool.TAGS_IN_ORDER;
        int n = byArray.length;
        int n2 = 0;
        while (true) {
            block10: {
                if (n2 >= n) {
                    return;
                }
                byte by = byArray[n2];
                int n3 = this.pkg.cp.getIndexByTag(by).size();
                switch (by) {
                    case 1: {
                        if (n3 > 0) assert (this.pkg.cp.getIndexByTag(by).get(0) == ConstantPool.getUtf8Entry(""));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (bl) break;
                        assert (n3 == 0);
                        break block10;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        if (bl2) break;
                        assert (n3 == 0);
                        break block10;
                    }
                }
                this.archive_header_1.putInt(n3);
            }
            ++n2;
        }
    }

    @Override
    protected ConstantPool.Index getCPIndex(byte by) {
        return this.pkg.cp.getIndexByTag(by);
    }

    void writeConstantPool() throws IOException {
        Object object;
        ConstantPool.IndexGroup indexGroup = this.pkg.cp;
        if (this.verbose > 0) {
            Utils.log.info("Writing CP");
        }
        block36: for (byte by : ConstantPool.TAGS_IN_ORDER) {
            Object object2;
            object = indexGroup.getIndexByTag(by);
            ConstantPool.Entry[] entryArray = ((ConstantPool.Index)object).cpMap;
            if (this.verbose > 0) {
                Utils.log.info("Writing " + entryArray.length + " " + ConstantPool.tagName(by) + " entries...");
            }
            if (this.optDumpBands) {
                PrintStream printStream = new PrintStream(PackageWriter.getDumpStream((ConstantPool.Index)object, ".idx"));
                object2 = null;
                try {
                    PackageWriter.printArrayTo(printStream, entryArray, 0, entryArray.length);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    if (printStream != null) {
                        if (object2 != null) {
                            try {
                                printStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                        } else {
                            printStream.close();
                        }
                    }
                }
            }
            switch (by) {
                case 1: {
                    this.writeUtf8Bands(entryArray);
                    continue block36;
                }
                case 3: {
                    for (int i = 0; i < entryArray.length; ++i) {
                        object2 = (ConstantPool.NumberEntry)entryArray[i];
                        int n = (Integer)((ConstantPool.NumberEntry)object2).numberValue();
                        this.cp_Int.putInt(n);
                    }
                    continue block36;
                }
                case 4: {
                    for (int i = 0; i < entryArray.length; ++i) {
                        object2 = (ConstantPool.NumberEntry)entryArray[i];
                        float f = ((Float)((ConstantPool.NumberEntry)object2).numberValue()).floatValue();
                        int n = Float.floatToIntBits(f);
                        this.cp_Float.putInt(n);
                    }
                    continue block36;
                }
                case 5: {
                    for (int i = 0; i < entryArray.length; ++i) {
                        object2 = (ConstantPool.NumberEntry)entryArray[i];
                        long l = (Long)((ConstantPool.NumberEntry)object2).numberValue();
                        this.cp_Long_hi.putInt((int)(l >>> 32));
                        this.cp_Long_lo.putInt((int)(l >>> 0));
                    }
                    continue block36;
                }
                case 6: {
                    for (int i = 0; i < entryArray.length; ++i) {
                        object2 = (ConstantPool.NumberEntry)entryArray[i];
                        double d = (Double)((ConstantPool.NumberEntry)object2).numberValue();
                        long l = Double.doubleToLongBits(d);
                        this.cp_Double_hi.putInt((int)(l >>> 32));
                        this.cp_Double_lo.putInt((int)(l >>> 0));
                    }
                    continue block36;
                }
                case 8: {
                    for (int i = 0; i < entryArray.length; ++i) {
                        object2 = (ConstantPool.StringEntry)entryArray[i];
                        this.cp_String.putRef(((ConstantPool.StringEntry)object2).ref);
                    }
                    continue block36;
                }
                case 7: {
                    for (int i = 0; i < entryArray.length; ++i) {
                        object2 = (ConstantPool.ClassEntry)entryArray[i];
                        this.cp_Class.putRef(((ConstantPool.ClassEntry)object2).ref);
                    }
                    continue block36;
                }
                case 13: {
                    this.writeSignatureBands(entryArray);
                    continue block36;
                }
                case 12: {
                    for (int i = 0; i < entryArray.length; ++i) {
                        object2 = (ConstantPool.DescriptorEntry)entryArray[i];
                        this.cp_Descr_name.putRef(((ConstantPool.DescriptorEntry)object2).nameRef);
                        this.cp_Descr_type.putRef(((ConstantPool.DescriptorEntry)object2).typeRef);
                    }
                    continue block36;
                }
                case 9: {
                    this.writeMemberRefs(by, entryArray, this.cp_Field_class, this.cp_Field_desc);
                    continue block36;
                }
                case 10: {
                    this.writeMemberRefs(by, entryArray, this.cp_Method_class, this.cp_Method_desc);
                    continue block36;
                }
                case 11: {
                    this.writeMemberRefs(by, entryArray, this.cp_Imethod_class, this.cp_Imethod_desc);
                    continue block36;
                }
                case 15: {
                    for (int i = 0; i < entryArray.length; ++i) {
                        object2 = (ConstantPool.MethodHandleEntry)entryArray[i];
                        this.cp_MethodHandle_refkind.putInt(((ConstantPool.MethodHandleEntry)object2).refKind);
                        this.cp_MethodHandle_member.putRef(((ConstantPool.MethodHandleEntry)object2).memRef);
                    }
                    continue block36;
                }
                case 16: {
                    for (int i = 0; i < entryArray.length; ++i) {
                        object2 = (ConstantPool.MethodTypeEntry)entryArray[i];
                        this.cp_MethodType.putRef(((ConstantPool.MethodTypeEntry)object2).typeRef);
                    }
                    continue block36;
                }
                case 18: {
                    for (int i = 0; i < entryArray.length; ++i) {
                        object2 = (ConstantPool.InvokeDynamicEntry)entryArray[i];
                        this.cp_InvokeDynamic_spec.putRef(((ConstantPool.InvokeDynamicEntry)object2).bssRef);
                        this.cp_InvokeDynamic_desc.putRef(((ConstantPool.InvokeDynamicEntry)object2).descRef);
                    }
                    continue block36;
                }
                case 17: {
                    for (int i = 0; i < entryArray.length; ++i) {
                        object2 = (ConstantPool.BootstrapMethodEntry)entryArray[i];
                        this.cp_BootstrapMethod_ref.putRef(((ConstantPool.BootstrapMethodEntry)object2).bsmRef);
                        this.cp_BootstrapMethod_arg_count.putInt(((ConstantPool.BootstrapMethodEntry)object2).argRefs.length);
                        for (ConstantPool.Entry entry : ((ConstantPool.BootstrapMethodEntry)object2).argRefs) {
                            this.cp_BootstrapMethod_arg.putRef(entry);
                        }
                    }
                    continue block36;
                }
                default: {
                    throw new AssertionError((Object)"unexpected CP tag in package");
                }
            }
        }
        if (this.optDumpBands || this.verbose > 1) {
            for (byte by = 50; by < 54; by = (byte)(by + 1)) {
                ConstantPool.Index index = indexGroup.getIndexByTag(by);
                if (index == null || index.isEmpty()) continue;
                ConstantPool.Entry[] entryArray = index.cpMap;
                if (this.verbose > 1) {
                    Utils.log.info("Index group " + ConstantPool.tagName(by) + " contains " + entryArray.length + " entries.");
                }
                if (!this.optDumpBands) continue;
                PrintStream printStream = new PrintStream(PackageWriter.getDumpStream(index.debugName, by, ".gidx", index));
                object = null;
                try {
                    PackageWriter.printArrayTo(printStream, entryArray, 0, entryArray.length, true);
                    continue;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (printStream != null) {
                        if (object != null) {
                            try {
                                printStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            printStream.close();
                        }
                    }
                }
            }
        }
    }

    void writeUtf8Bands(ConstantPool.Entry[] entryArray) throws IOException {
        int n;
        int n2;
        if (entryArray.length == 0) {
            return;
        }
        assert (entryArray[0].stringValue().equals(""));
        char[][] cArrayArray = new char[entryArray.length][];
        for (int i = 0; i < cArrayArray.length; ++i) {
            cArrayArray[i] = entryArray[i].stringValue().toCharArray();
        }
        int[] nArray = new int[entryArray.length];
        char[] cArray = new char[]{};
        for (n2 = 0; n2 < cArrayArray.length; ++n2) {
            int n3;
            char[] cArray2 = cArrayArray[n2];
            n = Math.min(cArray2.length, cArray.length);
            for (n3 = 0; n3 < n && cArray2[n3] == cArray[n3]; ++n3) {
            }
            nArray[n2] = n3;
            if (n2 >= 2) {
                this.cp_Utf8_prefix.putInt(n3);
            } else assert (n3 == 0);
            cArray = cArray2;
        }
        for (n2 = 0; n2 < cArrayArray.length; ++n2) {
            int n4;
            int n5;
            char[] cArray3 = cArrayArray[n2];
            int n6 = nArray[n2];
            n = cArray3.length - nArray[n2];
            boolean bl = false;
            if (n == 0) {
                bl = n2 >= 1;
            } else if (this.optBigStrings && this.effort > 1 && n > 100) {
                n5 = 0;
                for (n4 = 0; n4 < n; ++n4) {
                    if (cArray3[n6 + n4] <= '\u007f') continue;
                    ++n5;
                }
                if (n5 > 100) {
                    bl = this.tryAlternateEncoding(n2, n5, cArray3, n6);
                }
            }
            if (n2 < 1) {
                assert (!bl);
                assert (n == 0);
                continue;
            }
            if (bl) {
                this.cp_Utf8_suffix.putInt(0);
                this.cp_Utf8_big_suffix.putInt(n);
                continue;
            }
            assert (n != 0);
            this.cp_Utf8_suffix.putInt(n);
            for (n5 = 0; n5 < n; ++n5) {
                n4 = cArray3[n6 + n5];
                this.cp_Utf8_chars.putInt(n4);
            }
        }
        if (this.verbose > 0) {
            n2 = this.cp_Utf8_chars.length();
            int n7 = this.cp_Utf8_big_chars.length();
            int n8 = n2 + n7;
            Utils.log.info("Utf8string #CHARS=" + n8 + " #PACKEDCHARS=" + n7);
        }
    }

    private boolean tryAlternateEncoding(int n, int n2, char[] cArray, int n3) {
        int n4 = cArray.length - n3;
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = cArray[n3 + i];
        }
        CodingChooser codingChooser = this.getCodingChooser();
        Coding coding = this.cp_Utf8_big_chars.regularCoding;
        String string = "(Utf8_big_" + n + ")";
        int[] nArray2 = new int[]{0, 0};
        if (this.verbose > 1 || codingChooser.verbose > 1) {
            Utils.log.fine("--- chooseCoding " + string);
        }
        CodingMethod codingMethod = codingChooser.choose(nArray, coding, nArray2);
        Coding coding2 = this.cp_Utf8_chars.regularCoding;
        if (this.verbose > 1) {
            Utils.log.fine("big string[" + n + "] len=" + n4 + " #wide=" + n2 + " size=" + nArray2[0] + "/z=" + nArray2[1] + " coding " + codingMethod);
        }
        if (codingMethod != coding2) {
            int n5 = nArray2[1];
            int[] nArray3 = codingChooser.computeSize(coding2, nArray);
            int n6 = nArray3[1];
            int n7 = Math.max(5, n6 / 1000);
            if (this.verbose > 1) {
                Utils.log.fine("big string[" + n + "] normalSize=" + nArray3[0] + "/z=" + nArray3[1] + " win=" + (n5 < n6 - n7));
            }
            if (n5 < n6 - n7) {
                BandStructure.IntBand intBand = this.cp_Utf8_big_chars.newIntBand(string);
                intBand.initializeValues(nArray);
                return true;
            }
        }
        return false;
    }

    void writeSignatureBands(ConstantPool.Entry[] entryArray) throws IOException {
        for (int i = 0; i < entryArray.length; ++i) {
            ConstantPool.SignatureEntry signatureEntry = (ConstantPool.SignatureEntry)entryArray[i];
            this.cp_Signature_form.putRef(signatureEntry.formRef);
            for (int j = 0; j < signatureEntry.classRefs.length; ++j) {
                this.cp_Signature_classes.putRef(signatureEntry.classRefs[j]);
            }
        }
    }

    void writeMemberRefs(byte by, ConstantPool.Entry[] entryArray, BandStructure.CPRefBand cPRefBand, BandStructure.CPRefBand cPRefBand2) throws IOException {
        for (int i = 0; i < entryArray.length; ++i) {
            ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)entryArray[i];
            cPRefBand.putRef(memberEntry.classRef);
            cPRefBand2.putRef(memberEntry.descRef);
        }
    }

    void writeFiles() throws IOException {
        int n = this.pkg.files.size();
        if (n == 0) {
            return;
        }
        int n2 = this.archiveOptions;
        boolean bl = PackageWriter.testBit(n2, 256);
        boolean bl2 = PackageWriter.testBit(n2, 64);
        boolean bl3 = PackageWriter.testBit(n2, 128);
        if (!bl3) {
            for (Package.File file : this.pkg.files) {
                if (!file.isClassStub()) continue;
                bl3 = true;
                this.archiveOptions = n2 |= 0x80;
                break;
            }
        }
        if (bl || bl2 || bl3 || !this.pkg.files.isEmpty()) {
            this.archiveOptions = n2 |= 0x10;
        }
        for (Package.File file : this.pkg.files) {
            this.file_name.putRef(file.name);
            long l = file.getFileLength();
            this.file_size_lo.putInt((int)l);
            if (bl) {
                this.file_size_hi.putInt((int)(l >>> 32));
            }
            if (bl2) {
                this.file_modtime.putInt(file.modtime - this.pkg.default_modtime);
            }
            if (bl3) {
                this.file_options.putInt(file.options);
            }
            file.writeTo(this.file_bits.collectorStream());
            if (this.verbose <= 1) continue;
            Utils.log.fine("Wrote " + l + " bytes of " + file.name.stringValue());
        }
        if (this.verbose > 0) {
            Utils.log.info("Wrote " + n + " resource files");
        }
    }

    /*
     * WARNING - void declaration
     */
    void collectAttributeLayouts() {
        int n;
        this.maxFlags = new int[4];
        this.allLayouts = new FixedList<Map<Attribute.Layout, int[]>>(4);
        for (int i = 0; i < 4; ++i) {
            this.allLayouts.set(i, new HashMap());
        }
        for (Package.Class clazz : this.pkg.classes) {
            this.visitAttributeLayoutsIn(0, clazz);
            for (Package.Class.Field field : clazz.getFields()) {
                this.visitAttributeLayoutsIn(1, field);
            }
            for (Package.Class.Method n4 : clazz.getMethods()) {
                this.visitAttributeLayoutsIn(2, n4);
                if (n4.code == null) continue;
                this.visitAttributeLayoutsIn(3, n4.code);
            }
        }
        for (n = 0; n < 4; ++n) {
            int n2 = this.allLayouts.get(n).size();
            boolean bl = this.haveFlagsHi(n);
            if (n2 >= 24) {
                int n3 = 1 << 9 + n;
                this.archiveOptions |= n3;
                bl = true;
                if (this.verbose > 0) {
                    Utils.log.info("Note: Many " + Attribute.contextName(n) + " attributes forces 63-bit flags");
                }
            }
            if (this.verbose > 1) {
                Utils.log.fine(Attribute.contextName(n) + ".maxFlags = 0x" + Integer.toHexString(this.maxFlags[n]));
                Utils.log.fine(Attribute.contextName(n) + ".#layouts = " + n2);
            }
            assert (this.haveFlagsHi(n) == bl);
        }
        this.initAttrIndexLimit();
        for (n = 0; n < 4; ++n) {
            assert ((this.attrFlagMask[n] & (long)this.maxFlags[n]) == 0L);
        }
        this.backCountTable = new HashMap<Attribute.Layout, int[]>();
        this.attrCounts = new int[4][];
        for (n = 0; n < 4; ++n) {
            long l = ((long)this.maxFlags[n] | this.attrFlagMask[n]) ^ 0xFFFFFFFFFFFFFFFFL;
            assert (this.attrIndexLimit[n] > 0);
            assert (this.attrIndexLimit[n] < 64);
            l &= (1L << this.attrIndexLimit[n]) - 1L;
            boolean bl = false;
            Map<Attribute.Layout, int[]> map = this.allLayouts.get(n);
            Map.Entry[] entryArray = new Map.Entry[map.size()];
            map.entrySet().toArray(entryArray);
            Arrays.sort(entryArray, new Comparator<Map.Entry<Attribute.Layout, int[]>>(){

                @Override
                public int compare(Map.Entry<Attribute.Layout, int[]> entry, Map.Entry<Attribute.Layout, int[]> entry2) {
                    int n = -(entry.getValue()[0] - entry2.getValue()[0]);
                    if (n != 0) {
                        return n;
                    }
                    return entry.getKey().compareTo(entry2.getKey());
                }
            });
            this.attrCounts[n] = new int[this.attrIndexLimit[n] + entryArray.length];
            for (int i = 0; i < entryArray.length; ++i) {
                int n4;
                Map.Entry entry = entryArray[i];
                Attribute.Layout layout = (Attribute.Layout)entry.getKey();
                int n5 = ((int[])entry.getValue())[0];
                Integer n6 = (Integer)this.attrIndexTable.get(layout);
                if (n6 != null) {
                    n4 = n6;
                } else if (l != 0L) {
                    void var4_14;
                    while ((l & 1L) == 0L) {
                        l >>>= 1;
                        ++var4_14;
                    }
                    --l;
                    n4 = this.setAttributeLayoutIndex(layout, (int)var4_14);
                } else {
                    n4 = this.setAttributeLayoutIndex(layout, -1);
                }
                this.attrCounts[n][n4] = n5;
                Attribute.Layout.Element[] elementArray = layout.getCallables();
                int[] nArray = new int[elementArray.length];
                for (int j = 0; j < elementArray.length; ++j) {
                    assert (elementArray[j].kind == 10);
                    if (elementArray[j].flagTest((byte)8)) continue;
                    nArray[j] = -1;
                }
                this.backCountTable.put(layout, nArray);
                if (n6 != null) continue;
                ConstantPool.Utf8Entry utf8Entry = ConstantPool.getUtf8Entry(layout.name());
                String string = layout.layoutForClassVersion(this.getHighestClassVersion());
                ConstantPool.Utf8Entry utf8Entry2 = ConstantPool.getUtf8Entry(string);
                this.requiredEntries.add(utf8Entry);
                this.requiredEntries.add(utf8Entry2);
                if (this.verbose <= 0) continue;
                if (n4 < this.attrIndexLimit[n]) {
                    Utils.log.info("Using free flag bit 1<<" + n4 + " for " + n5 + " occurrences of " + layout);
                    continue;
                }
                Utils.log.info("Using overflow index " + n4 + " for " + n5 + " occurrences of " + layout);
            }
        }
        this.maxFlags = null;
        this.allLayouts = null;
    }

    void visitAttributeLayoutsIn(int n, Attribute.Holder holder) {
        int n2 = n;
        this.maxFlags[n2] = this.maxFlags[n2] | holder.flags;
        for (Attribute attribute : holder.getAttributes()) {
            Attribute.Layout layout = attribute.layout();
            Map<Attribute.Layout, int[]> map = this.allLayouts.get(n);
            int[] nArray = map.get(layout);
            if (nArray == null) {
                nArray = new int[1];
                map.put(layout, nArray);
            }
            if (nArray[0] >= Integer.MAX_VALUE) continue;
            nArray[0] = nArray[0] + 1;
        }
    }

    void writeAttrDefs() throws IOException {
        Object object;
        int n;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (n = 0; n < 4; ++n) {
            int n2 = ((List)this.attrDefs.get(n)).size();
            for (int i = 0; i < n2; ++i) {
                int n3 = n;
                if (i < this.attrIndexLimit[n]) {
                    assert ((n3 |= i + 1 << 2) < 256);
                    if (!PackageWriter.testBit(this.attrDefSeen[n], 1L << i)) continue;
                }
                object = (Attribute.Layout)((List)this.attrDefs.get(n)).get(i);
                arrayList.add(new Object[]{n3, object});
                assert (Integer.valueOf(i).equals(this.attrIndexTable.get(object)));
            }
        }
        n = arrayList.size();
        Object[][] objectArrayArray = new Object[n][];
        arrayList.toArray((T[])objectArrayArray);
        Arrays.sort(objectArrayArray, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] objectArray, Object[] objectArray2) {
                int n = ((Comparable)objectArray[0]).compareTo(objectArray2[0]);
                if (n != 0) {
                    return n;
                }
                Integer n2 = (Integer)PackageWriter.this.attrIndexTable.get(objectArray[1]);
                Integer n3 = (Integer)PackageWriter.this.attrIndexTable.get(objectArray2[1]);
                assert (n2 != null);
                assert (n3 != null);
                return n2.compareTo(n3);
            }
        });
        this.attrDefsWritten = new Attribute.Layout[n];
        try (PrintStream printStream = !this.optDumpBands ? null : new PrintStream(PackageWriter.getDumpStream(this.attr_definition_headers, ".def"));){
            object = Arrays.copyOf(this.attrIndexLimit, 4);
            for (int i = 0; i < objectArrayArray.length; ++i) {
                Object object2;
                Attribute.Layout layout;
                int n4 = (Integer)objectArrayArray[i][0];
                this.attrDefsWritten[i] = layout = (Attribute.Layout)objectArrayArray[i][1];
                assert ((n4 & 3) == layout.ctype());
                this.attr_definition_headers.putByte(n4);
                this.attr_definition_name.putRef(ConstantPool.getUtf8Entry(layout.name()));
                String string = layout.layoutForClassVersion(this.getHighestClassVersion());
                this.attr_definition_layout.putRef(ConstantPool.getUtf8Entry(string));
                boolean bl = false;
                if (!$assertionsDisabled) {
                    bl = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (bl) {
                    object2 = (n4 >> 2) - 1;
                    if (object2 < 0) {
                        Object object3 = object;
                        int n5 = layout.ctype();
                        Object object4 = object3[n5];
                        object3[n5] = object4 + true;
                        object2 = object4;
                    }
                    int n6 = (Integer)this.attrIndexTable.get(layout);
                    assert (object2 == n6);
                }
                if (printStream == null) continue;
                object2 = (n4 >> 2) - 1;
                printStream.println(object2 + " " + layout);
            }
        }
    }

    void writeAttrCounts() throws IOException {
        block0: for (int i = 0; i < 4; ++i) {
            BandStructure.MultiBand multiBand = this.attrBands[i];
            BandStructure.IntBand intBand = PackageWriter.getAttrBand(multiBand, 4);
            Attribute.Layout[] layoutArray = new Attribute.Layout[((List)this.attrDefs.get(i)).size()];
            ((List)this.attrDefs.get(i)).toArray(layoutArray);
            boolean bl = true;
            while (true) {
                for (int j = 0; j < layoutArray.length; ++j) {
                    int n;
                    Attribute.Layout layout = layoutArray[j];
                    if (layout == null || bl != this.isPredefinedAttr(i, j) || (n = this.attrCounts[i][j]) == 0) continue;
                    int[] nArray = this.backCountTable.get(layout);
                    for (int k = 0; k < nArray.length; ++k) {
                        if (nArray[k] >= 0) {
                            int n2 = nArray[k];
                            nArray[k] = -1;
                            intBand.putInt(n2);
                            assert (layout.getCallables()[k].flagTest((byte)8));
                            continue;
                        }
                        assert (!layout.getCallables()[k].flagTest((byte)8));
                    }
                }
                if (!bl) continue block0;
                bl = false;
            }
        }
    }

    void trimClassAttributes() {
        for (Package.Class clazz : this.pkg.classes) {
            clazz.minimizeSourceFile();
            assert (clazz.getAttribute(Package.attrBootstrapMethodsEmpty) == null);
        }
    }

    void collectInnerClasses() {
        HashMap<ConstantPool.ClassEntry, Package.InnerClass> hashMap = new HashMap<ConstantPool.ClassEntry, Package.InnerClass>();
        for (Package.Class object : this.pkg.classes) {
            if (!object.hasInnerClasses()) continue;
            for (Package.InnerClass innerClass : object.getInnerClasses()) {
                Package.InnerClass innerClass2 = hashMap.put(innerClass.thisClass, innerClass);
                if (innerClass2 == null || innerClass2.equals(innerClass) || !innerClass2.predictable) continue;
                hashMap.put(innerClass2.thisClass, innerClass2);
            }
        }
        Object[] objectArray = new Package.InnerClass[hashMap.size()];
        hashMap.values().toArray(objectArray);
        hashMap = null;
        Arrays.sort(objectArray);
        this.pkg.setAllInnerClasses(Arrays.asList(objectArray));
        for (Package.Class clazz : this.pkg.classes) {
            clazz.minimizeLocalICs();
        }
    }

    void writeInnerClasses() throws IOException {
        for (Package.InnerClass innerClass : this.pkg.getAllInnerClasses()) {
            int n = innerClass.flags;
            assert ((n & 0x10000) == 0);
            if (!innerClass.predictable) {
                n |= 0x10000;
            }
            this.ic_this_class.putRef(innerClass.thisClass);
            this.ic_flags.putInt(n);
            if (innerClass.predictable) continue;
            this.ic_outer_class.putRef(innerClass.outerClass);
            this.ic_name.putRef(innerClass.name);
        }
    }

    void writeLocalInnerClasses(Package.Class clazz) throws IOException {
        List<Package.InnerClass> list = clazz.getInnerClasses();
        this.class_InnerClasses_N.putInt(list.size());
        for (Package.InnerClass innerClass : list) {
            this.class_InnerClasses_RC.putRef(innerClass.thisClass);
            if (innerClass.equals(this.pkg.getGlobalInnerClass(innerClass.thisClass))) {
                this.class_InnerClasses_F.putInt(0);
                continue;
            }
            int n = innerClass.flags;
            if (n == 0) {
                n = 65536;
            }
            this.class_InnerClasses_F.putInt(n);
            this.class_InnerClasses_outer_RCN.putRef(innerClass.outerClass);
            this.class_InnerClasses_name_RUN.putRef(innerClass.name);
        }
    }

    void writeClassesAndByteCodes() throws IOException {
        Package.Class[] classArray = new Package.Class[this.pkg.classes.size()];
        this.pkg.classes.toArray(classArray);
        if (this.verbose > 0) {
            Utils.log.info("  ...scanning " + classArray.length + " classes...");
        }
        int n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            Package.Class clazz = classArray[i];
            if (this.verbose > 1) {
                Utils.log.fine("Scanning " + clazz);
            }
            ConstantPool.ClassEntry classEntry = clazz.thisClass;
            ConstantPool.ClassEntry classEntry2 = clazz.superClass;
            ConstantPool.ClassEntry[] classEntryArray = clazz.interfaces;
            assert (classEntry2 != classEntry);
            if (classEntry2 == null) {
                classEntry2 = classEntry;
            }
            this.class_this.putRef(classEntry);
            this.class_super.putRef(classEntry2);
            this.class_interface_count.putInt(clazz.interfaces.length);
            for (int j = 0; j < classEntryArray.length; ++j) {
                this.class_interface.putRef(classEntryArray[j]);
            }
            this.writeMembers(clazz);
            this.writeAttrs(0, clazz, clazz);
            if (this.verbose <= 0 || ++n % 1000 != 0) continue;
            Utils.log.info("Have scanned " + n + " classes...");
        }
    }

    void writeMembers(Package.Class clazz) throws IOException {
        List<Package.Class.Field> list = clazz.getFields();
        this.class_field_count.putInt(list.size());
        for (Package.Class.Field object2 : list) {
            this.field_descr.putRef(object2.getDescriptor());
            this.writeAttrs(1, object2, clazz);
        }
        List<Package.Class.Method> list2 = clazz.getMethods();
        this.class_method_count.putInt(list2.size());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Package.Class.Method method = (Package.Class.Method)iterator.next();
            this.method_descr.putRef(method.getDescriptor());
            this.writeAttrs(2, method, clazz);
            assert (method.code != null == (method.getAttribute(this.attrCodeEmpty) != null));
            if (method.code == null) continue;
            this.writeCodeHeader(method.code);
            this.writeByteCodes(method.code);
        }
    }

    void writeCodeHeader(Code code) throws IOException {
        boolean bl = PackageWriter.testBit(this.archiveOptions, 4);
        int n = code.attributeSize();
        int n2 = PackageWriter.shortCodeHeader(code);
        if (!bl && n > 0) {
            n2 = 0;
        }
        if (this.verbose > 2) {
            int n3 = code.getMethod().getArgumentSize();
            Utils.log.fine("Code sizes info " + code.max_stack + " " + code.max_locals + " " + code.getHandlerCount() + " " + n3 + " " + n + (n2 > 0 ? " SHORT=" + n2 : ""));
        }
        this.code_headers.putByte(n2);
        if (n2 == 0) {
            this.code_max_stack.putInt(code.getMaxStack());
            this.code_max_na_locals.putInt(code.getMaxNALocals());
            this.code_handler_count.putInt(code.getHandlerCount());
        } else {
            assert (bl || n == 0);
            assert (code.getHandlerCount() < this.shortCodeHeader_h_limit);
        }
        this.writeCodeHandlers(code);
        if (n2 == 0 || bl) {
            this.writeAttrs(3, code, code.thisClass());
        }
    }

    void writeCodeHandlers(Code code) throws IOException {
        int n = code.getHandlerCount();
        for (int i = 0; i < n; ++i) {
            this.code_handler_class_RCN.putRef(code.handler_class[i]);
            int n2 = code.encodeBCI(code.handler_start[i]);
            this.code_handler_start_P.putInt(n2);
            int n3 = code.encodeBCI(code.handler_end[i]) - n2;
            this.code_handler_end_PO.putInt(n3);
            n2 += n3;
            n3 = code.encodeBCI(code.handler_catch[i]) - n2;
            this.code_handler_catch_PO.putInt(n3);
        }
    }

    void writeAttrs(int n, final Attribute.Holder holder, Package.Class clazz) throws IOException {
        BandStructure.MultiBand multiBand = this.attrBands[n];
        BandStructure.IntBand intBand = PackageWriter.getAttrBand(multiBand, 0);
        BandStructure.IntBand intBand2 = PackageWriter.getAttrBand(multiBand, 1);
        boolean bl = this.haveFlagsHi(n);
        assert (this.attrIndexLimit[n] == (bl ? 63 : 32));
        if (holder.attributes == null) {
            intBand2.putInt(holder.flags);
            if (bl) {
                intBand.putInt(0);
            }
            return;
        }
        if (this.verbose > 3) {
            Utils.log.fine("Transmitting attrs for " + holder + " flags=" + Integer.toHexString(holder.flags));
        }
        long l = this.attrFlagMask[n];
        long l2 = 0L;
        int n2 = 0;
        for (Attribute attribute : holder.attributes) {
            boolean bl2;
            BandStructure.Band[] bandArray;
            Attribute.Layout layout = attribute.layout();
            int n3 = (Integer)this.attrIndexTable.get(layout);
            assert (((List)this.attrDefs.get(n)).get(n3) == layout);
            if (this.verbose > 3) {
                Utils.log.fine("add attr @" + n3 + " " + attribute + " in " + holder);
            }
            if (n3 < this.attrIndexLimit[n] && PackageWriter.testBit(l, 1L << n3)) {
                if (this.verbose > 3) {
                    Utils.log.fine("Adding flag bit 1<<" + n3 + " in " + Long.toHexString(l));
                }
                assert (!PackageWriter.testBit((long)holder.flags, 1L << n3));
                l2 |= 1L << n3;
                l -= 1L << n3;
            } else {
                l2 |= 0x10000L;
                ++n2;
                if (this.verbose > 3) {
                    Utils.log.fine("Adding overflow attr #" + n2);
                }
                bandArray = PackageWriter.getAttrBand(multiBand, 3);
                bandArray.putInt(n3);
            }
            if (layout.bandCount == 0) {
                if (layout != this.attrInnerClassesEmpty) continue;
                this.writeLocalInnerClasses((Package.Class)holder);
                continue;
            }
            assert (attribute.fixups == null);
            bandArray = (BandStructure.Band[])this.attrBandTable.get(layout);
            assert (bandArray != null);
            assert (bandArray.length == layout.bandCount);
            final int[] nArray = this.backCountTable.get(layout);
            assert (nArray != null);
            assert (nArray.length == layout.getCallables().length);
            if (this.verbose > 2) {
                Utils.log.fine("writing " + attribute + " in " + holder);
            }
            boolean bl3 = bl2 = n == 1 && layout == this.attrConstantValue;
            if (bl2) {
                this.setConstantValueIndex((Package.Class.Field)holder);
            }
            attribute.parse(clazz, attribute.bytes(), 0, attribute.size(), new Attribute.ValueStream(){

                @Override
                public void putInt(int n, int n2) {
                    ((BandStructure.IntBand)bandArray[n]).putInt(n2);
                }

                @Override
                public void putRef(int n, ConstantPool.Entry entry) {
                    ((BandStructure.CPRefBand)bandArray[n]).putRef(entry);
                }

                @Override
                public int encodeBCI(int n) {
                    Code code = (Code)holder;
                    return code.encodeBCI(n);
                }

                @Override
                public void noteBackCall(int n) {
                    assert (nArray[n] >= 0);
                    int n2 = n;
                    nArray[n2] = nArray[n2] + 1;
                }
            });
            if (!bl2) continue;
            this.setConstantValueIndex(null);
        }
        if (n2 > 0) {
            BandStructure.IntBand intBand3 = PackageWriter.getAttrBand(multiBand, 2);
            intBand3.putInt(n2);
        }
        intBand2.putInt(holder.flags | (int)l2);
        if (bl) {
            intBand.putInt((int)(l2 >>> 32));
        } else assert (l2 >>> 32 == 0L);
        assert (((long)holder.flags & l2) == 0L) : holder + ".flags=" + Integer.toHexString(holder.flags) + "^" + Long.toHexString(l2);
    }

    private void beginCode(Code code) {
        assert (this.curCode == null);
        this.curCode = code;
        this.curClass = code.m.thisClass();
        this.curCPMap = code.getCPMap();
    }

    private void endCode() {
        this.curCode = null;
        this.curClass = null;
        this.curCPMap = null;
    }

    private int initOpVariant(Instruction instruction, ConstantPool.Entry entry) {
        if (instruction.getBC() != 183) {
            return -1;
        }
        ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)instruction.getCPRef(this.curCPMap);
        if (!"<init>".equals(memberEntry.descRef.nameRef.stringValue())) {
            return -1;
        }
        ConstantPool.ClassEntry classEntry = memberEntry.classRef;
        if (classEntry == this.curClass.thisClass) {
            return 230;
        }
        if (classEntry == this.curClass.superClass) {
            return 231;
        }
        if (classEntry == entry) {
            return 232;
        }
        return -1;
    }

    private int selfOpVariant(Instruction instruction) {
        int n = instruction.getBC();
        if (n < 178 || n > 184) {
            return -1;
        }
        ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)instruction.getCPRef(this.curCPMap);
        if ((n == 183 || n == 184) && memberEntry.tagEquals(11)) {
            return -1;
        }
        ConstantPool.ClassEntry classEntry = memberEntry.classRef;
        int n2 = 202 + (n - 178);
        if (classEntry == this.curClass.thisClass) {
            return n2;
        }
        if (classEntry == this.curClass.superClass) {
            return n2 + 14;
        }
        return -1;
    }

    void writeByteCodes(Code code) throws IOException {
        this.beginCode(code);
        ConstantPool.IndexGroup indexGroup = this.pkg.cp;
        boolean bl = false;
        ConstantPool.Entry entry = null;
        block44: for (Instruction instruction = code.instructionAt(0); instruction != null; instruction = instruction.next()) {
            Object object;
            Instruction instruction2;
            int n;
            if (this.verbose > 3) {
                Utils.log.fine(instruction.toString());
            }
            if (instruction.isNonstandard()) {
                String string = code.getMethod() + " contains an unrecognized bytecode " + instruction + "; please use the pass-file option on this class.";
                Utils.log.warning(string);
                throw new IOException(string);
            }
            if (instruction.isWide()) {
                if (this.verbose > 1) {
                    Utils.log.fine("_wide opcode in " + code);
                    Utils.log.fine(instruction.toString());
                }
                this.bc_codes.putByte(196);
                this.codeHist[196] = this.codeHist[196] + 1;
            }
            if ((n = instruction.getBC()) == 42 && this.selfOpVariant(instruction2 = code.instructionAt(instruction.getNextPC())) >= 0) {
                bl = true;
                continue;
            }
            int n2 = this.initOpVariant(instruction, entry);
            if (n2 >= 0) {
                if (bl) {
                    this.bc_codes.putByte(42);
                    this.codeHist[42] = this.codeHist[42] + 1;
                    bl = false;
                }
                this.bc_codes.putByte(n2);
                int n3 = n2;
                this.codeHist[n3] = this.codeHist[n3] + 1;
                ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)instruction.getCPRef(this.curCPMap);
                int n4 = indexGroup.getOverloadingIndex(memberEntry);
                this.bc_initref.putInt(n4);
                continue;
            }
            int n5 = this.selfOpVariant(instruction);
            if (n5 >= 0) {
                boolean bl2 = Instruction.isFieldOp(n);
                boolean bl3 = n5 >= 216;
                boolean bl4 = bl;
                bl = false;
                if (bl4) {
                    n5 += 7;
                }
                this.bc_codes.putByte(n5);
                int n6 = n5;
                this.codeHist[n6] = this.codeHist[n6] + 1;
                ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)instruction.getCPRef(this.curCPMap);
                object = this.selfOpRefBand(n5);
                ConstantPool.Index index = indexGroup.getMemberIndex(memberEntry.tag, memberEntry.classRef);
                ((BandStructure.CPRefBand)object).putRef((ConstantPool.Entry)memberEntry, index);
                continue;
            }
            assert (!bl);
            int n7 = n;
            this.codeHist[n7] = this.codeHist[n7] + 1;
            switch (n) {
                case 170: 
                case 171: {
                    int n8;
                    this.bc_codes.putByte(n);
                    Instruction.Switch switch_ = (Instruction.Switch)instruction;
                    int n9 = switch_.getAlignedPC();
                    int n10 = switch_.getNextPC();
                    int n11 = switch_.getCaseCount();
                    this.bc_case_count.putInt(n11);
                    this.putLabel(this.bc_label, code, instruction.getPC(), switch_.getDefaultLabel());
                    for (n8 = 0; n8 < n11; ++n8) {
                        this.putLabel(this.bc_label, code, instruction.getPC(), switch_.getCaseLabel(n8));
                    }
                    if (n == 170) {
                        this.bc_case_value.putInt(switch_.getCaseValue(0));
                        continue block44;
                    }
                    for (n8 = 0; n8 < n11; ++n8) {
                        this.bc_case_value.putInt(switch_.getCaseValue(n8));
                    }
                    continue block44;
                }
                default: {
                    int n12 = instruction.getBranchLabel();
                    if (n12 >= 0) {
                        this.bc_codes.putByte(n);
                        this.putLabel(this.bc_label, code, instruction.getPC(), n12);
                        continue block44;
                    }
                    ConstantPool.Entry entry2 = instruction.getCPRef(this.curCPMap);
                    if (entry2 != null) {
                        BandStructure.CPRefBand cPRefBand;
                        if (n == 187) {
                            entry = entry2;
                        }
                        if (n == 18) {
                            byte by = entry2.tag;
                            this.ldcHist[by] = this.ldcHist[by] + 1;
                        }
                        int n13 = n;
                        block3 : switch (instruction.getCPTag()) {
                            case 51: {
                                switch (entry2.tag) {
                                    case 3: {
                                        cPRefBand = this.bc_intref;
                                        switch (n) {
                                            case 18: {
                                                n13 = 234;
                                                break block3;
                                            }
                                            case 19: {
                                                n13 = 237;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                    case 4: {
                                        cPRefBand = this.bc_floatref;
                                        switch (n) {
                                            case 18: {
                                                n13 = 235;
                                                break block3;
                                            }
                                            case 19: {
                                                n13 = 238;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                    case 5: {
                                        cPRefBand = this.bc_longref;
                                        assert (n == 20);
                                        n13 = 20;
                                        break block3;
                                    }
                                    case 6: {
                                        cPRefBand = this.bc_doubleref;
                                        assert (n == 20);
                                        n13 = 239;
                                        break block3;
                                    }
                                    case 8: {
                                        cPRefBand = this.bc_stringref;
                                        switch (n) {
                                            case 18: {
                                                n13 = 18;
                                                break block3;
                                            }
                                            case 19: {
                                                n13 = 19;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                    case 7: {
                                        cPRefBand = this.bc_classref;
                                        switch (n) {
                                            case 18: {
                                                n13 = 233;
                                                break block3;
                                            }
                                            case 19: {
                                                n13 = 236;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                    default: {
                                        if (this.getHighestClassVersion().lessThan(Constants.JAVA7_MAX_CLASS_VERSION)) {
                                            throw new IOException("bad class file major version for Java 7 ldc");
                                        }
                                        cPRefBand = this.bc_loadablevalueref;
                                        switch (n) {
                                            case 18: {
                                                n13 = 240;
                                                break block3;
                                            }
                                            case 19: {
                                                n13 = 241;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                }
                            }
                            case 7: {
                                if (entry2 == this.curClass.thisClass) {
                                    entry2 = null;
                                }
                                cPRefBand = this.bc_classref;
                                break;
                            }
                            case 9: {
                                cPRefBand = this.bc_fieldref;
                                break;
                            }
                            case 10: {
                                if (entry2.tagEquals(11)) {
                                    if (n == 183) {
                                        n13 = 242;
                                    }
                                    if (n == 184) {
                                        n13 = 243;
                                    }
                                    cPRefBand = this.bc_imethodref;
                                    break;
                                }
                                cPRefBand = this.bc_methodref;
                                break;
                            }
                            case 11: {
                                cPRefBand = this.bc_imethodref;
                                break;
                            }
                            case 18: {
                                cPRefBand = this.bc_indyref;
                                break;
                            }
                            default: {
                                cPRefBand = null;
                                assert (false);
                                break;
                            }
                        }
                        if (entry2 != null && cPRefBand.index != null && !cPRefBand.index.contains(entry2)) {
                            object = code.getMethod() + " contains a bytecode " + instruction + " with an unsupported constant reference; please use the pass-file option on this class.";
                            Utils.log.warning((String)object);
                            throw new IOException((String)object);
                        }
                        this.bc_codes.putByte(n13);
                        cPRefBand.putRef(entry2);
                        if (n == 197) {
                            assert (instruction.getConstant() == code.getByte(instruction.getPC() + 3));
                            this.bc_byte.putByte(0xFF & instruction.getConstant());
                            continue block44;
                        }
                        if (n == 185) {
                            assert (instruction.getLength() == 5);
                            assert (instruction.getConstant() == 1 + ((ConstantPool.MemberEntry)entry2).descRef.typeRef.computeSize(true) << 8);
                            continue block44;
                        }
                        if (n == 186) {
                            if (this.getHighestClassVersion().lessThan(Constants.JAVA7_MAX_CLASS_VERSION)) {
                                throw new IOException("bad class major version for Java 7 invokedynamic");
                            }
                            assert (instruction.getLength() == 5);
                            assert (instruction.getConstant() == 0);
                            continue block44;
                        }
                        assert (instruction.getLength() == (n == 18 ? 2 : 3));
                        continue block44;
                    }
                    int n14 = instruction.getLocalSlot();
                    if (n14 >= 0) {
                        this.bc_codes.putByte(n);
                        this.bc_local.putInt(n14);
                        int n15 = instruction.getConstant();
                        if (n == 132) {
                            if (!instruction.isWide()) {
                                this.bc_byte.putByte(0xFF & n15);
                                continue block44;
                            }
                            this.bc_short.putInt(0xFFFF & n15);
                            continue block44;
                        }
                        assert (n15 == 0);
                        continue block44;
                    }
                    this.bc_codes.putByte(n);
                    int n16 = instruction.getPC() + 1;
                    int n17 = instruction.getNextPC();
                    if (n16 >= n17) continue block44;
                    switch (n) {
                        case 17: {
                            this.bc_short.putInt(0xFFFF & instruction.getConstant());
                            continue block44;
                        }
                        case 16: {
                            this.bc_byte.putByte(0xFF & instruction.getConstant());
                            continue block44;
                        }
                        case 188: {
                            this.bc_byte.putByte(0xFF & instruction.getConstant());
                            continue block44;
                        }
                    }
                    assert (false);
                    continue block44;
                }
            }
        }
        this.bc_codes.putByte(255);
        ++this.bc_codes.elementCountForDebug;
        this.codeHist[255] = this.codeHist[255] + 1;
        this.endCode();
    }

    void printCodeHist() {
        int n;
        assert (this.verbose > 0);
        Object[] objectArray = new String[this.codeHist.length];
        int n2 = 0;
        for (n = 0; n < this.codeHist.length; ++n) {
            n2 += this.codeHist[n];
        }
        for (n = 0; n < this.codeHist.length; ++n) {
            if (this.codeHist[n] == 0) {
                objectArray[n] = "";
                continue;
            }
            String string = Instruction.byteName(n);
            String string2 = "" + this.codeHist[n];
            string2 = "         ".substring(string2.length()) + string2;
            String string3 = "" + this.codeHist[n] * 10000 / n2;
            while (string3.length() < 4) {
                string3 = "0" + string3;
            }
            string3 = string3.substring(0, string3.length() - 2) + "." + string3.substring(string3.length() - 2);
            objectArray[n] = string2 + "  " + string3 + "%  " + string;
        }
        Arrays.sort(objectArray);
        System.out.println("Bytecode histogram [" + n2 + "]");
        n = objectArray.length;
        while (--n >= 0) {
            if ("".equals(objectArray[n])) continue;
            System.out.println((String)objectArray[n]);
        }
        for (n = 0; n < this.ldcHist.length; ++n) {
            int n3 = this.ldcHist[n];
            if (n3 == 0) continue;
            System.out.println("ldc " + ConstantPool.tagName(n) + " " + n3);
        }
    }
}

