/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;

public class OpenMBeanInfoSupport
extends MBeanInfo
implements OpenMBeanInfo {
    static final long serialVersionUID = 4349395935420511492L;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public OpenMBeanInfoSupport(String string, String string2, OpenMBeanAttributeInfo[] openMBeanAttributeInfoArray, OpenMBeanConstructorInfo[] openMBeanConstructorInfoArray, OpenMBeanOperationInfo[] openMBeanOperationInfoArray, MBeanNotificationInfo[] mBeanNotificationInfoArray) {
        this(string, string2, openMBeanAttributeInfoArray, openMBeanConstructorInfoArray, openMBeanOperationInfoArray, mBeanNotificationInfoArray, (Descriptor)null);
    }

    public OpenMBeanInfoSupport(String string, String string2, OpenMBeanAttributeInfo[] openMBeanAttributeInfoArray, OpenMBeanConstructorInfo[] openMBeanConstructorInfoArray, OpenMBeanOperationInfo[] openMBeanOperationInfoArray, MBeanNotificationInfo[] mBeanNotificationInfoArray, Descriptor descriptor) {
        super(string, string2, OpenMBeanInfoSupport.attributeArray(openMBeanAttributeInfoArray), OpenMBeanInfoSupport.constructorArray(openMBeanConstructorInfoArray), OpenMBeanInfoSupport.operationArray(openMBeanOperationInfoArray), mBeanNotificationInfoArray == null ? null : (MBeanNotificationInfo[])mBeanNotificationInfoArray.clone(), descriptor);
    }

    private static MBeanAttributeInfo[] attributeArray(OpenMBeanAttributeInfo[] openMBeanAttributeInfoArray) {
        if (openMBeanAttributeInfoArray == null) {
            return null;
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[openMBeanAttributeInfoArray.length];
        System.arraycopy(openMBeanAttributeInfoArray, 0, mBeanAttributeInfoArray, 0, openMBeanAttributeInfoArray.length);
        return mBeanAttributeInfoArray;
    }

    private static MBeanConstructorInfo[] constructorArray(OpenMBeanConstructorInfo[] openMBeanConstructorInfoArray) {
        if (openMBeanConstructorInfoArray == null) {
            return null;
        }
        MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[openMBeanConstructorInfoArray.length];
        System.arraycopy(openMBeanConstructorInfoArray, 0, mBeanConstructorInfoArray, 0, openMBeanConstructorInfoArray.length);
        return mBeanConstructorInfoArray;
    }

    private static MBeanOperationInfo[] operationArray(OpenMBeanOperationInfo[] openMBeanOperationInfoArray) {
        if (openMBeanOperationInfoArray == null) {
            return null;
        }
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[openMBeanOperationInfoArray.length];
        System.arraycopy(openMBeanOperationInfoArray, 0, mBeanOperationInfoArray, 0, openMBeanOperationInfoArray.length);
        return mBeanOperationInfoArray;
    }

    @Override
    public boolean equals(Object object) {
        OpenMBeanInfo openMBeanInfo;
        if (object == null) {
            return false;
        }
        try {
            openMBeanInfo = (OpenMBeanInfo)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!Objects.equals(this.getClassName(), openMBeanInfo.getClassName())) {
            return false;
        }
        if (!OpenMBeanInfoSupport.sameArrayContents(this.getAttributes(), openMBeanInfo.getAttributes())) {
            return false;
        }
        if (!OpenMBeanInfoSupport.sameArrayContents(this.getConstructors(), openMBeanInfo.getConstructors())) {
            return false;
        }
        if (!OpenMBeanInfoSupport.sameArrayContents(this.getOperations(), openMBeanInfo.getOperations())) {
            return false;
        }
        return OpenMBeanInfoSupport.sameArrayContents(this.getNotifications(), openMBeanInfo.getNotifications());
    }

    private static <T> boolean sameArrayContents(T[] TArray, T[] TArray2) {
        return new HashSet<T>(Arrays.asList(TArray)).equals(new HashSet<T>(Arrays.asList(TArray2)));
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            int n = 0;
            if (this.getClassName() != null) {
                n += this.getClassName().hashCode();
            }
            n += OpenMBeanInfoSupport.arraySetHash(this.getAttributes());
            n += OpenMBeanInfoSupport.arraySetHash(this.getConstructors());
            n += OpenMBeanInfoSupport.arraySetHash(this.getOperations());
            this.myHashCode = n += OpenMBeanInfoSupport.arraySetHash(this.getNotifications());
        }
        return this.myHashCode;
    }

    private static <T> int arraySetHash(T[] TArray) {
        return new HashSet<T>(Arrays.asList(TArray)).hashCode();
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            this.myToString = this.getClass().getName() + "(mbean_class_name=" + this.getClassName() + ",attributes=" + Arrays.asList(this.getAttributes()).toString() + ",constructors=" + Arrays.asList(this.getConstructors()).toString() + ",operations=" + Arrays.asList(this.getOperations()).toString() + ",notifications=" + Arrays.asList(this.getNotifications()).toString() + ",descriptor=" + this.getDescriptor() + ")";
        }
        return this.myToString;
    }
}

