/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.GSSHeader;
import sun.security.jgss.krb5.CipherHelper;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.MessageToken_v2;
import sun.security.krb5.Confounder;

class WrapToken_v2
extends MessageToken_v2 {
    byte[] confounder = null;
    private final boolean privacy;

    public WrapToken_v2(Krb5Context krb5Context, byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        super(1284, krb5Context, byArray, n, n2, messageProp);
        this.privacy = messageProp.getPrivacy();
    }

    public WrapToken_v2(Krb5Context krb5Context, InputStream inputStream, MessageProp messageProp) throws GSSException {
        super(1284, krb5Context, inputStream, messageProp);
        this.privacy = messageProp.getPrivacy();
    }

    public byte[] getData() throws GSSException {
        byte[] byArray = new byte[this.tokenDataLen];
        int n = this.getData(byArray, 0);
        return Arrays.copyOf(byArray, n);
    }

    public int getData(byte[] byArray, int n) throws GSSException {
        if (this.privacy) {
            this.cipherHelper.decryptData(this, this.tokenData, 0, this.tokenDataLen, byArray, n, this.getKeyUsage());
            return this.tokenDataLen - 16 - 16 - this.cipherHelper.getChecksumLength();
        }
        int n2 = this.tokenDataLen - this.cipherHelper.getChecksumLength();
        System.arraycopy(this.tokenData, 0, byArray, n, n2);
        if (!this.verifySign(byArray, n, n2)) {
            throw new GSSException(6, -1, "Corrupt checksum in Wrap token");
        }
        return n2;
    }

    public WrapToken_v2(Krb5Context krb5Context, MessageProp messageProp, byte[] byArray, int n, int n2) throws GSSException {
        super(1284, krb5Context);
        this.confounder = Confounder.bytes(16);
        this.genSignAndSeqNumber(messageProp, byArray, n, n2);
        if (!krb5Context.getConfState()) {
            messageProp.setPrivacy(false);
        }
        this.privacy = messageProp.getPrivacy();
        if (!this.privacy) {
            this.tokenData = new byte[n2 + this.checksum.length];
            System.arraycopy(byArray, n, this.tokenData, 0, n2);
            System.arraycopy(this.checksum, 0, this.tokenData, n2, this.checksum.length);
        } else {
            this.tokenData = this.cipherHelper.encryptData(this, this.confounder, this.getTokenHeader(), byArray, n, n2, this.getKeyUsage());
        }
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        this.encodeHeader(outputStream);
        outputStream.write(this.tokenData);
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16 + this.tokenData.length);
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public int encode(byte[] byArray, int n) throws IOException {
        byte[] byArray2 = this.encode();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    static int getSizeLimit(int n, boolean bl, int n2, CipherHelper cipherHelper) throws GSSException {
        return GSSHeader.getMaxMechTokenSize(OID, n2) - (16 + cipherHelper.getChecksumLength() + 16) - 8;
    }
}

