/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XErrorEvent
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 20 : 40;
    }

    @Override
    public int getDataSize() {
        return XErrorEvent.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XErrorEvent(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XErrorEvent() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XErrorEvent.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_type() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_type(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public long get_display() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_display(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), l);
    }

    public long get_resourceid() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16));
    }

    public void set_resourceid(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16), l);
    }

    public long get_serial() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24));
    }

    public void set_serial(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24), l);
    }

    public byte get_error_code() {
        log.finest("");
        return Native.getByte(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 32));
    }

    public void set_error_code(byte by) {
        log.finest("");
        Native.putByte(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 32), by);
    }

    public byte get_request_code() {
        log.finest("");
        return Native.getByte(this.pData + (long)(XlibWrapper.dataModel == 32 ? 17 : 33));
    }

    public void set_request_code(byte by) {
        log.finest("");
        Native.putByte(this.pData + (long)(XlibWrapper.dataModel == 32 ? 17 : 33), by);
    }

    public byte get_minor_code() {
        log.finest("");
        return Native.getByte(this.pData + (long)(XlibWrapper.dataModel == 32 ? 18 : 34));
    }

    public void set_minor_code(byte by) {
        log.finest("");
        Native.putByte(this.pData + (long)(XlibWrapper.dataModel == 32 ? 18 : 34), by);
    }

    @Override
    String getName() {
        return "XErrorEvent";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(280);
        stringBuilder.append("type = ").append(XlibWrapper.eventToString[this.get_type()]).append(", ");
        stringBuilder.append("display = ").append(this.get_display()).append(", ");
        stringBuilder.append("resourceid = ").append(this.get_resourceid()).append(", ");
        stringBuilder.append("serial = ").append(this.get_serial()).append(", ");
        stringBuilder.append("error_code = ").append(this.get_error_code()).append(", ");
        stringBuilder.append("request_code = ").append(this.get_request_code()).append(", ");
        stringBuilder.append("minor_code = ").append(this.get_minor_code()).append(", ");
        return stringBuilder.toString();
    }
}

