/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodContext;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.lang.reflect.InvocationTargetException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.text.JTextComponent;
import sun.awt.im.InputMethodAdapter;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.macosx.CInputMethodDescriptor;
import sun.lwawt.macosx.CPlatformView;
import sun.lwawt.macosx.CPlatformWindow;
import sun.lwawt.macosx.LWCToolkit;

public class CInputMethod
extends InputMethodAdapter {
    private InputMethodContext fIMContext;
    private Component fAwtFocussedComponent;
    private LWComponentPeer fAwtFocussedComponentPeer;
    private boolean isActive;
    private static Map<TextAttribute, Integer>[] sHighlightStyles;
    private AttributedString fCurrentText = null;
    private String fCurrentTextAsString = null;
    private int fCurrentTextLength = 0;
    private static final int kCaretPosition = 0;
    private static final int kRawText = 1;
    private static final int kSelectedRawText = 2;
    private static final int kConvertedText = 3;
    private static final int kSelectedConvertedText = 4;

    @Override
    public void setInputMethodContext(InputMethodContext inputMethodContext) {
        this.fIMContext = inputMethodContext;
    }

    @Override
    public boolean setLocale(Locale locale) {
        return this.setLocale(locale, false);
    }

    private boolean setLocale(Locale locale, boolean bl) {
        Object[] objectArray = CInputMethodDescriptor.getAvailableLocalesInternal();
        for (int i = 0; i < objectArray.length; ++i) {
            Locale locale2 = (Locale)objectArray[i];
            if (!locale.equals(locale2) && (!locale2.equals(Locale.JAPAN) || !locale.equals(Locale.JAPANESE)) && (!locale2.equals(Locale.KOREA) || !locale.equals(Locale.KOREAN))) continue;
            if (this.isActive) {
                CInputMethod.setNativeLocale(locale2.toString(), bl);
            }
            return true;
        }
        return false;
    }

    @Override
    public Locale getLocale() {
        Locale locale = CInputMethod.getNativeLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    @Override
    public void setCharacterSubsets(Character.Subset[] subsetArray) {
    }

    @Override
    public void setCompositionEnabled(boolean bl) {
        throw new UnsupportedOperationException("Can't adjust composition mode on Mac OS X.");
    }

    @Override
    public boolean isCompositionEnabled() {
        throw new UnsupportedOperationException("Can't adjust composition mode on Mac OS X.");
    }

    @Override
    public void dispatchEvent(AWTEvent aWTEvent) {
    }

    @Override
    public void activate() {
        this.isActive = true;
    }

    @Override
    public void deactivate(boolean bl) {
        this.isActive = false;
    }

    @Override
    public void hideWindows() {
    }

    long getNativeViewPtr(LWComponentPeer lWComponentPeer) {
        if (lWComponentPeer.getPlatformWindow() instanceof CPlatformWindow) {
            CPlatformWindow cPlatformWindow = (CPlatformWindow)lWComponentPeer.getPlatformWindow();
            CPlatformView cPlatformView = cPlatformWindow.getContentView();
            return cPlatformView.getAWTView();
        }
        return 0L;
    }

    @Override
    public void removeNotify() {
        if (this.fAwtFocussedComponentPeer != null) {
            this.nativeEndComposition(this.getNativeViewPtr(this.fAwtFocussedComponentPeer));
        }
        this.fAwtFocussedComponentPeer = null;
    }

    @Override
    protected void setAWTFocussedComponent(Component component) {
        LWComponentPeer lWComponentPeer = null;
        long l = 0L;
        CInputMethod cInputMethod = this;
        if (component == null) {
            lWComponentPeer = this.fAwtFocussedComponentPeer;
            cInputMethod = null;
        } else {
            lWComponentPeer = this.getNearestNativePeer(component);
            if (component.getInputMethodRequests() == null) {
                cInputMethod = null;
            }
        }
        if (lWComponentPeer != null) {
            l = this.getNativeViewPtr(lWComponentPeer);
            this.nativeNotifyPeer(l, cInputMethod);
        }
        this.fAwtFocussedComponent = component;
        this.fAwtFocussedComponentPeer = this.getNearestNativePeer(component);
    }

    public static Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        int n;
        int n2 = inputMethodHighlight.getState();
        if (n2 == 0) {
            n = 0;
        } else if (n2 == 1) {
            n = 2;
        } else {
            return null;
        }
        if (inputMethodHighlight.isSelected()) {
            ++n;
        }
        return sHighlightStyles[n];
    }

    @Override
    public void endComposition() {
        if (this.fAwtFocussedComponentPeer != null) {
            this.nativeEndComposition(this.getNativeViewPtr(this.fAwtFocussedComponentPeer));
        }
    }

    @Override
    public void dispose() {
        this.fIMContext = null;
        this.fAwtFocussedComponent = null;
        this.fAwtFocussedComponentPeer = null;
    }

    @Override
    public Object getControlObject() {
        return null;
    }

    private LWComponentPeer getNearestNativePeer(Component component) {
        if (component == null) {
            return null;
        }
        ComponentPeer componentPeer = component.getPeer();
        if (componentPeer == null) {
            return null;
        }
        while (componentPeer instanceof LightweightPeer) {
            if ((component = component.getParent()) == null) {
                return null;
            }
            componentPeer = component.getPeer();
            if (componentPeer != null) continue;
            return null;
        }
        if (componentPeer instanceof LWComponentPeer) {
            return (LWComponentPeer)componentPeer;
        }
        return null;
    }

    private synchronized void insertText(String string) {
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(AttributedCharacterIterator.Attribute.LANGUAGE, this.getLocale(), 0, string.length());
        TextHitInfo textHitInfo = TextHitInfo.afterOffset(string.length() - 1);
        InputMethodEvent inputMethodEvent = new InputMethodEvent(this.fAwtFocussedComponent, 1100, attributedString.getIterator(), string.length(), textHitInfo, textHitInfo);
        LWCToolkit.postEvent(LWCToolkit.targetToAppContext(this.fAwtFocussedComponent), inputMethodEvent);
        this.fCurrentText = null;
        this.fCurrentTextAsString = null;
        this.fCurrentTextLength = 0;
    }

    private void startIMUpdate(String string) {
        this.fCurrentTextAsString = new String(string);
        this.fCurrentText = new AttributedString(this.fCurrentTextAsString);
        this.fCurrentTextLength = string.length();
    }

    private void addAttribute(boolean bl, boolean bl2, int n, int n2) {
        InputMethodHighlight inputMethodHighlight;
        int n3 = n;
        int n4 = n + n2;
        int n5 = 1;
        if (bl && bl2) {
            n5 = 1;
        } else if (!bl && bl2) {
            n5 = 1;
        } else if (bl && !bl2) {
            n5 = 4;
        } else if (!bl && !bl2) {
            n5 = 3;
        }
        switch (n5) {
            case 2: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            case 3: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 4: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            default: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_RAW_TEXT_HIGHLIGHT;
            }
        }
        this.fCurrentText.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, inputMethodHighlight, n3, n4);
    }

    private void selectPreviousGlyph() {
        if (this.fIMContext == null) {
            return;
        }
        try {
            LWCToolkit.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = CInputMethod.this.fIMContext.getInsertPositionOffset();
                    if (n < 1) {
                        return;
                    }
                    if (CInputMethod.this.fAwtFocussedComponent instanceof JTextComponent) {
                        ((JTextComponent)CInputMethod.this.fAwtFocussedComponent).select(n - 1, n);
                        return;
                    }
                    if (CInputMethod.this.fAwtFocussedComponent instanceof TextComponent) {
                        ((TextComponent)CInputMethod.this.fAwtFocussedComponent).select(n - 1, n);
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void selectNextGlyph() {
        if (this.fIMContext == null || !(this.fAwtFocussedComponent instanceof JTextComponent)) {
            return;
        }
        try {
            LWCToolkit.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = CInputMethod.this.fIMContext.getInsertPositionOffset();
                    if (n < 0) {
                        return;
                    }
                    ((JTextComponent)CInputMethod.this.fAwtFocussedComponent).select(n, n + 1);
                }
            }, this.fAwtFocussedComponent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void dispatchText(int n, int n2, boolean bl) {
        if (this.fCurrentText == null) {
            return;
        }
        TextHitInfo textHitInfo = n2 == 0 ? TextHitInfo.beforeOffset(n) : null;
        TextHitInfo textHitInfo2 = TextHitInfo.beforeOffset(0);
        InputMethodEvent inputMethodEvent = new InputMethodEvent(this.fAwtFocussedComponent, 1100, this.fCurrentText.getIterator(), 0, textHitInfo, textHitInfo2);
        LWCToolkit.postEvent(LWCToolkit.targetToAppContext(this.fAwtFocussedComponent), inputMethodEvent);
        if (bl) {
            this.selectNextGlyph();
        }
    }

    private synchronized void unmarkText() {
        TextHitInfo textHitInfo;
        if (this.fCurrentText == null) {
            return;
        }
        TextHitInfo textHitInfo2 = textHitInfo = TextHitInfo.afterOffset(this.fCurrentTextLength);
        InputMethodEvent inputMethodEvent = new InputMethodEvent(this.fAwtFocussedComponent, 1100, this.fCurrentText.getIterator(), this.fCurrentTextLength, textHitInfo, textHitInfo2);
        LWCToolkit.postEvent(LWCToolkit.targetToAppContext(this.fAwtFocussedComponent), inputMethodEvent);
        this.fCurrentText = null;
        this.fCurrentTextAsString = null;
        this.fCurrentTextLength = 0;
    }

    private synchronized boolean hasMarkedText() {
        return this.fCurrentText != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String attributedSubstringFromRange(final int n, final int n2) {
        final String[] stringArray = new String[1];
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String[] stringArray2 = stringArray;
                    synchronized (stringArray) {
                        int n5;
                        int n22 = n;
                        int n3 = n2;
                        if (n22 + n3 > CInputMethod.this.fIMContext.getCommittedTextLength() + CInputMethod.this.fCurrentTextLength) {
                            n3 = CInputMethod.this.fIMContext.getCommittedTextLength() - n22;
                        }
                        AttributedCharacterIterator attributedCharacterIterator = null;
                        attributedCharacterIterator = CInputMethod.this.fCurrentText == null ? CInputMethod.this.fIMContext.getCommittedText(n22, n22 + n3, null) : (n22 < (n5 = CInputMethod.this.fIMContext.getInsertPositionOffset()) ? CInputMethod.this.fIMContext.getCommittedText(n22, n22 + n3, null) : (n22 >= n5 && n22 < n5 + CInputMethod.this.fCurrentTextLength ? CInputMethod.this.fCurrentText.getIterator(null, n22 - n5, n22 - n5 + n3) : CInputMethod.this.fIMContext.getCommittedText(n22 - CInputMethod.this.fCurrentTextLength, n22 - CInputMethod.this.fCurrentTextLength + n3, null)));
                        char[] cArray = new char[attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex()];
                        char c = attributedCharacterIterator.first();
                        int n4 = 0;
                        while (c != '\uffff') {
                            cArray[n4++] = c;
                            c = attributedCharacterIterator.next();
                        }
                        stringArray[0] = new String(cArray);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        String[] stringArray2 = stringArray;
        synchronized (stringArray) {
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return stringArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int[] selectedRange() {
        final int[] nArray = new int[2];
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int[] nArray2 = nArray;
                    synchronized (nArray) {
                        int n;
                        AttributedCharacterIterator attributedCharacterIterator = CInputMethod.this.fIMContext.getSelectedText(null);
                        if (attributedCharacterIterator == null) {
                            nArray[0] = CInputMethod.this.fIMContext.getInsertPositionOffset();
                            nArray[1] = 0;
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                        if (CInputMethod.this.fAwtFocussedComponent instanceof JTextComponent) {
                            JTextComponent jTextComponent = (JTextComponent)CInputMethod.this.fAwtFocussedComponent;
                            n = jTextComponent.getSelectionStart();
                        } else if (CInputMethod.this.fAwtFocussedComponent instanceof TextComponent) {
                            TextComponent textComponent = (TextComponent)CInputMethod.this.fAwtFocussedComponent;
                            n = textComponent.getSelectionStart();
                        } else {
                            n = CInputMethod.this.fIMContext.getInsertPositionOffset() - (attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex());
                            if (n < 0) {
                                n = CInputMethod.this.fIMContext.getInsertPositionOffset() + (attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex());
                            }
                        }
                        nArray[0] = n;
                        nArray[1] = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        int[] nArray2 = nArray;
        synchronized (nArray) {
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int[] markedRange() {
        if (this.fCurrentText == null) {
            return null;
        }
        final int[] nArray = new int[2];
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int[] nArray2 = nArray;
                    synchronized (nArray) {
                        nArray[0] = CInputMethod.this.fIMContext.getInsertPositionOffset();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        nArray[1] = this.fCurrentTextLength;
        int[] nArray2 = nArray;
        synchronized (nArray) {
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int[] firstRectForCharacterRange(final int n) {
        final int[] nArray = new int[4];
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int[] nArray2 = nArray;
                    synchronized (nArray) {
                        Rectangle rectangle;
                        int n4 = CInputMethod.this.fIMContext.getInsertPositionOffset();
                        int n2 = n - n4;
                        if (n2 < 0) {
                            n2 = 0;
                        }
                        Rectangle rectangle2 = CInputMethod.this.fIMContext.getTextLocation(TextHitInfo.beforeOffset(n2));
                        nArray[0] = rectangle2.x;
                        nArray[1] = rectangle2.y;
                        nArray[2] = rectangle2.width;
                        nArray[3] = rectangle2.height;
                        if (n2 > 0 && CInputMethod.this.fAwtFocussedComponent instanceof JTextComponent && rectangle2.equals(rectangle = CInputMethod.this.fIMContext.getTextLocation(TextHitInfo.beforeOffset(0)))) {
                            String string = CInputMethod.this.fCurrentTextAsString.substring(0, n2);
                            Graphics graphics = CInputMethod.this.fAwtFocussedComponent.getGraphics();
                            int n3 = graphics.getFontMetrics().stringWidth(string);
                            nArray[0] = nArray[0] + n3;
                            graphics.dispose();
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        int[] nArray2 = nArray;
        synchronized (nArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return nArray;
        }
    }

    private synchronized int characterIndexForPoint(final int n, final int n2) {
        final TextHitInfo[] textHitInfoArray = new TextHitInfo[1];
        final int[] nArray = new int[1];
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TextHitInfo[] textHitInfoArray2 = textHitInfoArray;
                    synchronized (textHitInfoArray) {
                        textHitInfoArray[0] = CInputMethod.this.fIMContext.getLocationOffset(n, n2);
                        nArray[0] = CInputMethod.this.fIMContext.getInsertPositionOffset();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (textHitInfoArray[0] == null) {
            return nArray[0];
        }
        int n3 = textHitInfoArray[0].getCharIndex() + nArray[0];
        if (textHitInfoArray[0].getCharIndex() == this.fCurrentTextLength) {
            --n3;
        }
        return n3;
    }

    @Override
    public void disableInputMethod() {
    }

    @Override
    public String getNativeInputMethodInfo() {
        return CInputMethod.nativeGetCurrentInputMethodInfo();
    }

    private native void nativeNotifyPeer(long var1, CInputMethod var3);

    private native void nativeEndComposition(long var1);

    private native void nativeHandleEvent(LWComponentPeer var1, AWTEvent var2);

    static native Locale getNativeLocale();

    static native boolean setNativeLocale(String var0, boolean var1);

    static native String nativeGetCurrentInputMethodInfo();

    static native void nativeInit();

    static {
        Map[] mapArray = new Map[4];
        HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY);
        mapArray[0] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY);
        mapArray[1] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        mapArray[2] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL);
        mapArray[3] = Collections.unmodifiableMap(hashMap);
        sHighlightStyles = mapArray;
        CInputMethod.nativeInit();
    }
}

